/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.custom.AbstractMatrix;
import org.genemania.engine.matricks.custom.FlexFloatArray;
import org.genemania.engine.matricks.custom.FlexFloatColMatrix;

public class Outer2View
extends AbstractMatrix
implements Matrix {
    int numRows;
    int numCols;
    FlexFloatArray newRowData;
    FlexFloatArray newColumnData;
    double scale;
    boolean zeroDiag;

    public static Outer2View fromColumn(Matrix backingMatrix, int backingColumn, int[] rowIndices, int[] columnIndices, double scale, boolean zeroDiag) {
        if (backingMatrix instanceof FlexFloatColMatrix) {
            FlexFloatColMatrix m = (FlexFloatColMatrix)backingMatrix;
            FlexFloatArray backing = m.getColumn(backingColumn);
            return new Outer2View(backing, rowIndices, columnIndices, scale, zeroDiag);
        }
        throw new RuntimeException("matrix type not supported: " + backingMatrix.getClass().getName());
    }

    public Outer2View(FlexFloatArray backing, int[] rowIndices, int[] columnIndices, double scale, boolean zeroDiag) {
        float val;
        int index;
        this.numRows = rowIndices.length;
        this.numCols = columnIndices.length;
        this.scale = scale;
        this.zeroDiag = zeroDiag;
        if (zeroDiag) {
            throw new RuntimeException("zeroDiag not supported, yet");
        }
        int[] commonRowIndices = Outer2View.getCommonIndices(rowIndices, rowIndices.length, backing.indices, backing.used);
        int[] commonColumnIndices = Outer2View.getCommonIndices(columnIndices, columnIndices.length, backing.indices, backing.used);
        int[] positionsRow = Outer2View.getPositionsOfCommonIndicesOfAInB(rowIndices, rowIndices.length, backing.indices, backing.used);
        int[] positionsCol = Outer2View.getPositionsOfCommonIndicesOfAInB(columnIndices, columnIndices.length, backing.indices, backing.used);
        this.newRowData = new FlexFloatArray();
        for (index = 0; index < commonRowIndices.length; ++index) {
            val = (float)backing.get(commonRowIndices[index]);
            this.newRowData.set(positionsRow[index], val);
        }
        this.newColumnData = new FlexFloatArray();
        for (index = 0; index < commonColumnIndices.length; ++index) {
            val = (float)backing.get(commonColumnIndices[index]);
            this.newColumnData.set(positionsCol[index], val);
        }
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    @Override
    public double get(int row, int col) {
        return this.scale * this.newRowData.get(row) * this.newColumnData.get(col);
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        throw new RuntimeException("read-only");
    }

    @Override
    public MatrixCursor cursor() {
        return new MatrixCursor(){
            int i = -1;
            int j = 0;
            final int k;
            final int l;
            {
                this.k = Outer2View.this.newRowData.used - 1;
                this.l = Outer2View.this.newColumnData.used - 1;
            }

            @Override
            public boolean next() {
                if (this.i < this.k) {
                    ++this.i;
                    return true;
                }
                if (this.j < this.l) {
                    this.i = 0;
                    ++this.j;
                    return true;
                }
                return false;
            }

            @Override
            public int row() {
                return Outer2View.this.newRowData.indices[this.i];
            }

            @Override
            public int col() {
                return Outer2View.this.newColumnData.indices[this.j];
            }

            @Override
            public double val() {
                return Outer2View.this.scale * (double)Outer2View.this.newRowData.data[this.i] * (double)Outer2View.this.newColumnData.data[this.j];
            }

            @Override
            public void set(double val) {
                throw new RuntimeException("read-only");
            }
        };
    }

    @Override
    public void mult(double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }
}

