/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.custom.AbstractMatrix;
import org.genemania.engine.matricks.custom.FlexFloatArray;

public class OuterProductFlexFloatSymMatrix
extends AbstractMatrix
implements SymMatrix {
    final int size;
    FlexFloatArray data;
    double scale;
    boolean zeroDiag;

    public OuterProductFlexFloatSymMatrix(int size, FlexFloatArray data, double scale, boolean zeroDiag) {
        this.size = size;
        this.data = data;
        this.scale = scale;
        this.zeroDiag = zeroDiag;
    }

    @Override
    public int numRows() {
        return this.size;
    }

    @Override
    public int numCols() {
        return this.size;
    }

    @Override
    public double get(int row, int col) {
        if (row == col) {
            return 0.0;
        }
        double result = this.data.get(row);
        if (result != 0.0) {
            return this.scale * result * this.data.get(col);
        }
        return 0.0;
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public MatrixCursor cursor() {
        return new MatrixCursor(){
            int i = -1;
            int j = 0;

            @Override
            public boolean next() {
                if (this.i < OuterProductFlexFloatSymMatrix.this.data.used) {
                    ++this.i;
                    return true;
                }
                if (this.j < OuterProductFlexFloatSymMatrix.this.data.used) {
                    this.i = 0;
                    ++this.j;
                    return true;
                }
                return false;
            }

            @Override
            public int row() {
                return OuterProductFlexFloatSymMatrix.this.data.indices[this.i];
            }

            @Override
            public int col() {
                return OuterProductFlexFloatSymMatrix.this.data.indices[this.j];
            }

            @Override
            public double val() {
                if (OuterProductFlexFloatSymMatrix.this.zeroDiag && this.i == this.j) {
                    return 0.0;
                }
                return OuterProductFlexFloatSymMatrix.this.scale * (double)OuterProductFlexFloatSymMatrix.this.data.data[this.i] * (double)OuterProductFlexFloatSymMatrix.this.data.data[this.j];
            }

            @Override
            public void set(double val) {
                throw new RuntimeException("read-only");
            }
        };
    }

    @Override
    public void multAdd(double alpha, double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void mult(double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public SymMatrix subMatrix(int[] rowcols) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Matrix subMatrix(int[] rows, int[] cols) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setDiag(double alpha) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void addOuterProd(double[] x) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double sumDotMultOuterProd(double[] x) {
        throw new RuntimeException("not implemented");
    }
}

