/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.summary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.support.DataConnector;
import org.genemania.engine.core.data.AttributeData;
import org.genemania.engine.core.data.AttributeGroups;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.summary.PreferredNames;
import org.genemania.engine.summary.Reporter;
import org.genemania.engine.summary.ReporterFactory;
import org.genemania.engine.summary.Summarizer;
import org.genemania.exception.ApplicationException;

public class AttributesDumper
implements Summarizer {
    private static Logger logger = Logger.getLogger(AttributesDumper.class);
    Organism organism;
    DataConnector dataConnector;
    PreferredNames preferredNames;
    Map<String, Integer> countsByGroup;
    int uniqueNetworks;
    ReporterFactory reporterFactory;
    Reporter interactionReporter;

    public AttributesDumper(Organism organism, DataConnector dataConnector, PreferredNames preferredNames) throws Exception {
        this.organism = organism;
        this.dataConnector = dataConnector;
        this.preferredNames = preferredNames;
    }

    @Override
    public void setUp() throws Exception {
        this.countsByGroup = new HashMap<String, Integer>();
        this.uniqueNetworks = 0;
    }

    @Override
    public void summarize(ReporterFactory reporterFactory) throws Exception {
        this.reporterFactory = reporterFactory;
        List groups = this.dataConnector.getAttributeMediator().findAttributeGroupsByOrganism(this.organism.getId());
        for (AttributeGroup group : groups) {
            this.summarizeGroup(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void summarizeGroup(AttributeGroup group) throws ApplicationException {
        String name = this.makeFileName(group);
        logger.info((Object)("Summarizing " + name));
        Reporter reporter = this.reporterFactory.getReporter(name);
        try {
            reporter.init(new String[0]);
            NodeIds nodeIds = this.dataConnector.getCache().getNodeIds(this.organism.getId());
            AttributeGroups groupData = this.dataConnector.getCache().getAttributeGroups("CORE", this.organism.getId());
            AttributeData attributes = this.dataConnector.getCache().getAttributeData("CORE", this.organism.getId(), group.getId());
            Matrix data = attributes.getData();
            int numGenes = data.numRows();
            int numAttributes = data.numCols();
            for (int i = 0; i < numGenes; ++i) {
                long nodeId = nodeIds.getIdForIndex(i);
                String geneSymbol = this.preferredNames.getName(nodeId);
                ArrayList<String> record = new ArrayList<String>();
                record.add(geneSymbol);
                record.add("n/a");
                for (int j = 0; j < numAttributes; ++j) {
                    if (data.get(i, j) != 1.0) continue;
                    long attributeId = groupData.getAttributeIdForIndex(group.getId(), j);
                    String attributeName = this.dataConnector.getAttributeMediator().findAttribute(this.organism.getId(), attributeId).getExternalId();
                    record.add(attributeName);
                }
                if (record.size() <= 2) continue;
                reporter.write(record);
            }
        }
        finally {
            reporter.close();
        }
    }

    public void dumpGroup(AttributeGroup group, AttributeData attributes, String name) throws ApplicationException {
    }

    String makeFileName(AttributeGroup group) {
        return "Attributes." + group.getName();
    }

    @Override
    public void tearDown() throws Exception {
    }
}

