/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.summary;

import java.util.List;
import org.apache.log4j.Logger;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.support.DataConnector;
import org.genemania.engine.summary.Reporter;
import org.genemania.engine.summary.ReporterFactory;
import org.genemania.engine.summary.Summarizer;

public class OrganismsSummarizer
implements Summarizer {
    private static Logger logger = Logger.getLogger(OrganismsSummarizer.class);
    DataConnector dataConnector;

    public OrganismsSummarizer(DataConnector dataConnector) {
        this.dataConnector = dataConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void summarize(ReporterFactory reporterFactory) throws Exception {
        logger.info((Object)"summarizing organisms");
        Reporter reporter = reporterFactory.getReporter("organisms");
        reporter.init("Id", "Name", "Taxonomy ID");
        try {
            List organisms = this.dataConnector.getOrganismMediator().getAllOrganisms();
            for (Organism organism : organisms) {
                reporter.write("" + organism.getId(), organism.getName(), "" + organism.getTaxonomyId());
            }
        }
        finally {
            reporter.close();
        }
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown() throws Exception {
    }
}

