/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.validation;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Scanner;
import java.util.StringTokenizer;

public class GeneAnnotator {
    private static String ensemblURL = "jdbc:mysql://localhost:3306/go";
    private static String driver = "com.mysql.jdbc.Driver";
    private static Connection con;

    public static void connectToEnsembl() {
        try {
            Class.forName(driver);
            con = DriverManager.getConnection(ensemblURL, "genemania", "password");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.print("JDBC Driver " + driver + " not found in CLASSPATH");
        }
    }

    public static ResultSet executeQuery(String query) {
        try {
            Statement stmt = con.createStatement();
            return stmt.executeQuery(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getDatabaseID(String synonyms, int speciesID) {
        try {
            String[] symbols;
            for (String symbol : symbols = synonyms.split(" \\| ")) {
                String query = "SELECT dbxref_id FROM gene_product WHERE symbol =\"" + symbol + "\" and species_id = " + speciesID;
                ResultSet rs = GeneAnnotator.executeQuery(query);
                if (!rs.next()) continue;
                return rs.getInt(1);
            }
            System.out.println("symbol" + synonyms + " in derby not found in GO database");
            return -1;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String[] getDatabaseInfo(int dbID) {
        try {
            String query = "SELECT xref_dbname, xref_key FROM dbxref WHERE id =" + dbID;
            ResultSet rs = GeneAnnotator.executeQuery(query);
            if (rs.next()) {
                String[] s = new String[]{rs.getString(1), rs.getString(2)};
                return s;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int[] getOrganismIDs(String[] orgName) {
        try {
            String query = "SELECT id, ncbi_taxa_id FROM species WHERE genus =\"" + orgName[0] + "\" and species =\"" + orgName[1] + "\"";
            ResultSet rs = GeneAnnotator.executeQuery(query);
            rs.next();
            int[] i = new int[]{rs.getInt(1), rs.getInt(2)};
            return i;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            Scanner sc = new Scanner(new File(args[0]));
            sc.nextLine();
            GeneAnnotator.connectToEnsembl();
            while (sc.hasNextLine()) {
                String symbols;
                String line = sc.nextLine();
                String[] tokens = line.split("\t");
                String synonyms = tokens[1];
                String geneName = synonyms.split(" \\| ")[0];
                if (synonyms.length() > geneName.length()) {
                    symbols = synonyms.substring(geneName.length() + 2);
                    StringTokenizer st = new StringTokenizer(symbols, " ");
                    synonyms = "";
                    while (st.hasMoreTokens()) {
                        synonyms = synonyms + st.nextToken();
                    }
                } else {
                    symbols = "";
                }
                String[] orgName = tokens[2].split(" ");
                String goTerm = tokens[3];
                int[] orgIDs = GeneAnnotator.getOrganismIDs(orgName);
                String taxon = "taxon:" + orgIDs[1];
                String[] dbInfo = GeneAnnotator.getDatabaseInfo(GeneAnnotator.getDatabaseID(tokens[1], orgIDs[0]));
                if (dbInfo == null) continue;
                String reference = "PMID:18613948";
                String evidenceCode = "IEA";
                String withFrom = goTerm;
                String goBranch = tokens[6];
                String aspect = goBranch.equals("cellular_component") ? "C" : (goBranch.equals("biological_process") ? "P" : "F");
                String objectType = "gene";
                Calendar c = Calendar.getInstance();
                String year = "" + c.get(1);
                String month = "" + (c.get(2) + 1);
                String day = "" + c.get(5);
                month = month.length() > 1 ? month : "0" + month;
                day = day.length() > 1 ? day : "0" + day;
                String date = year + month + day;
                String assignedBy = "GeneMANIA";
                String geneAnnotation = dbInfo[0] + "\t" + dbInfo[1] + "\t" + geneName + "\t\t" + goTerm + "\t" + reference + "\t" + evidenceCode + "\t" + withFrom + "\t" + aspect + "\t\t" + synonyms + "\t" + objectType + "\t" + taxon + "\t" + date + "\t" + assignedBy;
                System.out.println(geneAnnotation);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

