/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.validation;

import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.validation.EvaluationMeasure;

public class PrecisionFixedRecall
extends EvaluationMeasure {
    private double recallRate;

    public PrecisionFixedRecall(String name, double recall) {
        super(name);
        this.recallRate = recall / 100.0;
    }

    @Override
    public double computeResult(boolean[] classes, double[] scores) {
        MatrixUtils.mergeSort(scores, classes);
        int totalPos = this.countPositives(classes);
        int cumPosCounts = 0;
        for (int i = 1; i <= classes.length; ++i) {
            double recall;
            if (classes[classes.length - i]) {
                ++cumPosCounts;
            }
            if (!((recall = (double)cumPosCounts / (double)totalPos) >= this.recallRate)) continue;
            return (double)cumPosCounts / (double)i;
        }
        return 0.0;
    }

    private int countPositives(boolean[] label) {
        int pos = 0;
        for (boolean value : label) {
            if (!value) continue;
            ++pos;
        }
        return pos;
    }
}

