/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.completion.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.genemania.completion.lucene.GeneCompletionProvider;
import org.genemania.completion.lucene.IndexBuilder;
import org.genemania.domain.Gene;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.GeneMediator;
import org.genemania.mediator.lucene.LuceneMediator;
import org.genemania.util.ProgressReporter;

public class GeneIndexBuilder
extends IndexBuilder {
    public static final String GENE_FIELD = "gene";
    public static final String NODE_ID_FIELD = "node";
    String basePath;
    Collection<Organism> organisms;
    GeneMediator geneMediator;
    Organism organism;

    public GeneIndexBuilder(String basePath, GeneMediator geneMediator) {
        this(basePath, null, geneMediator);
    }

    public GeneIndexBuilder(String basePath, Collection<Organism> organisms, GeneMediator geneMediator) {
        this.basePath = basePath;
        this.organisms = organisms;
        this.geneMediator = geneMediator;
    }

    public void setOrganisms(Collection<Organism> organisms) {
        this.organisms = organisms;
    }

    public void setGeneMediator(GeneMediator geneMediator) {
        this.geneMediator = geneMediator;
    }

    IndexReader getIndexReader(Organism organism) throws IOException {
        String path = this.getIndexPath(organism);
        FSDirectory directory = FSDirectory.open((File)new File(path));
        return IndexReader.open((Directory)directory, (boolean)true);
    }

    private String getIndexPath(Organism organism) {
        String ret = "";
        if (organism != null) {
            ret = String.format("%s", organism.getId());
            if (this.basePath != null) {
                ret = String.format("%s%s%s", this.basePath, File.separator, organism.getId());
            }
        }
        return ret;
    }

    public void createIndex(ProgressReporter progress) throws ApplicationException {
        Analyzer analyzer = this.createAnalyzer();
        int total = this.organisms.size();
        int index = 1;
        for (Organism organism : this.organisms) {
            if (progress.isCanceled()) break;
            progress.setStatus(String.format("Indexing organism %d/%d", index, total));
            String path = this.getIndexPath(organism);
            this.organism = organism;
            this.createIndex(path, analyzer, progress);
            ++index;
        }
    }

    @Override
    protected void createIndex(IndexWriter writer, ProgressReporter progress) throws ApplicationException {
        List<Gene> genes = this.geneMediator.getAllGenes(this.organism.getId());
        int total = genes.size();
        int index = 0;
        progress.setMaximumProgress(total);
        try {
            for (Gene gene : genes) {
                if (progress.isCanceled()) {
                    return;
                }
                Node node = gene.getNode();
                long nodeId = node.getId();
                progress.setProgress(index);
                Document document = new Document();
                document.add((Fieldable)new Field(NODE_ID_FIELD, String.valueOf(nodeId), Field.Store.YES, Field.Index.ANALYZED));
                document.add((Fieldable)new Field(GENE_FIELD, gene.getSymbol(), Field.Store.YES, Field.Index.ANALYZED));
                writer.addDocument(document);
                ++index;
            }
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    public GeneCompletionProvider createCompletionProvider(Organism organism, ProgressReporter progress, boolean rebuild) throws ApplicationException {
        Analyzer analyzer = this.createAnalyzer();
        String indexPath = this.getIndexPath(organism);
        File indexFile = new File(indexPath);
        if (!indexFile.exists()) {
            if (!rebuild) {
                throw new ApplicationException(String.format("Index not found: %s", indexFile.getPath()));
            }
            this.organism = organism;
            this.createIndex(indexPath, analyzer, progress);
        }
        if (progress.isCanceled()) {
            return null;
        }
        try {
            IndexReader reader = this.getIndexReader(organism);
            return new GeneCompletionProvider(reader, analyzer);
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    @Override
    protected Analyzer createAnalyzer() {
        return LuceneMediator.createDefaultAnalyzer();
    }
}

