/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.completion.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public abstract class IndexBuilder {
    protected Analyzer createAnalyzer() {
        return new StandardAnalyzer(Version.LUCENE_29);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(String path, Directory source, Analyzer analyzer, IndexWriter.MaxFieldLength length) throws IOException {
        FSDirectory directory = FSDirectory.open((File)new File(path));
        try {
            IndexReader reader = IndexReader.open((Directory)source, (boolean)true);
            try {
                IndexWriter writer = new IndexWriter((Directory)directory, analyzer, length);
                try {
                    writer.addIndexes(new IndexReader[]{reader});
                }
                finally {
                    writer.close();
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            directory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createIndex(String indexPath, Analyzer analyzer, ProgressReporter progress) throws ApplicationException {
        try {
            RAMDirectory directory = new RAMDirectory();
            IndexWriter writer = new IndexWriter((Directory)directory, analyzer, IndexWriter.MaxFieldLength.LIMITED);
            try {
                this.createIndex(writer, progress);
            }
            finally {
                writer.close();
            }
            if (progress.isCanceled()) {
                return;
            }
            this.write(indexPath, (Directory)directory, analyzer, IndexWriter.MaxFieldLength.LIMITED);
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    protected abstract void createIndex(IndexWriter var1, ProgressReporter var2) throws ApplicationException;
}

