/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.connector;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.genemania.exception.ApplicationException;

public class DataStoreConnector {
    private String filename;
    private Properties storage;
    private String keyValueSeparator = "|";
    private String itemSeparator = "||";

    public DataStoreConnector(String filename) {
        this.filename = filename;
        this.storage = new Properties();
    }

    public void put(String masterKey, Map<String, String> data) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iterator = data.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            String val = data.get(key);
            buffer.append(key);
            buffer.append(this.keyValueSeparator);
            buffer.append(val);
            if (!iterator.hasNext()) continue;
            buffer.append(this.itemSeparator);
        }
        this.storage.put(masterKey, buffer.toString());
    }

    public void save() throws ApplicationException {
        FileOutputStream fos = null;
        try {
            File file = new File(this.filename);
            if (!file.exists()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            this.storage.store(fos, String.valueOf(System.currentTimeMillis()));
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

