/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.data.normalizer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.data.normalizer.INormalizer;
import org.genemania.data.normalizer.NormalizationResult;
import org.genemania.data.normalizer.Strings;
import org.genemania.data.profile.ProfileCursor;
import org.genemania.data.profile.SoftProfileCursor;
import org.genemania.exception.ApplicationException;
import org.genemania.type.DataLayout;
import org.genemania.util.ProgressReporter;

public class GeoProfileNormalizer
implements INormalizer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NormalizationResult normalize(DataImportSettings settings, GeneCompletionProvider2 genes, Reader input, Writer output, ProgressReporter progress) throws IOException, ApplicationException {
        PrintWriter writer = new PrintWriter(output);
        HashSet<String> invalidSymbols = new HashSet<String>();
        int keptRows = 0;
        int droppedRows = 0;
        try {
            ProfileCursor cursor = GeoProfileNormalizer.createProfileCursor(settings, input);
            for (int i = 0; i < cursor.getTotalHeaders(); ++i) {
                if (progress.isCanceled()) {
                    NormalizationResult normalizationResult = null;
                    return normalizationResult;
                }
                if (i > 0) {
                    writer.print("\t");
                }
                writer.print(cursor.getHeader(i));
            }
            writer.println();
            try {
                while (true) {
                    if (cursor.next()) {
                        if (progress.isCanceled()) {
                            NormalizationResult i = null;
                            return i;
                        }
                        progress.setDescription(String.format(Strings.installProfile_description, keptRows, droppedRows));
                        String symbol = cursor.getId();
                        Long nodeId = genes.getNodeId(symbol);
                        if (nodeId == null) {
                            invalidSymbols.add(symbol);
                            ++droppedRows;
                            continue;
                        }
                        writer.print(nodeId);
                        for (int i = 0; i < cursor.getTotalValues(); ++i) {
                            writer.print("\t");
                            double value = cursor.getValue(i);
                            if (Double.isNaN(value) || Double.isInfinite(value)) {
                                writer.print("null");
                                continue;
                            }
                            writer.print(value);
                        }
                        writer.println();
                        ++keptRows;
                        continue;
                    }
                    break;
                }
            }
            finally {
                cursor.close();
            }
        }
        finally {
            writer.close();
        }
        settings.setDataLayout(DataLayout.PROFILE);
        NormalizationResult result = new NormalizationResult();
        result.setDroppedEntries(droppedRows);
        result.setTotalEntries(keptRows);
        result.setInvalidSymbols(invalidSymbols);
        return result;
    }

    private static ProfileCursor createProfileCursor(DataImportSettings settings, Reader reader) throws IOException, ApplicationException {
        return new SoftProfileCursor(reader);
    }
}

