/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.domain;

import java.util.Collection;
import java.util.LinkedList;
import org.genemania.domain.Gene;
import org.genemania.domain.ResultAttribute;
import org.genemania.domain.ResultOntologyCategory;

public class ResultGene
implements Comparable {
    private Gene gene;
    private double score;
    boolean queryGene;
    private Collection<ResultOntologyCategory> resultOntologyCategories = new LinkedList<ResultOntologyCategory>();
    private Collection<ResultAttribute> resultAttributes = new LinkedList<ResultAttribute>();
    private Collection<Link> links = new LinkedList<Link>();
    private String typedName;

    public ResultGene() {
    }

    public ResultGene(Gene gene, double score, boolean queryGene, Collection<Link> links, String typedName) {
        this.gene = gene;
        this.score = score;
        this.queryGene = queryGene;
        this.links = links;
        this.typedName = typedName;
    }

    public Collection<Link> getLinks() {
        return this.links;
    }

    public void setLinks(Collection<Link> links) {
        this.links = links;
    }

    public Gene getGene() {
        return this.gene;
    }

    public void setGene(Gene gene) {
        this.gene = gene;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public boolean isQueryGene() {
        return this.queryGene;
    }

    public void setQueryGene(boolean queryGene) {
        this.queryGene = queryGene;
    }

    public Collection<ResultOntologyCategory> getResultOntologyCategories() {
        return this.resultOntologyCategories;
    }

    public void setResultOntologyCategories(Collection<ResultOntologyCategory> resultOntologyCategories) {
        this.resultOntologyCategories = resultOntologyCategories;
    }

    public String getTypedName() {
        return this.typedName;
    }

    public void setTypedName(String typedName) {
        this.typedName = typedName;
    }

    public Collection<ResultAttribute> getResultAttributes() {
        return this.resultAttributes;
    }

    public void setResultAttributes(Collection<ResultAttribute> attrbiutes) {
        this.resultAttributes = attrbiutes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resultAttributes == null ? 0 : this.resultAttributes.hashCode());
        result = 31 * result + (this.gene == null ? 0 : this.gene.hashCode());
        result = 31 * result + (this.links == null ? 0 : this.links.hashCode());
        result = 31 * result + (this.queryGene ? 1231 : 1237);
        result = 31 * result + (this.resultOntologyCategories == null ? 0 : this.resultOntologyCategories.hashCode());
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.typedName == null ? 0 : this.typedName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResultGene other = (ResultGene)obj;
        if (this.resultAttributes == null ? other.resultAttributes != null : !this.resultAttributes.equals(other.resultAttributes)) {
            return false;
        }
        if (this.gene == null ? other.gene != null : !this.gene.equals(other.gene)) {
            return false;
        }
        if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
            return false;
        }
        if (this.queryGene != other.queryGene) {
            return false;
        }
        if (this.resultOntologyCategories == null ? other.resultOntologyCategories != null : !this.resultOntologyCategories.equals(other.resultOntologyCategories)) {
            return false;
        }
        if (Double.doubleToLongBits(this.score) != Double.doubleToLongBits(other.score)) {
            return false;
        }
        return !(this.typedName == null ? other.typedName != null : !this.typedName.equals(other.typedName));
    }

    public String toString() {
        return "ResultGene [gene=" + this.gene + ", score=" + this.score + ", queryGene=" + this.queryGene + ", resultOntologyCategories=" + this.resultOntologyCategories + ", attrbiutes=" + this.resultAttributes + ", links=" + this.links + ", typedName=" + this.typedName + "]";
    }

    public int compareTo(Object o) {
        if (o instanceof ResultGene) {
            ResultGene other = (ResultGene)o;
            if (this.getScore() < other.getScore()) {
                return 1;
            }
            if (this.getScore() > other.getScore()) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    public static class Link {
        private String name;
        private String url;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Link(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }

        public String toString() {
            return "Link [name=" + this.name + ", url=" + this.url + "]";
        }
    }
}

