/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.domain;

import java.util.Collection;
import java.util.LinkedList;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Gene;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.Organism;
import org.genemania.type.CombiningMethod;

public class SearchParameters {
    private Organism organism;
    private CombiningMethod weighting;
    private int resultsSize;
    private int attributeResultsSize;
    private String namespace;
    private Collection<InteractionNetwork> networks = new LinkedList<InteractionNetwork>();
    private Collection<Gene> genes = new LinkedList<Gene>();
    private Collection<AttributeGroup> attributeGroups = new LinkedList<AttributeGroup>();

    public SearchParameters() {
    }

    public SearchParameters(Organism organism, Collection<Gene> genes, Collection<InteractionNetwork> networks, Collection<AttributeGroup> attributeGroups, CombiningMethod weighting, int resultsSize, int attrResultsSize, String namespace) {
        this.organism = organism;
        this.weighting = weighting;
        this.resultsSize = resultsSize;
        this.networks = networks;
        this.attributeGroups = attributeGroups;
        this.genes = genes;
        this.namespace = namespace;
        this.attributeResultsSize = attrResultsSize;
    }

    public int getAttributeResultsSize() {
        return this.attributeResultsSize;
    }

    public void setAttributeResultsSize(int attributeResultsSize) {
        this.attributeResultsSize = attributeResultsSize;
    }

    public Organism getOrganism() {
        return this.organism;
    }

    public void setOrganismId(Organism organism) {
        this.organism = organism;
    }

    public CombiningMethod getWeighting() {
        return this.weighting;
    }

    public void setWeighting(CombiningMethod weighting) {
        this.weighting = weighting;
    }

    public int getResultsSize() {
        return this.resultsSize;
    }

    public void setResultsSize(int resultsSize) {
        this.resultsSize = resultsSize;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setOrganism(Organism organism) {
        this.organism = organism;
    }

    public Collection<InteractionNetwork> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Collection<InteractionNetwork> networks) {
        this.networks = networks;
    }

    public Collection<Gene> getGenes() {
        return this.genes;
    }

    public void setGenes(Collection<Gene> genes) {
        this.genes = genes;
    }

    public Collection<AttributeGroup> getAttributeGroups() {
        return this.attributeGroups;
    }

    public void setAttributeGroups(Collection<AttributeGroup> attributeGroups) {
        this.attributeGroups = attributeGroups;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeGroups == null ? 0 : this.attributeGroups.hashCode());
        result = 31 * result + this.attributeResultsSize;
        result = 31 * result + (this.genes == null ? 0 : this.genes.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.networks == null ? 0 : this.networks.hashCode());
        result = 31 * result + (this.organism == null ? 0 : this.organism.hashCode());
        result = 31 * result + this.resultsSize;
        result = 31 * result + (this.weighting == null ? 0 : this.weighting.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchParameters other = (SearchParameters)obj;
        if (this.attributeGroups == null ? other.attributeGroups != null : !this.attributeGroups.equals(other.attributeGroups)) {
            return false;
        }
        if (this.attributeResultsSize != other.attributeResultsSize) {
            return false;
        }
        if (this.genes == null ? other.genes != null : !this.genes.equals(other.genes)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.networks == null ? other.networks != null : !this.networks.equals(other.networks)) {
            return false;
        }
        if (this.organism == null ? other.organism != null : !this.organism.equals(other.organism)) {
            return false;
        }
        if (this.resultsSize != other.resultsSize) {
            return false;
        }
        return this.weighting == other.weighting;
    }

    public String toString() {
        return "SearchParameters [organism=" + this.organism + ", weighting=" + this.weighting + ", resultsSize=" + this.resultsSize + ", attributeResultsSize=" + this.attributeResultsSize + ", namespace=" + this.namespace + ", networks=" + this.networks + ", genes=" + this.genes + ", attributeGroups=" + this.attributeGroups + "]";
    }
}

