/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.util;

import org.genemania.util.ProgressReporter;

public class ChildProgressReporter
implements ProgressReporter {
    private ProgressReporter parent;
    private State initialState;
    private State current;

    public ChildProgressReporter(ProgressReporter parent) {
        this.parent = parent;
        this.initialState = new State(parent);
        this.current = new State();
    }

    public void close() {
        ++this.initialState.progress;
        this.initialState.apply(this.parent);
    }

    @Override
    public void cancel() {
        this.parent.cancel();
    }

    @Override
    public String getDescription() {
        return this.parent.getDescription();
    }

    @Override
    public int getMaximumProgress() {
        return this.current.maximum;
    }

    @Override
    public int getProgress() {
        return this.current.progress;
    }

    @Override
    public String getStatus() {
        return this.current.status;
    }

    @Override
    public boolean isCanceled() {
        return this.parent.isCanceled();
    }

    @Override
    public void setDescription(String description) {
        this.current.description = description;
        this.parent.setDescription(description);
    }

    @Override
    public void setMaximumProgress(int maximum) {
        this.current.maximum = maximum;
        this.parent.setMaximumProgress(this.initialState.maximum * maximum);
    }

    @Override
    public void setProgress(int progress) {
        this.current.progress = progress;
        this.parent.setProgress(this.initialState.progress * this.current.maximum + this.current.progress);
    }

    @Override
    public void setStatus(String status) {
        this.current.status = status;
        this.parent.setStatus(status);
    }

    static class State {
        String status;
        String description;
        int maximum;
        int progress;

        public State(ProgressReporter reporter) {
            this.status = reporter.getStatus();
            this.description = reporter.getDescription();
            this.maximum = reporter.getMaximumProgress();
            this.progress = reporter.getProgress();
        }

        public State() {
            this.maximum = 100;
            this.progress = 0;
        }

        public void apply(ProgressReporter reporter) {
            reporter.setStatus(this.status);
            reporter.setDescription(this.description);
            reporter.setMaximumProgress(this.maximum);
            reporter.setProgress(this.progress);
        }
    }
}

