/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import org.ut.biolab.medsavant.client.app.api.AppInfoFetcher;
import org.ut.biolab.medsavant.client.app.api.AppInstaller;
import org.ut.biolab.medsavant.client.app.page.AppStoreInstalledPage;
import org.ut.biolab.medsavant.client.app.page.AppStoreLandingPage;
import org.ut.biolab.medsavant.client.view.component.LazyPanel;
import org.ut.biolab.medsavant.client.view.component.MSTabbedPaneUI;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

class AppStoreView
extends JDialog {
    private final AppInfoFetcher fetcher;
    private final AppInstaller installer;

    public AppStoreView(String title, AppInfoFetcher fetcher, AppInstaller installer) {
        this.setTitle(title);
        this.setModal(true);
        this.setMinimumSize(new Dimension(600, 600));
        this.setLocationRelativeTo(null);
        this.fetcher = fetcher;
        this.installer = installer;
        this.initView();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    private void initView() {
        JTabbedPane tabs = new JTabbedPane(){
            private int selectedIndex = -1;

            @Override
            public Color getForegroundAt(int index) {
                if (this.getSelectedIndex() == index) {
                    return Color.BLACK;
                }
                return new Color(40, 40, 40);
            }

            @Override
            public void setSelectedIndex(int index) {
                LazyPanel p;
                if (this.selectedIndex != -1 && this.getComponentAt(this.selectedIndex) instanceof LazyPanel) {
                    p = (LazyPanel)this.getComponentAt(this.selectedIndex);
                    p.viewDidUnload();
                }
                if (this.getComponentAt(index) instanceof LazyPanel) {
                    p = (LazyPanel)this.getComponentAt(index);
                    p.viewDidLoad();
                }
                this.selectedIndex = index;
                super.setSelectedIndex(index);
            }
        };
        tabs.setUI(new MSTabbedPaneUI());
        tabs.setFocusable(false);
        tabs.setBackground(ViewUtil.getLightGrayBackgroundColor());
        AppStoreInstalledPage installedAppsPage = new AppStoreInstalledPage(this.installer);
        AppStoreLandingPage landingPage = new AppStoreLandingPage(this.fetcher, this.installer, tabs, installedAppsPage);
        tabs.add(landingPage.getName(), landingPage.getView());
        tabs.add(installedAppsPage.getName(), installedAppsPage.getView());
        this.setLayout(new BorderLayout());
        this.add((Component)tabs, "Center");
        tabs.setSelectedIndex(0);
    }
}

