/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.app.api;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.app.api.AppNotInitializedException;
import org.ut.biolab.medsavant.client.user.UserController;
import org.ut.biolab.medsavant.client.user.UserEvent;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.format.UserRole;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.UserLevel;

public class AppRoleManagerBuilder {
    private static Log LOG = LogFactory.getLog(AppRoleManagerBuilder.class);
    private final List<RoleInfo> roleInfo = new ArrayList<RoleInfo>();
    private final Set<String> defaultRoleNames = new HashSet<String>();
    private boolean assignRolesByUserLevel = true;

    public AppRoleManagerBuilder addDefaultRole(String shortName, String description, Set<UserLevel> userlevels) {
        RoleInfo ri = new RoleInfo(shortName, description, userlevels);
        this.roleInfo.add(ri);
        this.defaultRoleNames.add(shortName);
        return this;
    }

    public AppRoleManagerBuilder addRole(String shortName, String description, Set<UserLevel> userlevels) {
        this.roleInfo.add(new RoleInfo(shortName, description, userlevels));
        return this;
    }

    public AppRoleManagerBuilder autoAssignRolesToExistingUsers(boolean f) {
        this.assignRolesByUserLevel = f;
        return this;
    }

    public AppRoleManager build() throws SQLException, SessionExpiredException, RemoteException, SecurityException, AppNotInitializedException {
        return new AppRoleManager(this.defaultRoleNames);
    }

    public class AppRoleManager
    implements Listener<UserEvent> {
        private final Map<UserLevel, Set<UserRole>> userLevelRoleMap = new EnumMap<UserLevel, Set<UserRole>>(UserLevel.class);
        private final Set<UserRole> rolesForThisUser;
        private final Set<String> defaultRoleNames;

        private AppRoleManager(Set<String> defaultRoleNames) throws SQLException, SessionExpiredException, RemoteException, SecurityException, AppNotInitializedException {
            boolean allRolesWereNew = false;
            if (LoginController.getInstance().getUserLevel() == UserLevel.ADMIN) {
                allRolesWereNew = this.createRoles();
            }
            this.initRoleMaps();
            if (AppRoleManagerBuilder.this.assignRolesByUserLevel && allRolesWereNew) {
                String[] usersForThisDatabase;
                for (String user : usersForThisDatabase = MedSavantClient.UserManager.getUserNames(LoginController.getSessionID())) {
                    UserLevel l = MedSavantClient.UserManager.getUserLevel(LoginController.getSessionID(), user);
                    this.setRoleForUser(user, l);
                }
            }
            this.rolesForThisUser = MedSavantClient.UserManager.getRolesForUser(LoginController.getSessionID());
            this.defaultRoleNames = defaultRoleNames;
            UserController.getInstance().addListener(this);
        }

        private boolean createRoles() throws SQLException, SessionExpiredException, RemoteException, SecurityException {
            int n = 0;
            for (RoleInfo ri : AppRoleManagerBuilder.this.roleInfo) {
                UserRole r = MedSavantClient.UserManager.getRoleByName(LoginController.getSessionID(), ri.shortname);
                if (r != null) continue;
                MedSavantClient.UserManager.addRole(LoginController.getSessionID(), ri.shortname, ri.description);
                ++n;
            }
            if (AppRoleManagerBuilder.this.assignRolesByUserLevel && n > 0 && n < AppRoleManagerBuilder.this.roleInfo.size()) {
                LOG.info((Object)"Some roles used by an App already existed, and some did not.  Users will not be autoassigned roles based on their userlevel.");
            }
            return n == AppRoleManagerBuilder.this.roleInfo.size();
        }

        private void initRoleMaps() throws AppNotInitializedException, SQLException, SessionExpiredException, RemoteException, SecurityException {
            HashMap<String, RoleInfo> appRoleMap = new HashMap<String, RoleInfo>();
            for (RoleInfo ri : AppRoleManagerBuilder.this.roleInfo) {
                appRoleMap.put(ri.shortname, ri);
            }
            Set<UserRole> allRoles = MedSavantClient.UserManager.getAllRoles(LoginController.getSessionID());
            for (UserRole role : allRoles) {
                if (!appRoleMap.keySet().contains(role.getRoleName())) continue;
                RoleInfo ri = (RoleInfo)appRoleMap.get(role.getRoleName());
                if (ri.userlevels != null) {
                    for (UserLevel l : ri.userlevels) {
                        Set<UserRole> roleSet = this.userLevelRoleMap.get((Object)l);
                        if (roleSet == null) {
                            roleSet = new HashSet<UserRole>();
                        }
                        roleSet.add(role);
                        this.userLevelRoleMap.put(l, roleSet);
                    }
                }
                appRoleMap.remove(role.getRoleName());
            }
            if (appRoleMap.size() > 0) {
                throw new AppNotInitializedException("Cannot initialize role manager for app -- roles missing from database: " + StringUtils.join(appRoleMap.keySet().iterator(), (String)","));
            }
        }

        private void setRoleForUser(String user, UserLevel l) {
            if (LoginController.getInstance().getUserLevel() == UserLevel.ADMIN) {
                if (l == UserLevel.ADMIN || l == UserLevel.GUEST || l == UserLevel.USER) {
                    try {
                        this.clearRolesForUser(user);
                        Set<UserRole> rolesToRegister = this.userLevelRoleMap.get((Object)l);
                        if (rolesToRegister != null) {
                            MedSavantClient.UserManager.registerRoleForUser(LoginController.getSessionID(), user, rolesToRegister);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Unable to register new role for user ", (Throwable)ex);
                    }
                } else {
                    LOG.error((Object)("Unexpected user level " + (Object)((Object)l) + ". " + this.getClass().getName() + " will not modify user roles."));
                }
            } else {
                LOG.error((Object)"Unexpected user change event from non-admin user");
            }
        }

        @Override
        public void handleEvent(UserEvent event) {
            if (event.getType() == UserEvent.Type.ADDED) {
                this.setRoleForUser(event.getName(), event.getUserLevel());
            } else if (event.getType() == UserEvent.Type.REMOVED) {
                try {
                    this.clearRolesForUser(event.getName());
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            } else {
                LOG.error((Object)("Unexpected UserEvent type " + (Object)((Object)event.getType())));
            }
        }

        private void clearRolesForUser(String username) throws RemoteException, SQLException, SessionExpiredException, SecurityException {
            for (Set<UserRole> roles : this.userLevelRoleMap.values()) {
                MedSavantClient.UserManager.dropRolesForUser(LoginController.getSessionID(), username, roles);
            }
        }

        public boolean checkRole(String roleName) {
            if (this.defaultRoleNames.contains(roleName)) {
                return true;
            }
            for (UserRole role : this.rolesForThisUser) {
                if (!role.getRoleName().equals(roleName)) continue;
                return true;
            }
            return false;
        }

        public boolean checkRole(UserRole r) {
            if (this.defaultRoleNames.contains(r.getRoleName())) {
                return true;
            }
            for (UserRole role : this.rolesForThisUser) {
                if (!role.equals(r)) continue;
                return true;
            }
            return false;
        }
    }

    private class RoleInfo {
        private final String shortname;
        private final String description;
        private final Set<UserLevel> userlevels;

        public RoleInfo(String shortname, String description, Set<UserLevel> userlevels) {
            this.shortname = shortname;
            this.description = description;
            this.userlevels = userlevels;
        }
    }
}

