/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.controller;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.VersionSettings;
import savant.util.CryptoUtils;

public class SettingsController {
    private static final Log LOG = LogFactory.getLog(SettingsController.class);
    private static SettingsController instance;
    private static final String DELIM = "=";
    private static final String PERSISTENCE_FILE_PATH = ".medsavant.prop";
    public static final String KEY_VERSION = "medsavant.version";
    public static final String KEY_AUTOLOGIN = "general.autologin";
    public static final String KEY_REMEMBER_PASSWORD = "user.rememberpass";
    public static final String KEY_USERNAME = "user.name";
    public static final String KEY_PASSWORD = "user.password";
    public static final String KEY_DB_DRIVER = "db.driver";
    public static final String KEY_DB_NAME = "db.name";
    public static final String KEY_SERVER_ADDRESS = "server.address";
    public static final String KEY_SERVER_PORT = "server.port";
    Map<String, String> persistenceMap = new TreeMap<String, String>();

    public static String booleanToString(boolean bool) {
        return bool ? "true" : "false";
    }

    public static boolean stringToBoolean(String str) {
        return str.equals("true");
    }

    public static SettingsController getInstance() {
        if (instance == null) {
            instance = new SettingsController();
        }
        return instance;
    }

    public SettingsController() {
        this.readPersistenceMap();
    }

    public void setValue(String key, String value) {
        this.setValueSilent(key, value);
        this.savePersistenceMap();
    }

    private void setValueSilent(String key, String value) {
        if (value == null) {
            this.persistenceMap.remove(key);
        } else {
            this.persistenceMap.put(key, value);
        }
    }

    public String getValue(String key) {
        if (!this.persistenceMap.containsKey(key)) {
            return SettingsController.getDefaultValue(key);
        }
        return this.persistenceMap.get(key);
    }

    public boolean getBoolean(String key, boolean dflt) {
        String value = this.getValue(key);
        return value != null ? value.toLowerCase().equals("true") : dflt;
    }

    public void setBoolean(String key, boolean value) {
        this.setValue(key, Boolean.toString(value));
    }

    public File getFile(String key) {
        String value = this.getValue(key);
        return value != null ? new File(value) : null;
    }

    public void setFile(String key, File value) {
        this.setValue(key, value.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPersistenceMap() {
        File pFile = new File(DirectorySettings.getMedSavantDirectory(), PERSISTENCE_FILE_PATH);
        if (!pFile.exists()) {
            this.resetPersistenceMap();
        } else {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(pFile));
                while ((line = br.readLine()) != null) {
                    int splitIndex = line.indexOf(DELIM);
                    String key = line.substring(0, splitIndex);
                    String value = line.substring(splitIndex + 1);
                    this.setValueSilent(key, value);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error reading .medsavant.prop", (Throwable)ex);
                this.resetPersistenceMap();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void resetPersistenceMap() {
        this.persistenceMap.clear();
        this.resetSettingSilent(KEY_USERNAME);
        this.resetSettingSilent(KEY_PASSWORD);
        this.resetSettingSilent(KEY_REMEMBER_PASSWORD);
        this.resetSettingSilent(KEY_AUTOLOGIN);
        this.resetSettingSilent(KEY_DB_DRIVER);
        this.resetSettingSilent(KEY_DB_NAME);
        this.resetSettingSilent(KEY_SERVER_ADDRESS);
        this.resetSettingSilent(KEY_SERVER_PORT);
        this.savePersistenceMap();
    }

    private void resetSettingSilent(String key) {
        this.setValueSilent(key, SettingsController.getDefaultValue(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePersistenceMap() {
        BufferedWriter bw = null;
        try {
            File pFile = new File(DirectorySettings.getMedSavantDirectory(), PERSISTENCE_FILE_PATH);
            bw = new BufferedWriter(new FileWriter(pFile));
            for (String key : this.persistenceMap.keySet()) {
                bw.write(key + DELIM + this.persistenceMap.get(key) + "\n");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error writing .medsavant.prop.", (Throwable)ex);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getDefaultValue(String key) {
        if (key.equals(KEY_USERNAME)) {
            return "";
        }
        if (key.equals(KEY_VERSION)) {
            return VersionSettings.getVersionString();
        }
        if (key.equals(KEY_PASSWORD)) {
            return "";
        }
        if (key.equals(KEY_REMEMBER_PASSWORD)) {
            return SettingsController.booleanToString(true);
        }
        if (key.equals(KEY_AUTOLOGIN)) {
            return SettingsController.booleanToString(false);
        }
        if (key.equals(KEY_DB_DRIVER)) {
            return "com.mysql.jdbc.Driver";
        }
        if (key.equals(KEY_SERVER_ADDRESS)) {
            return "";
        }
        if (key.equals(KEY_SERVER_PORT)) {
            return "";
        }
        if (key.equals(KEY_DB_NAME)) {
            return "";
        }
        return null;
    }

    public void setRememberPassword(boolean b) {
        this.setValue(KEY_REMEMBER_PASSWORD, SettingsController.booleanToString(b));
    }

    public boolean getRememberPassword() {
        return SettingsController.stringToBoolean(this.getValue(KEY_REMEMBER_PASSWORD));
    }

    public void setAutoLogin(boolean b) {
        this.setValue(KEY_AUTOLOGIN, SettingsController.booleanToString(b));
    }

    public boolean getAutoLogin() {
        return SettingsController.stringToBoolean(this.getValue(KEY_AUTOLOGIN));
    }

    public void setUsername(String str) {
        this.setValue(KEY_USERNAME, str);
    }

    public String getUsername() {
        return this.getValue(KEY_USERNAME);
    }

    public void setPassword(String str) {
        this.setValue(KEY_PASSWORD, CryptoUtils.encrypt((String)str));
    }

    public String getPassword() {
        return CryptoUtils.decrypt((String)this.getValue(KEY_PASSWORD));
    }

    public String getDBDriver() {
        return this.getValue(KEY_DB_DRIVER);
    }

    public String getDBName() {
        return this.getValue(KEY_DB_NAME);
    }

    public void setDBName(String name) {
        this.setValue(KEY_DB_NAME, name);
    }

    public String getServerAddress() {
        return this.getValue(KEY_SERVER_ADDRESS);
    }

    public void setServerAddress(String address) {
        this.setValue(KEY_SERVER_ADDRESS, address);
    }

    public String getServerPort() {
        return this.getValue(KEY_SERVER_PORT);
    }

    public void setServerPort(String port) {
        this.setValue(KEY_SERVER_PORT, port);
    }
}

