/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.importing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.ut.biolab.medsavant.client.importing.ImportFileView;
import org.ut.biolab.medsavant.client.util.DataRetriever;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.SearchableTablePanel;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.util.PathField;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.importing.FileFormat;
import org.ut.biolab.medsavant.shared.importing.ImportDelimitedFile;

public class ImportFilePanel
extends JPanel {
    private char delimiter = (char)9;
    private boolean importAccepted;
    private PathField pathField;
    private JComboBox formatComboBox;
    private int numHeaderLines = 0;
    private final HashMap<String, FileFormat> formatMap;
    private JPanel previewPanel;
    private WaitPanel waitPanel = new WaitPanel("Generating preview");
    private PreviewWorker worker;

    public ImportFilePanel() {
        this(0);
    }

    public ImportFilePanel(int numHeaderLines) {
        this.numHeaderLines = numHeaderLines;
        this.initGUI();
        this.importAccepted = false;
        this.formatMap = new HashMap();
    }

    private void initGUI() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        JPanel h1 = new JPanel();
        h1.setBorder(ViewUtil.getMediumBorder());
        h1.setLayout(new BoxLayout(h1, 1));
        JPanel delimiterBarPanel = new JPanel();
        delimiterBarPanel.setOpaque(false);
        delimiterBarPanel.setLayout(new BoxLayout(delimiterBarPanel, 0));
        delimiterBarPanel.add(Box.createHorizontalGlue());
        ButtonGroup delimiterBG = new ButtonGroup();
        this.addDelimiterRadioButton("Tab", '\t', delimiterBarPanel, delimiterBG, true);
        this.addDelimiterRadioButton("Space", ' ', delimiterBarPanel, delimiterBG, false);
        this.addDelimiterRadioButton("Comma", ',', delimiterBarPanel, delimiterBG, false);
        delimiterBarPanel.add(Box.createHorizontalGlue());
        h1.add(ViewUtil.getCenterAlignedComponent(ViewUtil.getDialogLabel("Delimiter")));
        h1.add(delimiterBarPanel);
        h1.add(ViewUtil.getSmallVerticalSeparator());
        h1.add(ViewUtil.getCenterAlignedComponent(ViewUtil.getDialogLabel("Format")));
        this.formatComboBox = new JComboBox();
        h1.add(this.formatComboBox);
        h1.add(ViewUtil.getSmallVerticalSeparator());
        h1.add(ViewUtil.getCenterAlignedComponent(ViewUtil.getDialogLabel("File")));
        this.pathField = new PathField(0);
        this.pathField.getPathArea().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImportFilePanel.this.updatePreview();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImportFilePanel.this.updatePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        h1.add(this.pathField);
        h1.add(ViewUtil.getSmallVerticalSeparator());
        h1.add(ViewUtil.getCenterAlignedComponent(ViewUtil.getDialogLabel("Preview")));
        h1.add(Box.createVerticalGlue());
        h1.setOpaque(false);
        this.add((Component)h1, "North");
        this.previewPanel = new JPanel();
        this.previewPanel.setLayout(new BorderLayout());
        this.previewPanel.setPreferredSize(new Dimension(1000, 1000));
        this.previewPanel.setBorder(ViewUtil.getTinyLineBorder());
        this.add((Component)this.previewPanel, "Center");
        this.updatePreview();
    }

    private void addDelimiterRadioButton(String string, final char delim, JPanel delimiterBarPanel, ButtonGroup delimiterBG, boolean defaultSelected) {
        JRadioButton rb = new JRadioButton(string);
        rb.setOpaque(false);
        delimiterBarPanel.add(rb);
        delimiterBG.add(rb);
        rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportFilePanel.this.setDelimiter(delim);
            }
        });
        if (defaultSelected) {
            rb.setSelected(true);
            this.setDelimiter(delim);
        }
    }

    private void setDelimiter(char delim) {
        this.delimiter = delim;
        this.updatePreview();
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public boolean isImportAccepted() {
        return this.importAccepted;
    }

    public boolean validateForm() {
        return this.pathField.getFile().exists();
    }

    public void addFileFormat(FileFormat f) {
        this.formatComboBox.addItem(f.getName());
        this.formatMap.put(f.getName(), f);
        this.formatComboBox.updateUI();
    }

    public void updatePreview() {
        if (this.pathField == null) {
            return;
        }
        String path = this.pathField.getPath();
        File file = new File(path);
        this.previewPanel.removeAll();
        if (path.equals("")) {
            this.previewPanel.add((Component)new JLabel("No file to preview.", 0), "Center");
            this.setReady(false);
        } else if (!file.exists() || !file.isFile()) {
            this.previewPanel.add((Component)new JLabel("No file at path.", 0), "Center");
            this.setReady(false);
        } else {
            this.worker = new PreviewWorker();
            this.worker.execute();
        }
        this.previewPanel.updateUI();
    }

    public FileFormat getFileFormat() {
        return this.formatMap.get((String)this.formatComboBox.getSelectedItem());
    }

    public String getPath() {
        return this.pathField.getPath();
    }

    public int getNumHeaderLines() {
        return this.numHeaderLines;
    }

    public void setReady(boolean ready) {
    }

    class PreviewWorker
    extends MedSavantWorker<List<String[]>> {
        private static final int NUM_LINES = 50;

        PreviewWorker() {
            super("X");
            if (ImportFilePanel.this.worker != null) {
                ImportFilePanel.this.worker.cancel(true);
                ImportFilePanel.this.worker = null;
            }
        }

        @Override
        protected List<String[]> doInBackground() throws Exception {
            this.showProgress(-1.0);
            return ImportDelimitedFile.getPreview(ImportFilePanel.this.pathField.getPath(), ImportFilePanel.this.getDelimiter(), ImportFilePanel.this.numHeaderLines, 50, ImportFilePanel.this.getFileFormat())[1];
        }

        @Override
        protected void showSuccess(List<String[]> data) {
            int[] fields = ImportFilePanel.this.getFileFormat().getRequiredFieldIndexes();
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<Class> columnClasses = new ArrayList<Class>();
            for (int i : fields) {
                columnNames.add(ImportFilePanel.this.getFileFormat().getFieldNumberToFieldNameMap().get(i));
                columnClasses.add(ImportFilePanel.this.getFileFormat().getFieldNumberToClassMap().get(i));
            }
            SearchableTablePanel searchableTablePanel = new SearchableTablePanel(ImportFileView.class.getName(), columnNames.toArray(new String[0]), columnClasses.toArray(new Class[0]), new int[0], false, false, 50, false, SearchableTablePanel.TableSelectionType.ROW, 1000, DataRetriever.createPrefetchedDataRetriever(data));
            searchableTablePanel.forceRefreshData();
            ImportFilePanel.this.previewPanel.add((Component)searchableTablePanel, "Center");
            ImportFilePanel.this.previewPanel.updateUI();
            ImportFilePanel.this.importAccepted = true;
            ImportFilePanel.this.setReady(true);
        }

        @Override
        protected void showProgress(double fraction) {
            if (fraction < 0.0) {
                ImportFilePanel.this.previewPanel.add(ImportFilePanel.this.waitPanel);
            } else if (fraction >= 1.0) {
                ImportFilePanel.this.worker = null;
                ImportFilePanel.this.previewPanel.remove(ImportFilePanel.this.waitPanel);
            }
        }

        @Override
        protected void showFailure(Throwable t) {
            ImportFilePanel.this.previewPanel.removeAll();
            ImportFilePanel.this.previewPanel.add((Component)new JLabel("<html><center><font color=\"#ff0000\">Problem generating preview.<br>Please check that the file is formatted correctly.</font></center></html>", 0), "Center");
            ImportFilePanel.this.previewPanel.updateUI();
            ImportFilePanel.this.importAccepted = false;
            ImportFilePanel.this.setReady(false);
        }
    }
}

