/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.ontology;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.FilterStateAdapter;
import org.ut.biolab.medsavant.client.filter.Filter;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterState;
import org.ut.biolab.medsavant.client.filter.TabularFilterView;
import org.ut.biolab.medsavant.client.ontology.OntologyFilter;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.OntologyTerm;
import org.ut.biolab.medsavant.shared.model.OntologyType;

public class OntologyFilterView
extends TabularFilterView<OntologyTerm> {
    private final OntologyType ontology;

    public OntologyFilterView(FilterState state, int queryID) throws Exception {
        this(OntologyFilter.filterIDToOntology(state.getFilterID()), queryID);
        List<String> values = state.getValues("value");
        if (values != null) {
            this.setFilterValues(values);
        }
    }

    public OntologyFilterView(OntologyType ont, int queryID) throws Exception {
        super(OntologyFilter.ontologyToTitle(ont), queryID);
        this.ontology = ont;
        new MedSavantWorker<Void>("FilterView"){

            @Override
            protected void showProgress(double fract) {
            }

            @Override
            protected void showSuccess(Void result) {
                OntologyFilterView.this.initContentPanel();
            }

            @Override
            protected Void doInBackground() throws Exception {
                OntologyTerm[] terms = MedSavantClient.OntologyManager.getAllTerms(LoginController.getSessionID(), OntologyFilterView.this.ontology);
                OntologyFilterView.this.setAvailableValues(Arrays.asList(terms));
                return null;
            }
        }.execute();
    }

    public static FilterState wrapState(String title, OntologyType ont, List<OntologyTerm> applied, boolean shortForm) {
        String filterID = OntologyFilter.ontologyToFilterID(ont);
        List<OntologyTerm> values = applied;
        if (shortForm) {
            values = new ArrayList<OntologyTerm>();
            for (OntologyTerm t : applied) {
                values.add((OntologyTerm)((Object)t.getID()));
            }
        }
        FilterState state = new FilterState(Filter.Type.ONTOLOGY, title, filterID);
        state.putValues("value", OntologyFilterView.wrapValues(values));
        return state;
    }

    @Override
    public FilterStateAdapter saveState() {
        return OntologyFilterView.wrapState(this.getTitle(), this.ontology, this.appliedValues, true);
    }

    @Override
    protected void applyFilter() {
        this.preapplyFilter();
        FilterController.getInstance().addFilter(new OntologyFilter(this.appliedValues, this.ontology), this.queryID);
    }
}

