/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.project;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.PageList;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.CompletionWizardPage;
import com.jidesoft.wizard.DefaultWizardPage;
import com.jidesoft.wizard.WizardDialog;
import com.jidesoft.wizard.WizardStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.project.ProjectEvent;
import org.ut.biolab.medsavant.client.reference.NewReferenceDialog;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.ProjectWorker;
import org.ut.biolab.medsavant.client.view.component.ProgressWheel;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.Annotation;
import org.ut.biolab.medsavant.shared.model.ProjectDetails;
import org.ut.biolab.medsavant.shared.model.Reference;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.ProjectManagerAdapter;

public class ProjectWizard
extends WizardDialog
implements BasicPatientColumns,
BasicVariantColumns {
    private static final Log LOG = LogFactory.getLog(ProjectWizard.class);
    private static final String PAGENAME_NAME = "Project Name";
    private static final String PAGENAME_PATIENTS = "Patients";
    private static final String PAGENAME_VCF = "Custom VCF Fields";
    private static final String PAGENAME_REF = "Reference";
    private static final String PAGENAME_NOTIFICATIONS = "Notifications";
    private static final String PAGENAME_COMPLETE = "Finish";
    private static String PAGENAME_CREATE = "Create";
    private final boolean modify;
    private boolean isModified = false;
    private final int projectID;
    private final String originalProjectName;
    private String projectName;
    private CustomField[] customFields;
    private final ProjectDetails[] projectDetails;
    private DefaultTableModel patientFormatModel;
    private DefaultTableModel variantFormatModel;
    private CustomField[] variantFields;
    private List<CheckListItem> checkListItems = new ArrayList<CheckListItem>();
    private boolean variantFieldsChanged = false;
    private final ProjectManagerAdapter manager;
    private JTextField emailField;
    private JCheckBox autoPublish;

    public ProjectWizard(int projID, String projName, CustomField[] fields, ProjectDetails[] details) throws SQLException, RemoteException {
        this.modify = true;
        this.projectID = projID;
        this.originalProjectName = projName;
        this.projectName = projName;
        this.customFields = fields;
        this.projectDetails = details;
        PAGENAME_CREATE = "Modify";
        this.manager = MedSavantClient.ProjectManager;
        this.setupWizard();
    }

    public ProjectWizard() throws SQLException, RemoteException {
        this.modify = false;
        this.projectID = -1;
        this.originalProjectName = null;
        this.projectDetails = new ProjectDetails[0];
        this.manager = MedSavantClient.ProjectManager;
        this.setupWizard();
    }

    private void setupWizard() throws SQLException, RemoteException {
        this.setTitle(this.modify ? "Modify Project" : "Create Project");
        WizardStyle.setStyle((int)3);
        PageList model = new PageList();
        model.append((AbstractDialogPage)this.getNamePage());
        model.append((AbstractDialogPage)this.getPatientFieldsPage());
        model.append((AbstractDialogPage)this.getVCFFieldsPage());
        model.append((AbstractDialogPage)this.getReferencePage());
        if (this.modify) {
            model.append((AbstractDialogPage)this.getNotificationsPage());
            model.append((AbstractDialogPage)this.getCreatePage());
        }
        model.append((AbstractDialogPage)this.getCompletionPage());
        this.setPageList(model);
        this.setNextAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String pagename = ProjectWizard.this.getCurrentPage().getTitle();
                    if (pagename.equals(ProjectWizard.PAGENAME_NAME) && ProjectWizard.this.validateProjectName()) {
                        ProjectWizard.this.setCurrentPage(ProjectWizard.PAGENAME_PATIENTS);
                    } else if (pagename.equals(ProjectWizard.PAGENAME_PATIENTS) && ProjectWizard.this.validatePatientFormatModel()) {
                        ProjectWizard.this.setCurrentPage(ProjectWizard.PAGENAME_VCF);
                    } else if (pagename.equals(ProjectWizard.PAGENAME_VCF) && ProjectWizard.this.validateVariantFormatModel()) {
                        ProjectWizard.this.setCurrentPage(ProjectWizard.PAGENAME_REF);
                    } else if (pagename.equals(ProjectWizard.PAGENAME_REF) && ProjectWizard.this.validateReferences()) {
                        if (ProjectWizard.this.modify) {
                            ProjectWizard.this.setCurrentPage(ProjectWizard.PAGENAME_NOTIFICATIONS);
                        } else {
                            ProjectWizard.this.setCurrentPage(ProjectWizard.PAGENAME_COMPLETE);
                        }
                    } else if (pagename.equals(ProjectWizard.PAGENAME_NOTIFICATIONS)) {
                        ProjectWizard.this.setCurrentPage(PAGENAME_CREATE);
                    } else if (pagename.equals(PAGENAME_CREATE)) {
                        ProjectWizard.this.setCurrentPage(ProjectWizard.PAGENAME_COMPLETE);
                    }
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Unable to proceed: %s", ex);
                }
            }
        });
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(null);
    }

    private AbstractWizardPage getNamePage() {
        final DefaultWizardPage page = new DefaultWizardPage(PAGENAME_NAME){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3300, "BACK");
                if (ProjectWizard.this.projectName == null || ProjectWizard.this.projectName.equals("")) {
                    this.fireButtonEvent(3302, "NEXT");
                } else {
                    this.fireButtonEvent(3301, "NEXT");
                }
            }
        };
        page.addText("Choose a name for the project. \nThe name cannot already be in use. ");
        final JTextField namefield = new JTextField();
        namefield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (namefield.getText() != null && !namefield.getText().equals("")) {
                    ProjectWizard.this.projectName = namefield.getText();
                    page.fireButtonEvent(3301, "NEXT");
                } else {
                    page.fireButtonEvent(3302, "NEXT");
                }
            }
        });
        page.addComponent((JComponent)namefield);
        if (this.modify) {
            namefield.setText(this.projectName);
        }
        return page;
    }

    private AbstractWizardPage getPatientFieldsPage() {
        DefaultWizardPage page = new DefaultWizardPage(PAGENAME_PATIENTS){

            public void setupWizardButtons() {
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3301, "BACK");
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
        page.addText("Add relevant fields for patients. ");
        JScrollPane scrollpane = new JScrollPane();
        scrollpane.setPreferredSize(new Dimension(300, 250));
        scrollpane.getViewport().setBackground(Color.white);
        final JTable table = new JTable(){

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 2) {
                    return Boolean.class;
                }
                return String.class;
            }
        };
        this.patientFormatModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return row >= 8;
            }
        };
        this.patientFormatModel.addColumn("Name");
        this.patientFormatModel.addColumn("Type");
        this.patientFormatModel.addColumn("Filterable");
        this.patientFormatModel.addColumn("Alias");
        this.patientFormatModel.addColumn("Description");
        this.patientFormatModel.addRow(new Object[]{FAMILY_ID.getColumnName(), FAMILY_ID.getTypeString(), true, FAMILY_ID.getAlias(), ""});
        this.patientFormatModel.addRow(new Object[]{HOSPITAL_ID.getColumnName(), HOSPITAL_ID.getTypeString(), true, HOSPITAL_ID.getAlias(), ""});
        this.patientFormatModel.addRow(new Object[]{IDBIOMOM.getColumnName(), IDBIOMOM.getTypeString(), true, IDBIOMOM.getAlias(), ""});
        this.patientFormatModel.addRow(new Object[]{IDBIODAD.getColumnName(), IDBIODAD.getTypeString(), true, IDBIODAD.getAlias(), ""});
        this.patientFormatModel.addRow(new Object[]{GENDER.getColumnName(), GENDER.getTypeString(), true, GENDER.getAlias(), ""});
        this.patientFormatModel.addRow(new Object[]{AFFECTED.getColumnName(), AFFECTED.getTypeString(), true, AFFECTED.getAlias(), ""});
        this.patientFormatModel.addRow(new Object[]{DNA_IDS.getColumnName(), DNA_IDS.getTypeString(), true, DNA_IDS.getAlias(), ""});
        this.patientFormatModel.addRow(new Object[]{BAM_URL.getColumnName(), BAM_URL.getTypeString(), true, BAM_URL.getAlias(), ""});
        this.patientFormatModel.addRow(new Object[]{PHENOTYPES.getColumnName(), PHENOTYPES.getTypeString(), true, PHENOTYPES.getAlias(), ""});
        if (this.modify) {
            for (CustomField f : this.customFields) {
                this.patientFormatModel.addRow(new Object[]{f.getColumnName(), f.getTypeString(), f.isFilterable(), f.getAlias(), f.getDescription()});
            }
        }
        table.setModel(this.patientFormatModel);
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        scrollpane.getViewport().add(table);
        page.addComponent((JComponent)scrollpane);
        JButton addFieldButton = new JButton("Add Field");
        addFieldButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ProjectWizard.this.patientFormatModel.addRow(new Object[5]);
                table.setModel(ProjectWizard.this.patientFormatModel);
            }
        });
        page.addComponent((JComponent)addFieldButton);
        JButton removeFieldButton = new JButton("Remove Field");
        removeFieldButton.setEnabled(false);
        removeFieldButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = table.getSelectedRow();
                if (row >= BasicPatientColumns.REQUIRED_PATIENT_FIELDS.length - 1) {
                    ProjectWizard.this.patientFormatModel.removeRow(row);
                }
                table.setModel(ProjectWizard.this.patientFormatModel);
            }
        });
        table.getSelectionModel().addListSelectionListener(new RemovalEnabler(BasicPatientColumns.REQUIRED_PATIENT_FIELDS.length - 1, removeFieldButton));
        page.addComponent((JComponent)removeFieldButton);
        return page;
    }

    private AbstractWizardPage getVCFFieldsPage() {
        DefaultWizardPage page = new DefaultWizardPage(PAGENAME_VCF){

            public void setupWizardButtons() {
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3301, "BACK");
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
        page.addText("Add extra fields to parse from INFO text in VCF files. ");
        JScrollPane scrollpane = new JScrollPane();
        scrollpane.setPreferredSize(new Dimension(300, 250));
        scrollpane.getViewport().setBackground(Color.white);
        final JTable table = new JTable(){

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 2) {
                    return Boolean.class;
                }
                return String.class;
            }
        };
        this.variantFormatModel = new DefaultTableModel();
        this.variantFormatModel.addColumn("Key");
        this.variantFormatModel.addColumn("Type");
        this.variantFormatModel.addColumn("Filterable");
        this.variantFormatModel.addColumn("Alias");
        this.variantFormatModel.addColumn("Description");
        if (this.modify) {
            try {
                CustomField[] fields;
                int firstRef = this.manager.getReferenceIDsForProject(LoginController.getSessionID(), this.projectID)[0];
                for (CustomField f : fields = this.manager.getCustomVariantFields(LoginController.getSessionID(), this.projectID, firstRef, this.manager.getNewestUpdateID(LoginController.getSessionID(), this.projectID, firstRef, false))) {
                    this.variantFormatModel.addRow(new Object[]{f.getColumnName(), f.getTypeString(), f.isFilterable(), f.getAlias(), f.getDescription()});
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error getting reference IDs for project.", (Throwable)ex);
            }
        } else {
            this.variantFormatModel.addRow(new Object[]{AA.getColumnName(), AA.getTypeString(), true, AA.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{AC.getColumnName(), AC.getTypeString(), true, AC.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{AF.getColumnName(), AF.getTypeString(), true, AF.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{AN.getColumnName(), AN.getTypeString(), true, AN.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{BQ.getColumnName(), BQ.getTypeString(), true, BQ.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{CIGAR.getColumnName(), CIGAR.getTypeString(), true, CIGAR.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{DB.getColumnName(), DB.getTypeString(), true, DB.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{DP.getColumnName(), DP.getTypeString(), true, DP.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{H2.getColumnName(), H2.getTypeString(), true, H2.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{MQ.getColumnName(), MQ.getTypeString(), true, MQ.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{MQ0.getColumnName(), MQ0.getTypeString(), true, MQ0.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{NS.getColumnName(), NS.getTypeString(), true, NS.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{SB.getColumnName(), SB.getTypeString(), true, SB.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{SOMATIC.getColumnName(), SOMATIC.getTypeString(), true, SOMATIC.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{VALIDATED.getColumnName(), VALIDATED.getTypeString(), true, VALIDATED.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{JANNOVAR_EFFECT.getColumnName(), JANNOVAR_EFFECT.getTypeString(), JANNOVAR_EFFECT.isFilterable(), JANNOVAR_EFFECT.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{JANNOVAR_SYMBOL.getColumnName(), JANNOVAR_SYMBOL.getTypeString(), JANNOVAR_SYMBOL.isFilterable(), JANNOVAR_SYMBOL.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{FORMAT.getColumnName(), FORMAT.getTypeString(), FORMAT.isFilterable(), FORMAT.getAlias(), ""});
            this.variantFormatModel.addRow(new Object[]{SAMPLE_INFO.getColumnName(), SAMPLE_INFO.getTypeString(), SAMPLE_INFO.isFilterable(), SAMPLE_INFO.getAlias(), ""});
        }
        table.setModel(this.variantFormatModel);
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        scrollpane.getViewport().add(table);
        page.addComponent((JComponent)scrollpane);
        table.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                ProjectWizard.this.variantFieldsChanged = true;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                ProjectWizard.this.variantFieldsChanged = true;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ProjectWizard.this.variantFieldsChanged = true;
            }
        });
        JButton addFieldButton = new JButton("Add Field");
        addFieldButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ProjectWizard.this.variantFormatModel.addRow(new Object[2]);
                table.setModel(ProjectWizard.this.variantFormatModel);
                ProjectWizard.this.variantFieldsChanged = true;
            }
        });
        page.addComponent((JComponent)addFieldButton);
        JButton removeFieldButton = new JButton("Remove Field");
        removeFieldButton.setEnabled(false);
        removeFieldButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = table.getSelectedRow();
                if (row >= 0) {
                    ProjectWizard.this.variantFormatModel.removeRow(row);
                    table.setModel(ProjectWizard.this.variantFormatModel);
                    ProjectWizard.this.variantFieldsChanged = true;
                }
            }
        });
        table.getSelectionModel().addListSelectionListener(new RemovalEnabler(0, removeFieldButton));
        page.addComponent((JComponent)removeFieldButton);
        return page;
    }

    private String getLengthString(int len) {
        if (len > 0) {
            return "(" + len + ")";
        }
        return "";
    }

    private AbstractWizardPage getReferencePage() throws SQLException, RemoteException {
        DefaultWizardPage page = new DefaultWizardPage(PAGENAME_REF){

            public void setupWizardButtons() {
                this.fireButtonEvent(3301, "BACK");
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
        page.addText("Choose reference genome(s) to add to this project, along\nwith corresponding annotations. Annotations will be\napplied to all variants added to these tables.");
        JScrollPane scrollpane = new JScrollPane();
        scrollpane.setPreferredSize(new Dimension(300, 220));
        scrollpane.getViewport().setBackground(Color.white);
        final JPanel p = new JPanel();
        p.setBackground(Color.white);
        p.setLayout(new BoxLayout(p, 1));
        this.refreshReferencePanel(p);
        scrollpane.getViewport().add(p);
        page.addComponent((JComponent)scrollpane);
        JButton addRefButton = new JButton("New Reference");
        addRefButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                try {
                    new NewReferenceDialog().setVisible(true);
                    ProjectWizard.this.refreshReferencePanel(p);
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Unable to retrieve references and annotations: %s", ex);
                }
            }
        });
        page.addComponent((JComponent)addRefButton);
        return page;
    }

    private void refreshReferencePanel(JPanel p) throws SQLException, RemoteException {
        try {
            Reference[] references = MedSavantClient.ReferenceManager.getReferences(LoginController.getSessionID());
            Annotation[] annotations = MedSavantClient.AnnotationManagerAdapter.getAnnotations(LoginController.getSessionID());
            p.removeAll();
            this.checkListItems.clear();
            for (Reference r : references) {
                CheckListItem cli = new CheckListItem(r, annotations);
                this.checkListItems.add(cli);
                p.add(cli);
            }
            if (this.checkListItems.size() > 0) {
                this.checkListItems.get(this.checkListItems.size() - 1).setSelected(true);
            }
            p.add(Box.createVerticalGlue());
            p.updateUI();
            p.repaint();
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
    }

    private AbstractWizardPage getCreatePage() {
        final DefaultWizardPage page = new DefaultWizardPage(PAGENAME_CREATE){

            public void setupWizardButtons() {
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3302, "NEXT");
            }
        };
        page.addText("You are now ready to " + (this.modify ? "make changes to" : "create") + " this project. ");
        JLabel progressLabel = new JLabel("");
        page.addComponent((JComponent)progressLabel);
        final JButton workButton = new JButton(this.modify ? "Modify Project" : "Create Project");
        JButton publishButton = new JButton("Publish Variants");
        final JLabel j = new JLabel("<html><p>You may continue. The import process will continue in the< background and you will be notified upon completion.</p></html>");
        workButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                j.setVisible(true);
                page.fireButtonEvent(3301, "NEXT");
                workButton.setEnabled(false);
                new ProjectWorker<Void>("Modifying project", ProjectWizard.this.autoPublish.isSelected(), LoginController.getSessionID(), ProjectWizard.this.projectID){

                    @Override
                    protected Void runInBackground() throws Exception {
                        LOG.info((Object)"Requesting modification from server");
                        ProjectWizard.this.modifyProject(true, true, true, this);
                        LOG.info((Object)"Modification complete");
                        return null;
                    }
                }.execute();
                ProjectWizard.this.toFront();
            }
        });
        page.addComponent((JComponent)ViewUtil.alignRight(workButton));
        page.addComponent((JComponent)j);
        j.setVisible(false);
        if (this.modify) {
            page.addComponent((JComponent)ViewUtil.alignRight(publishButton));
            publishButton.setVisible(false);
        }
        return page;
    }

    private AbstractWizardPage getCompletionPage() {
        final ProgressWheel pw = new ProgressWheel();
        final JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        CompletionWizardPage page = new CompletionWizardPage(PAGENAME_COMPLETE){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3300, "NEXT");
                if (ProjectWizard.this.modify) {
                    this.fireButtonEvent(3301, "FINISH");
                } else {
                    this.fireButtonEvent(3300, "FINISH");
                    new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            try {
                                ProjectWizard.this.createNewProject();
                            }
                            catch (Exception e) {
                                DialogUtils.displayException("Error", "Error trying to create project", e);
                                LOG.error((Object)e);
                                e.printStackTrace();
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            pw.setComplete();
                            p.setVisible(true);
                            this.fireButtonEvent(3301, "FINISH");
                            this.revalidate();
                            this.repaint();
                        }
                    }.execute();
                }
            }
        };
        if (this.modify) {
            page.addText("You have completed the project modification process.");
        } else {
            page.addText("Creating project...");
            page.addComponent((JComponent)pw);
            p.add(new JLabel("Complete."));
            p.add(Box.createHorizontalGlue());
            page.addComponent((JComponent)p);
            p.setVisible(false);
        }
        return page;
    }

    private boolean validateProjectName() {
        try {
            if (!this.manager.containsProject(LoginController.getSessionID(), this.projectName) || this.modify && this.projectName.equals(this.originalProjectName)) {
                return true;
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "Project name already in use. ", "Error", 0);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error checking for existence of project.", (Throwable)ex);
            DialogUtils.displayException("Error", "Error trying to create project", ex);
        }
        return false;
    }

    private boolean validateReferences() {
        for (CheckListItem cli : this.checkListItems) {
            if (!cli.isSelected()) continue;
            return true;
        }
        DialogUtils.displayError("You must select at least one reference.");
        return false;
    }

    private boolean validatePatientFormatModel() {
        ArrayList<CustomField> fields = new ArrayList<CustomField>();
        String validationErr = this.validateFormatModel(fields, this.patientFormatModel, BasicPatientColumns.REQUIRED_PATIENT_FIELDS.length - 1);
        if (validationErr == null) {
            this.customFields = fields.toArray(new CustomField[0]);
            return true;
        }
        DialogUtils.displayError(String.format("Individuals table format contains errors\n%s", validationErr));
        return false;
    }

    private boolean validateVariantFormatModel() {
        ArrayList<CustomField> fields = new ArrayList<CustomField>();
        String validationErr = this.validateFormatModel(fields, this.variantFormatModel, 0);
        if (validationErr == null) {
            this.variantFields = fields.toArray(new CustomField[0]);
            return true;
        }
        DialogUtils.displayError(String.format("Variant table format contains errors.\n%s", validationErr));
        return false;
    }

    private String validateFormatModel(List<CustomField> fields, DefaultTableModel model, int firstRow) {
        for (int row = firstRow; row < model.getRowCount(); ++row) {
            String fieldName = (String)model.getValueAt(row, 0);
            String fieldType = (String)model.getValueAt(row, 1);
            Boolean fieldFilterable = (Boolean)model.getValueAt(row, 2);
            String fieldAlias = (String)model.getValueAt(row, 3);
            String fieldDescription = (String)model.getValueAt(row, 4);
            if (fieldName == null || fieldType == null) continue;
            if (!fieldName.matches("^([a-z]|[A-Z]|_|[0-9])+$")) {
                return "Field name can contain only letters, numbers, and underscores.";
            }
            if (fieldName.equals("") || fieldType.equals("")) continue;
            if (fieldFilterable == null) {
                fieldFilterable = false;
            }
            if (fieldAlias == null) {
                fieldAlias = fieldName;
            }
            if (fieldDescription == null) {
                fieldDescription = "";
            }
            fields.add(new CustomField(fieldName, fieldType, fieldFilterable, fieldAlias, fieldDescription));
        }
        return null;
    }

    private int[] mergeAnnIDsWithDefaults(int[] annIDs, int projID, int refID) throws RemoteException, SQLException, SessionExpiredException {
        int[] defaults = this.manager.getDefaultAnnotationIDs(LoginController.getSessionID(), projID, refID);
        HashSet<Integer> a = new HashSet<Integer>();
        a.addAll(Arrays.asList(ArrayUtils.toObject((int[])annIDs)));
        a.addAll(Arrays.asList(ArrayUtils.toObject((int[])defaults)));
        return ArrayUtils.toPrimitive((Integer[])a.toArray(new Integer[a.size()]));
    }

    private void createNewProject() throws Exception {
        int projID = ProjectController.getInstance().addProject(this.projectName, this.customFields);
        for (CheckListItem cli : this.checkListItems) {
            if (!cli.isSelected()) continue;
            int refID = cli.getReference().getID();
            int[] annIDs = this.mergeAnnIDsWithDefaults(cli.getAnnotationIDs(), projID, refID);
            this.manager.setCustomVariantFields(LoginController.getSessionID(), projID, refID, 0, this.variantFields);
            this.manager.createVariantTable(LoginController.getSessionID(), projID, refID, 0, annIDs, false);
        }
    }

    private int modifyProject(boolean modifyProjectName, boolean modifyPatientFields, boolean modifyVariants, ProjectWorker projectWorker) throws Exception {
        int updateID = -1;
        if (modifyProjectName && !this.projectName.equals(this.originalProjectName)) {
            this.manager.renameProject(LoginController.getSessionID(), this.projectID, this.projectName);
        }
        if (modifyPatientFields) {
            MedSavantClient.PatientManager.updateFields(LoginController.getSessionID(), this.projectID, this.customFields);
        }
        if (modifyVariants) {
            for (CheckListItem cli : this.checkListItems) {
                ProjectDetails pd = this.getProjectDetails(cli.getReference().getID());
                LOG.info((Object)("Processing ref id " + cli.getReference().getID()));
                if (!cli.isSelected() && pd == null) {
                    LOG.info((Object)"Skipping this ref");
                    continue;
                }
                int[] annIDs = cli.getAnnotationIDs();
                if (pd == null && cli.isSelected()) {
                    int refID = cli.getReference().getID();
                    LOG.info((Object)("Adding reference with id " + refID));
                    annIDs = this.mergeAnnIDsWithDefaults(annIDs, this.projectID, refID);
                    this.manager.setCustomVariantFields(LoginController.getSessionID(), this.projectID, refID, 0, this.variantFields);
                    this.manager.createVariantTable(LoginController.getSessionID(), this.projectID, refID, 0, annIDs, false);
                    continue;
                }
                if (pd != null && !cli.isSelected()) {
                    LOG.info((Object)("Removing reference with id " + cli.getReference().getID()));
                    this.manager.removeReferenceForProject(LoginController.getSessionID(), this.projectID, cli.getReference().getID());
                    continue;
                }
                String email = this.emailField.getText();
                boolean autoPublishWhenComplete = this.autoPublish.isSelected();
                updateID = MedSavantClient.VariantManager.updateTable(LoginController.getSessionID(), this.projectID, cli.getReference().getID(), annIDs, this.variantFields, autoPublishWhenComplete, email);
            }
        }
        ProjectController.getInstance().fireEvent(new ProjectEvent(ProjectEvent.Type.REMOVED, this.projectName));
        ProjectController.getInstance().fireEvent(new ProjectEvent(ProjectEvent.Type.ADDED, this.projectName));
        return updateID;
    }

    private AbstractWizardPage getNotificationsPage() {
        DefaultWizardPage page = new DefaultWizardPage(PAGENAME_NOTIFICATIONS){

            public void setupWizardButtons() {
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
        page.addText("Project modification may take some time. Enter your email address to be notified when the process completes.");
        JPanel p = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(p);
        JLabel l = new JLabel("Email: ");
        this.emailField = new JTextField();
        p.add(l);
        p.add(this.emailField);
        page.addComponent((JComponent)p);
        this.autoPublish = new JCheckBox("Publish data upon import completion");
        this.autoPublish.setSelected(true);
        page.addComponent((JComponent)this.autoPublish);
        page.addText("If you choose not to automatically publish, you will be prompted to publish manually upon completion. Variant publication logs all users out.");
        return page;
    }

    private ProjectDetails getProjectDetails(int referenceId) {
        for (ProjectDetails pd : this.projectDetails) {
            if (pd.getReferenceID() != referenceId) continue;
            return pd;
        }
        return null;
    }

    public boolean isModified() {
        return this.isModified;
    }

    private class RemovalEnabler
    implements ListSelectionListener {
        private final int lockedRows;
        private final JButton button;

        RemovalEnabler(int n, JButton b) {
            this.lockedRows = n;
            this.button = b;
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            int n = ((ListSelectionModel)lse.getSource()).getMinSelectionIndex();
            this.button.setEnabled(n >= this.lockedRows);
        }
    }

    private class CheckListItem
    extends JPanel {
        private final Reference reference;
        private final Set<Integer> selectedAnnotations = new HashSet<Integer>();
        private final JCheckBox checkBox;
        private final List<JCheckBox> annBoxes = new ArrayList<JCheckBox>();

        public CheckListItem(Reference ref, Annotation[] annotations) {
            this.reference = ref;
            this.setLayout(new BoxLayout(this, 1));
            this.setBackground(Color.WHITE);
            this.checkBox = new JCheckBox(ref.getName());
            this.checkBox.setMaximumSize(new Dimension(1000, 20));
            this.checkBox.setBackground(this.getBackground());
            this.checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean selected = CheckListItem.this.checkBox.isSelected();
                    for (JCheckBox annBox : CheckListItem.this.annBoxes) {
                        annBox.setEnabled(selected);
                    }
                }
            });
            ProjectDetails pd = ProjectWizard.this.getProjectDetails(ref.getID());
            boolean selected = pd != null;
            this.checkBox.setSelected(selected);
            JPanel p = new JPanel();
            p.setMaximumSize(new Dimension(1000, 20));
            p.setBackground(Color.white);
            p.setLayout(new BoxLayout(p, 0));
            p.add(this.checkBox);
            p.add(Box.createHorizontalGlue());
            this.add(p);
            for (final Annotation a : annotations) {
                if (a.getReferenceID() != this.reference.getID()) continue;
                final JCheckBox b1 = new JCheckBox(a.getProgram() + " " + a.getVersion());
                b1.setMaximumSize(new Dimension(1000, 20));
                b1.setBackground(Color.white);
                b1.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (b1.isSelected()) {
                            CheckListItem.this.selectedAnnotations.add(a.getID());
                        } else {
                            CheckListItem.this.selectedAnnotations.remove(a.getID());
                        }
                    }
                });
                this.annBoxes.add(b1);
                b1.setEnabled(selected);
                b1.setSelected(false);
                if (pd != null && ArrayUtils.contains((int[])pd.getAnnotationIDs(), (int)a.getID())) {
                    b1.setSelected(true);
                    this.selectedAnnotations.add(a.getID());
                }
                JPanel p1 = new JPanel();
                p1.setMaximumSize(new Dimension(1000, 20));
                p1.setBackground(Color.white);
                p1.setLayout(new BoxLayout(p1, 0));
                p1.add(Box.createHorizontalStrut(30));
                p1.add(b1);
                p1.add(Box.createHorizontalGlue());
                this.add(p1);
            }
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean value) {
            this.checkBox.setSelected(value);
        }

        public Reference getReference() {
            return this.reference;
        }

        public int[] getAnnotationIDs() {
            int[] result = new int[this.selectedAnnotations.size()];
            int i = 0;
            for (Integer ann : this.selectedAnnotations) {
                result[i++] = ann;
            }
            return result;
        }
    }
}

