/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ut.biolab.medsavant.client.query.SearchConditionGroupItem;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;

public class SearchConditionItem
implements Serializable {
    private String explanation;
    private String description;
    private String encodedConditions;
    private List<SearchConditionListener> orderlisteners;
    private final String name;
    private SearchConditionGroupItem.QueryRelation relation;
    private SearchConditionGroupItem parent;

    public SearchConditionItem(String name, SearchConditionGroupItem parent) {
        this(name, SearchConditionGroupItem.QueryRelation.AND, parent);
    }

    public SearchConditionItem(String name, SearchConditionGroupItem.QueryRelation r, SearchConditionGroupItem parent) {
        this.name = name;
        this.parent = parent;
        this.relation = r;
        this.orderlisteners = new ArrayList<SearchConditionListener>();
        try {
            AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("search-event", "ConditionCreated"), new NameValuePair("condition-name", name)});
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public SearchConditionGroupItem.QueryRelation getRelation() {
        return this.relation;
    }

    public void changeRelationTo(SearchConditionGroupItem.QueryRelation r) {
        this.relation = r;
    }

    public SearchConditionGroupItem getParent() {
        return this.parent;
    }

    public void setDescription(String s) {
        this.description = s;
        this.fireSearchConditionsEditedEvent(this);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isGroup() {
        return false;
    }

    public void addListener(SearchConditionListener l) {
        this.orderlisteners.add(l);
    }

    protected void fireSearchConditionOrderChangedEvent() {
        for (SearchConditionListener l : this.orderlisteners) {
            l.searchConditionsOrderChanged(this);
        }
    }

    protected void fireSearchConditionsEditedEvent(SearchConditionItem m) {
        for (SearchConditionListener l : this.orderlisteners) {
            l.searchConditionEdited(m);
        }
    }

    protected void fireSearchConditionItemAddedEvent(SearchConditionItem item) {
        for (SearchConditionListener l : this.orderlisteners) {
            l.searchConditionItemAdded(item);
        }
    }

    protected void fireSearchConditionItemRemovedEvent(SearchConditionItem item) {
        for (SearchConditionListener l : this.orderlisteners) {
            l.searchConditionItemRemoved(item);
        }
    }

    public void setRelation(SearchConditionGroupItem.QueryRelation r) {
        this.relation = r;
        this.fireSearchConditionsEditedEvent(this);
    }

    void removeListener(SearchConditionListener l) {
        this.orderlisteners.remove(l);
    }

    void setParent(SearchConditionGroupItem p) {
        this.parent = p;
    }

    public void setSearchConditionEncoding(String s) {
        this.encodedConditions = s;
    }

    public String getSearchConditionEncoding() {
        return this.encodedConditions;
    }

    public ConditionState getState() {
        if (this.encodedConditions == null) {
            return ConditionState.UNSET;
        }
        return ConditionState.SET;
    }

    protected String escape(String s) {
        if (s == null) {
            return "";
        }
        return StringEscapeUtils.escapeXml((String)s);
    }

    protected String toXML(int indent) {
        String tab = "";
        for (int i = 0; i < indent; ++i) {
            tab = tab + "\t";
        }
        String xml = tab + "<Item";
        xml = xml + " description=\"" + this.escape(this.description) + "\"";
        xml = xml + " encodedConditions=\"" + this.escape(this.encodedConditions) + "\"";
        xml = xml + " name=\"" + this.escape(this.name) + "\"";
        xml = xml + " queryRelation=\"" + this.escape(this.relation.toString()) + "\"";
        xml = xml + ">\n";
        xml = xml + tab + "</Item>\n";
        return xml;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
        this.fireSearchConditionsEditedEvent(this);
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public static interface SearchConditionListener {
        public void searchConditionsOrderChanged(SearchConditionItem var1);

        public void searchConditionItemRemoved(SearchConditionItem var1);

        public void searchConditionItemAdded(SearchConditionItem var1);

        public void searchConditionEdited(SearchConditionItem var1);
    }

    public static enum ConditionState {
        UNSET,
        SET;

    }
}

