/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.medsavant.complex;

import com.healthmarketscience.sqlbuilder.Condition;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.geneset.GeneSetController;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.medsavant.MedSavantConditionViewGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.ComprehensiveConditionGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.ConditionUtils;
import org.ut.biolab.medsavant.client.query.value.StringConditionValueGenerator;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.client.query.view.SearchConditionEditorView;
import org.ut.biolab.medsavant.client.query.view.StringSearchConditionEditorView;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.model.OntologyTerm;
import org.ut.biolab.medsavant.shared.model.OntologyType;

public class OntologyConditionGenerator
implements ComprehensiveConditionGenerator {
    private static final Log LOG = LogFactory.getLog(OntologyConditionGenerator.class);
    private static final int MAX_GENES_IN_POPUP = 6;
    private boolean alreadyInitialized;
    private HashMap<String, OntologyTerm> termNameToTermObjectMap;
    private List<String> acceptableValues;
    private final OntologyType ontology;
    private static final Dimension DEFAULT_DIMENSIONS = new Dimension(600, 384);

    public OntologyConditionGenerator(OntologyType ont) {
        this.ontology = ont;
    }

    @Override
    public String getName() {
        return this.ontology.name();
    }

    @Override
    public String category() {
        return MedSavantConditionViewGenerator.REGIONBASED_CONDITIONS;
    }

    public List<GenomicRegion> getRegionsFromEncoding(String encoding) throws Exception {
        this.init();
        List<String> termNames = StringConditionEncoder.unencodeConditions(encoding);
        ArrayList<OntologyTerm> appliedTerms = new ArrayList<OntologyTerm>(termNames.size());
        for (String termName : termNames) {
            appliedTerms.add(this.termNameToTermObjectMap.get(termName));
        }
        HashSet<Gene> genes = new HashSet<Gene>();
        Map<OntologyTerm, String[]> allTermsGenes = MedSavantClient.OntologyManager.getGenesForTerms(LoginController.getSessionID(), appliedTerms.toArray(new OntologyTerm[0]), ReferenceController.getInstance().getCurrentReferenceName());
        for (String[] termGenes : allTermsGenes.values()) {
            for (String geneName : termGenes) {
                Gene g = GeneSetController.getInstance().getGene(geneName);
                if (g != null) {
                    genes.add(g);
                    continue;
                }
                LOG.info((Object)("Non-existent gene " + geneName + " referenced by " + (Object)((Object)this.ontology)));
            }
        }
        ArrayList<GenomicRegion> regions = new ArrayList<GenomicRegion>(genes.size());
        boolean i = false;
        for (Gene g : genes) {
            regions.add(new GenomicRegion(g.getName(), g.getChrom(), g.getStart(), g.getEnd()));
        }
        return regions;
    }

    @Override
    public Condition getConditionsFromEncoding(String encoding) throws Exception {
        List<GenomicRegion> regions = this.getRegionsFromEncoding(encoding);
        return ConditionUtils.getConditionsMatchingGenomicRegions(regions);
    }

    @Override
    public StringSearchConditionEditorView getViewGeneratorForItem(SearchConditionItem item) {
        OntologySearchConditionEditorView editor = new OntologySearchConditionEditorView(item, new StringConditionValueGenerator(){

            @Override
            public List<String> getStringValues() {
                OntologyConditionGenerator.this.init();
                return OntologyConditionGenerator.this.acceptableValues;
            }
        });
        editor.refreshMaps();
        return editor;
    }

    private String getTermName(OntologyTerm t) {
        return (Object)((Object)t.getOntology()) + ":" + t.getName();
    }

    private void init() {
        if (this.alreadyInitialized) {
            return;
        }
        ArrayList<String> vals = new ArrayList<String>();
        try {
            OntologyTerm[] terms = MedSavantClient.OntologyManager.getAllTerms(LoginController.getSessionID(), this.ontology);
            vals = new ArrayList(terms.length);
            this.termNameToTermObjectMap = new HashMap();
            for (OntologyTerm t : terms) {
                String termName = this.getTermName(t);
                this.termNameToTermObjectMap.put(termName, t);
                vals.add(termName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOG.error((Object)ex);
        }
        this.acceptableValues = vals;
        this.alreadyInitialized = true;
    }

    private class OntologySearchConditionEditorView
    extends StringSearchConditionEditorView {
        private Map<String, JPopupMenu> popupMap;
        private Map<String, JLabel> countMap;
        private boolean mapsReady;
        private Semaphore mapLock;
        private MedSavantWorker<Void> refresher;

        public OntologySearchConditionEditorView(SearchConditionItem i, StringConditionValueGenerator vg) {
            super(i, vg);
            this.mapsReady = false;
            this.mapLock = new Semaphore(1);
            this.setPreferredSize(DEFAULT_DIMENSIONS);
        }

        @Override
        public void loadViewFromSearchConditionParameters(String encoding) throws SearchConditionEditorView.ConditionRestorationException {
            super.loadViewFromSearchConditionParameters(encoding);
        }

        private synchronized void refreshMaps() {
            if (this.refresher != null) {
                return;
            }
            try {
                this.mapLock.acquire();
                final OntologySearchConditionEditorView instance = this;
                this.refresher = new MedSavantWorker<Void>("Ontology"){

                    @Override
                    protected Void doInBackground() throws Exception {
                        OntologyTerm[] terms = MedSavantClient.OntologyManager.getAllTerms(LoginController.getSessionID(), OntologyConditionGenerator.this.ontology);
                        OntologySearchConditionEditorView.this.popupMap = new HashMap();
                        OntologySearchConditionEditorView.this.countMap = new HashMap();
                        for (OntologyTerm term : terms) {
                            OntologySearchConditionEditorView.this.popupMap.put(OntologyConditionGenerator.this.getTermName(term), new JPopupMenu());
                            OntologySearchConditionEditorView.this.countMap.put(OntologyConditionGenerator.this.getTermName(term), new JLabel());
                        }
                        OntologySearchConditionEditorView.this.mapLock.release();
                        OntologySearchConditionEditorView.this.mapsReady = true;
                        String session = LoginController.getSessionID();
                        String refName = ReferenceController.getInstance().getCurrentReferenceName();
                        for (final OntologyTerm term : terms) {
                            final String[] genes = MedSavantClient.OntologyManager.getGenesForTerm(session, term, refName);
                            if (genes == null) continue;
                            final JPopupMenu menu = (JPopupMenu)OntologySearchConditionEditorView.this.popupMap.get(OntologyConditionGenerator.this.getTermName(term));
                            final JLabel lbl = (JLabel)OntologySearchConditionEditorView.this.countMap.get(OntologyConditionGenerator.this.getTermName(term));
                            if (lbl == null) {
                                System.out.println("Null label for " + OntologyConditionGenerator.this.getTermName(term));
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    lbl.setText("(" + genes.length + ")");
                                    menu.removeAll();
                                    menu.add(OntologySearchConditionEditorView.this.getPopupItem(term, genes));
                                    lbl.addMouseListener(new MouseAdapter(){

                                        @Override
                                        public void mouseClicked(MouseEvent me) {
                                            super.mouseClicked(me);
                                        }

                                        @Override
                                        public void mouseEntered(MouseEvent me) {
                                            super.mouseEntered(me);
                                        }

                                        @Override
                                        public void mouseExited(MouseEvent me) {
                                            super.mouseExited(me);
                                        }
                                    });
                                    lbl.add(menu);
                                    instance.revalidate();
                                    instance.repaint();
                                }
                            });
                        }
                        return null;
                    }

                    @Override
                    protected void showSuccess(Void result) {
                    }
                };
                this.refresher.execute();
                this.mapLock.acquire();
                this.mapLock.release();
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }

        @Override
        protected JPopupMenu getPopupMenu(String itemHoveredOver) {
            if (!this.mapsReady) {
                this.refreshMaps();
            }
            return this.popupMap.get(itemHoveredOver);
        }

        @Override
        protected JLabel getNumberInCategory(String category) {
            if (!this.mapsReady) {
                this.refreshMaps();
            }
            return this.countMap.get(category);
        }

        private JMenuItem getPopupItem(final OntologyTerm term, final String[] genes) {
            String s = "";
            int j = 0;
            for (String gene : genes) {
                s = s + gene.trim() + " ";
                if (++j <= 6) continue;
                s = s + "(" + (genes.length - 6) + " More...)";
                break;
            }
            JMenuItem ji = new JMenuItem(s);
            ji.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JDialog dialog = new JDialog(MedSavantFrame.getInstance());
                    dialog.setModal(true);
                    JPanel p = new JPanel();
                    p.setLayout(new BoxLayout(p, 1));
                    JPanel lblPanel = new JPanel();
                    lblPanel.setLayout(new BoxLayout(lblPanel, 0));
                    lblPanel.add(Box.createHorizontalGlue());
                    lblPanel.add(new JLabel(" Genes corresponding to annotation " + OntologyConditionGenerator.this.getTermName(term) + " "));
                    lblPanel.add(Box.createHorizontalGlue());
                    Arrays.sort(genes);
                    JList<String> jl = new JList<String>(genes);
                    JScrollPane jsp = new JScrollPane(jl);
                    p.add(lblPanel);
                    p.add(jsp);
                    dialog.setContentPane(p);
                    dialog.pack();
                    dialog.setLocationRelativeTo(MedSavantFrame.getInstance());
                    dialog.setVisible(true);
                }
            });
            return ji;
        }
    }
}

