/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.medsavant.complex;

import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.medsavant.MedSavantConditionViewGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.ComprehensiveConditionGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.ConditionUtils;
import org.ut.biolab.medsavant.client.query.value.StringConditionValueGenerator;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.client.query.view.StringSearchConditionEditorView;
import org.ut.biolab.medsavant.client.region.RegionController;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.model.RegionSet;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

public class RegionSetConditionGenerator
implements ComprehensiveConditionGenerator {
    private boolean alreadyInitialized;
    private ArrayList<String> acceptableValues;
    private HashMap<String, RegionSet> termNameToTermObjectMap;

    @Override
    public String getName() {
        return "Region Set";
    }

    @Override
    public Condition getConditionsFromEncoding(String encoding) throws Exception {
        this.init();
        List<String> termNames = StringConditionEncoder.unencodeConditions(encoding);
        ArrayList<RegionSet> appliedTerms = new ArrayList<RegionSet>(termNames.size());
        for (String termName : termNames) {
            RegionSet rs = this.termNameToTermObjectMap.get(termName);
            if (rs == null) {
                throw new IllegalArgumentException("The Region Set " + termName + " is no longer valid, search cannot be executed.");
            }
            appliedTerms.add(this.termNameToTermObjectMap.get(termName));
        }
        return ComboCondition.or(this.getConditions(RegionController.getInstance().getRegionsInSets(appliedTerms)));
    }

    @Override
    public StringSearchConditionEditorView getViewGeneratorForItem(SearchConditionItem item) {
        StringSearchConditionEditorView editor = new StringSearchConditionEditorView(item, new StringConditionValueGenerator(){

            @Override
            public List<String> getStringValues() {
                RegionSetConditionGenerator.this.init();
                return RegionSetConditionGenerator.this.acceptableValues;
            }
        });
        return editor;
    }

    private void init() {
        this.acceptableValues = new ArrayList();
        try {
            List<RegionSet> regionSets = RegionController.getInstance().getRegionSets();
            this.termNameToTermObjectMap = new HashMap();
            for (RegionSet c : regionSets) {
                String setName = c.getName();
                this.acceptableValues.add(setName);
                this.termNameToTermObjectMap.put(setName, c);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.alreadyInitialized = true;
    }

    @Override
    public String category() {
        return MedSavantConditionViewGenerator.REGIONBASED_CONDITIONS;
    }

    protected Condition[] getConditions(Collection<GenomicRegion> regions) throws SQLException, RemoteException {
        Condition[] results;
        Map<String, List<Range>> rangeMap = GenomicRegion.mergeGenomicRegions(regions);
        if (rangeMap.size() > 0) {
            results = new Condition[rangeMap.size()];
            int i = 0;
            for (String chrom : rangeMap.keySet()) {
                Condition[] tmp = new Condition[2];
                tmp[0] = BinaryConditionMS.equalTo(ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.CHROM), chrom);
                List<Range> ranges = rangeMap.get(chrom);
                Condition[] rangeConditions = new Condition[ranges.size()];
                for (int j = 0; j < ranges.size(); ++j) {
                    rangeConditions[j] = MiscUtils.getIntersectCondition((long)ranges.get(j).getMin(), (long)ranges.get(j).getMax(), ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.START_POSITION), ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.END_POSITION));
                }
                tmp[1] = ComboCondition.or(rangeConditions);
                results[i] = ComboCondition.and(tmp);
                ++i;
            }
        } else {
            results = new Condition[]{ConditionUtils.FALSE_CONDITION};
        }
        return results;
    }
}

