/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.value.encode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringConditionEncoder {
    private static String DELIM = ";";
    public static String ENCODING_NULL = "<NULL>";
    public static String ENCODING_NOTNULL = "<NOTNULL>";
    private static final int MAX_CHARACTERS = 90;

    public static List<String> unencodeConditions(String s) {
        if (s.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] arr = s.split(DELIM);
        return Arrays.asList(arr);
    }

    public static String encodeConditions(List<String> values) {
        StringBuilder result = new StringBuilder();
        for (String string : values) {
            result.append((Object)string);
            result.append(DELIM);
        }
        return result.length() > 0 ? result.substring(0, result.length() - 1) : "";
    }

    public static String getDescription(List<String> chosenValues) {
        String s = chosenValues.isEmpty() ? "none" : (chosenValues.size() == 1 ? chosenValues.get(0) : (chosenValues.size() == 2 ? "either " + chosenValues.get(0) + " or " + chosenValues.get(1) : "any of " + chosenValues.size()));
        return s;
    }

    public static String getDescription(List<String> chosenValues, List<String> values) {
        String s;
        if (chosenValues == null) {
            return "unknown";
        }
        if (chosenValues.isEmpty()) {
            s = "none";
        } else if (chosenValues.size() == 1 && chosenValues.get(0).length() < 90) {
            s = chosenValues.get(0);
        } else if (chosenValues.size() == 2) {
            s = "either " + chosenValues.get(0) + " or " + chosenValues.get(1);
            if (s.length() > 90) {
                s = "any of " + chosenValues.size();
            }
        } else {
            s = values != null && chosenValues.size() == values.size() ? "anything" : "any of " + chosenValues.size();
        }
        return s;
    }

    public static boolean encodesNull(String encoding) {
        if (encoding == null) {
            return false;
        }
        return encoding.equals(ENCODING_NULL);
    }

    public static boolean encodesNotNull(String encoding) {
        if (encoding == null) {
            return false;
        }
        return encoding.equals(ENCODING_NOTNULL);
    }
}

