/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.view;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.view.ConditionEditorDialogGenerator;
import org.ut.biolab.medsavant.client.query.view.PillView;
import org.ut.biolab.medsavant.client.query.view.SearchConditionEditorView;
import org.ut.biolab.medsavant.client.query.view.SearchConditionPanel;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;

public class SearchConditionItemView
extends PillView {
    private final SearchConditionItem item;
    private final SearchConditionEditorView editor;

    @Override
    public void showDialog(Point p) {
        this.showDialog(p, "Editing Condition: " + this.item.getName());
    }

    public SearchConditionItemView(SearchConditionItem i, final SearchConditionEditorView editor) {
        this.item = i;
        this.editor = editor;
        i.addListener(new SearchConditionItem.SearchConditionListener(){

            @Override
            public void searchConditionsOrderChanged(SearchConditionItem m) {
            }

            @Override
            public void searchConditionItemRemoved(SearchConditionItem m) {
            }

            @Override
            public void searchConditionItemAdded(SearchConditionItem m) {
            }

            @Override
            public void searchConditionEdited(SearchConditionItem m) {
                SearchConditionItemView.this.refresh();
            }
        });
        this.setDialogGenerator(new ConditionEditorDialogGenerator(){

            @Override
            public JDialog generateDialog() {
                final JDialog dialog = new JDialog(MedSavantFrame.getInstance());
                JPopupMenu advancedMenu = this.getAdvancedMenu(editor.getSearchConditionItem(), dialog);
                SearchConditionPanel mainPanel = new SearchConditionPanel(editor, advancedMenu);
                JPanel buttonPanel = mainPanel.getButtonPanel();
                JButton OKButton = new JButton("OK");
                OKButton.setFocusable(false);
                OKButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            if (editor.saveChanges()) {
                                SearchConditionItemView.this.setSelected(false);
                                dialog.dispose();
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            DialogUtils.displayError(ex.getMessage());
                        }
                    }
                });
                JButton delete = new JButton("Remove");
                delete.setFocusable(false);
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        SearchConditionItemView.this.setSelected(false);
                        SearchConditionItemView.this.item.getParent().removeItem(SearchConditionItemView.this.item);
                        dialog.dispose();
                    }
                });
                buttonPanel.add(delete);
                buttonPanel.add(OKButton);
                mainPanel.loadEditorViewInBackground(new Runnable(){

                    @Override
                    public void run() {
                        dialog.pack();
                        dialog.invalidate();
                    }
                });
                dialog.setModal(true);
                dialog.setContentPane(mainPanel);
                dialog.pack();
                dialog.setLocationRelativeTo(MedSavantFrame.getInstance());
                return dialog;
            }

            private JPopupMenu getAdvancedMenu(final SearchConditionItem item, final JDialog dialog) {
                JPopupMenu advancedMenu = new JPopupMenu();
                if (item.getParent().getItems().size() > 0) {
                    JMenuItem convertToGroupItem = new JMenuItem("Convert to group");
                    convertToGroupItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            item.getParent().createGroupFromItem(item);
                            dialog.dispose();
                        }
                    });
                    advancedMenu.add(convertToGroupItem);
                    if (item.getParent().getParent() != null) {
                        JMenuItem ungroupItem = new JMenuItem("Ungroup");
                        ungroupItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                item.getParent().moveItemToGroup(item, item.getParent().getParent());
                                dialog.dispose();
                            }
                        });
                        advancedMenu.add(ungroupItem);
                    }
                }
                return advancedMenu;
            }
        });
        this.refresh();
    }

    public final void refresh() {
        String name;
        int index;
        if (this.item.getParent() == null) {
            return;
        }
        this.setActivated(this.item.getSearchConditionEncoding() != null);
        if (this.item.getExplanation() != null) {
            this.setInfo(this.item.getExplanation());
        }
        if ((index = (name = this.item.getName()).indexOf("-")) != -1) {
            name = name.substring(0, index);
        }
        this.setText("<html>" + (!this.item.getParent().isFirstItem(this.item) ? (Object)((Object)this.item.getRelation()) + " " : "") + "<b>" + name + "</b>" + (this.item.getDescription() != null ? " is " + this.item.getDescription() + "" : " is <i>unset</i>") + "</html>");
    }
}

