/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.ut.biolab.medsavant.client.query.view.SearchConditionEditorView;
import org.ut.biolab.medsavant.client.query.view.SearchConditionItemView;
import org.ut.biolab.medsavant.client.view.component.ProgressWheel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class SearchConditionPanel
extends JPanel {
    private static final int BORDER_PADDING = 5;
    private final JPanel horizButtonPanel = new JPanel();
    private final SearchConditionEditorView editor;
    private final JPanel conditionsEditorPanel;

    public void loadEditorViewInBackground(final Runnable onFinish) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    SearchConditionPanel.this.editor.loadViewFromExistingSearchConditionParameters();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SearchConditionPanel.this.conditionsEditorPanel.removeAll();
                            SearchConditionPanel.this.conditionsEditorPanel.add(SearchConditionPanel.this.editor);
                            if (onFinish != null) {
                                onFinish.run();
                            }
                            SearchConditionPanel.this.updateUI();
                        }
                    });
                }
                catch (Exception ex) {
                    Logger.getLogger(SearchConditionItemView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        t.start();
    }

    public SearchConditionPanel(SearchConditionEditorView editor, final JPopupMenu advancedMenu) {
        this.editor = editor;
        this.setLayout(new BoxLayout(this, 1));
        this.conditionsEditorPanel = ViewUtil.getClearPanel();
        ViewUtil.applyVerticalBoxLayout(this.conditionsEditorPanel);
        ProgressWheel waitForConditions = ViewUtil.getIndeterminateProgressBar();
        this.conditionsEditorPanel.add(ViewUtil.centerHorizontally(new JLabel("Preparing condition,")));
        this.conditionsEditorPanel.add(Box.createVerticalStrut(5));
        this.conditionsEditorPanel.add(ViewUtil.centerHorizontally(new JLabel("please wait...")));
        this.conditionsEditorPanel.add(ViewUtil.centerHorizontally(waitForConditions));
        this.add(this.conditionsEditorPanel);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.horizButtonPanel.setLayout(new BoxLayout(this.horizButtonPanel, 0));
        if (advancedMenu != null && advancedMenu.getComponentCount() > 0) {
            final JButton gearButton = ViewUtil.getConfigureButton();
            gearButton.setToolTipText("More Options");
            gearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    advancedMenu.show(gearButton, 0, gearButton.getHeight());
                }
            });
            this.horizButtonPanel.add(gearButton);
        }
        this.horizButtonPanel.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalGlue());
        this.add(this.horizButtonPanel);
    }

    public JPanel getButtonPanel() {
        return this.horizButtonPanel;
    }
}

