/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.region;

import java.util.List;
import org.ut.biolab.medsavant.client.region.RegionController;
import org.ut.biolab.medsavant.client.region.RegionWizard;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.RegionSet;
import org.ut.biolab.medsavant.shared.model.UserLevel;

public class RegionDetailedListEditor
extends DetailedListEditor {
    private final RegionController controller = RegionController.getInstance();

    @Override
    public boolean doesImplementAdding() {
        UserLevel level = LoginController.getInstance().getUserLevel();
        return level == UserLevel.USER || level == UserLevel.ADMIN;
    }

    @Override
    public boolean doesImplementDeleting() {
        UserLevel level = LoginController.getInstance().getUserLevel();
        return level == UserLevel.USER || level == UserLevel.ADMIN;
    }

    @Override
    public boolean doesImplementImporting() {
        UserLevel level = LoginController.getInstance().getUserLevel();
        return level == UserLevel.USER || level == UserLevel.ADMIN;
    }

    @Override
    public void addItems() {
        try {
            new RegionWizard(false).setVisible(true);
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error fetching standard genes: %s", ex);
        }
    }

    @Override
    public void importItems() {
        try {
            new RegionWizard(true).setVisible(true);
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error fetching standard genes: %s", ex);
        }
    }

    @Override
    public void deleteItems(final List<Object[]> items) {
        int result;
        if (items == null || items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            String name = ((RegionSet)items.get(0)[0]).getName();
            result = DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove <i>%s</i>?<br>This cannot be undone.</html>", name);
        } else {
            result = DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove these %d lists?<br>This cannot be undone.</html>", items.size());
        }
        if (result == 0) {
            new ProgressDialog("Removing Region List(s)", "Removing region list(s). Please wait."){

                @Override
                public void run() {
                    int numCouldntRemove = 0;
                    for (Object[] v : items) {
                        RegionSet set = (RegionSet)v[0];
                        try {
                            RegionDetailedListEditor.this.controller.removeSet(set.getID());
                        }
                        catch (Throwable ex) {
                            ++numCouldntRemove;
                            ClientMiscUtils.reportError("Could not remove " + set.getName() + ": %s", ex);
                        }
                    }
                }
            }.setVisible(true);
        }
    }
}

