/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.region;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.PageList;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.CompletionWizardPage;
import com.jidesoft.wizard.DefaultWizardPage;
import com.jidesoft.wizard.WizardDialog;
import com.jidesoft.wizard.WizardStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.type.CombiningMethod;
import org.ut.biolab.medsavant.client.geneset.GeneSetController;
import org.ut.biolab.medsavant.client.importing.ImportFilePanel;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.region.RegionController;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.ClientNetworkUtils;
import org.ut.biolab.medsavant.client.util.GeneFetcher;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.GeneSelectionPanel;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.DownloadTask;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.GeneSetFetcher;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.GenemaniaInfoRetriever;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.importing.BEDFormat;
import org.ut.biolab.medsavant.shared.importing.FileFormat;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.model.GeneSet;
import org.ut.biolab.medsavant.shared.model.RegionSet;

public class RegionWizard
extends WizardDialog {
    private static final Log LOG = LogFactory.getLog(RegionWizard.class);
    private static final String PAGENAME_NAME = "List Name";
    private static final String PAGENAME_FILE = "Choose File";
    private static final String PAGENAME_GENES = "Select Genes";
    private static final String PAGENAME_CREATE = "Create";
    private static final String PAGENAME_COMPLETE = "Complete";
    private static final int DEFAULT_RELATED_GENES_LIMIT = 50;
    private final CombiningMethod[] GENEMANIA_COMBINING_METHODS = new CombiningMethod[]{CombiningMethod.AVERAGE, CombiningMethod.BP, CombiningMethod.MF, CombiningMethod.CC, CombiningMethod.AUTOMATIC};
    private String listName;
    private String path;
    private char delim;
    private FileFormat fileFormat;
    private int numHeaderLines;
    private final boolean importing;
    private GeneSet standardGenes;
    private final RegionController controller;
    private GeneSelectionPanel sourceGenesPanel;
    private JButton runGeneManiaButton;
    private GeneSelectionPanel selectedGenesPanel;
    private static GeneManiaDownloadCompleteListener geneManiaDownloadCompleteListener;

    private void registerDownloadListener() {
        try {
            if (geneManiaDownloadCompleteListener == null) {
                geneManiaDownloadCompleteListener = new GeneManiaDownloadCompleteListener();
                DownloadTask dt = GenemaniaInfoRetriever.getGeneManiaDownloadTask();
                dt.addPropertyChangeListener(geneManiaDownloadCompleteListener);
            }
        }
        catch (IOException e) {
            DialogUtils.displayMessage("Error downloading GeneMANIA files");
            LOG.error((Object)e);
        }
    }

    public RegionWizard(boolean doImportProcess) throws SQLException, RemoteException {
        super((Frame)MedSavantFrame.getInstance(), "Region List Wizard", true);
        this.importing = doImportProcess;
        this.controller = RegionController.getInstance();
        WizardStyle.setStyle((int)3);
        PageList model = new PageList();
        if (doImportProcess) {
            model.append((AbstractDialogPage)this.getNamePage());
            model.append((AbstractDialogPage)this.getFilePage());
            model.append((AbstractDialogPage)this.getCreationPage());
            model.append((AbstractDialogPage)this.getCompletionPage());
        } else {
            model.append((AbstractDialogPage)this.getNamePage());
            model.append((AbstractDialogPage)this.getGenesPage());
            this.standardGenes = GeneSetController.getInstance().getCurrentGeneSet();
            if (this.standardGenes == null) {
                throw new IllegalArgumentException(String.format("No standard genes to choose from for %s.", ReferenceController.getInstance().getCurrentReferenceName()));
            }
            this.fetchGenes();
            model.append((AbstractDialogPage)this.getCreationPage());
            model.append((AbstractDialogPage)this.getCompletionPage());
        }
        this.setPageList(model);
        this.setNextAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pageName = RegionWizard.this.getCurrentPage().getTitle();
                if (pageName.equals(RegionWizard.PAGENAME_NAME) && RegionWizard.this.validateListName()) {
                    if (RegionWizard.this.importing) {
                        RegionWizard.this.setCurrentPage(RegionWizard.PAGENAME_FILE);
                    } else {
                        RegionWizard.this.setCurrentPage(RegionWizard.PAGENAME_GENES);
                    }
                } else if (pageName.equals(RegionWizard.PAGENAME_FILE) || pageName.equals(RegionWizard.PAGENAME_GENES)) {
                    RegionWizard.this.setCurrentPage(RegionWizard.PAGENAME_CREATE);
                } else if (pageName.equals(RegionWizard.PAGENAME_CREATE)) {
                    RegionWizard.this.setCurrentPage(RegionWizard.PAGENAME_COMPLETE);
                }
            }
        });
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(MedSavantFrame.getInstance());
    }

    public Dimension getPreferredSize() {
        Dimension parentDimension = MedSavantFrame.getInstance().getSize();
        int xdim = Math.min(1520, Math.max(960, parentDimension.width - 100));
        int ydim = Math.min(950, Math.max(600, parentDimension.height - 100));
        return new Dimension(xdim, ydim);
    }

    private AbstractWizardPage getNamePage() {
        return new DefaultWizardPage(PAGENAME_NAME){
            {
                this.addText("Choose a name for the region list.\nThe name cannot already be in use. ");
                this.addComponent(new JTextField(){
                    {
                        this.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyReleased(KeyEvent e) {
                                if (this.getText() != null && !this.getText().equals("")) {
                                    RegionWizard.this.listName = this.getText();
                                    this.fireButtonEvent(3301, "NEXT");
                                } else {
                                    this.fireButtonEvent(3302, "NEXT");
                                }
                            }
                        });
                    }
                });
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3299, "NEXT");
                if (RegionWizard.this.listName == null || RegionWizard.this.listName.equals("")) {
                    this.fireButtonEvent(3302, "NEXT");
                } else {
                    this.fireButtonEvent(3301, "NEXT");
                }
            }
        };
    }

    private AbstractWizardPage getFilePage() {
        return new DefaultWizardPage(PAGENAME_FILE){
            {
                ImportFilePanel importPanel = new ImportFilePanel(1){

                    @Override
                    public void setReady(boolean ready) {
                        if (ready) {
                            RegionWizard.this.path = this.getPath();
                            RegionWizard.this.delim = this.getDelimiter();
                            RegionWizard.this.fileFormat = this.getFileFormat();
                            RegionWizard.this.numHeaderLines = this.getNumHeaderLines();
                            this.fireButtonEvent(3301, "NEXT");
                        } else {
                            this.fireButtonEvent(3302, "NEXT");
                        }
                    }
                };
                importPanel.addFileFormat(new BEDFormat());
                this.addComponent(importPanel);
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3299, "NEXT");
                if (RegionWizard.this.path == null || RegionWizard.this.path.equals("")) {
                    this.fireButtonEvent(3302, "NEXT");
                } else {
                    this.fireButtonEvent(3301, "NEXT");
                }
            }
        };
    }

    private AbstractWizardPage getGenesPage() {
        return new DefaultWizardPage(PAGENAME_GENES){
            private static final int GENE_SELECTION_PANE_WIDTH = 350;
            private JPanel leftSide;
            private GeneSelectionPanel geneManiaResultsPanel;
            private Set<String> geneManiaGeneNames;
            {
                this.geneManiaGeneNames = null;
                RegionWizard.this.selectedGenesPanel = new GeneSelectionPanel(true, true);
                RegionWizard.this.sourceGenesPanel = new GeneSelectionPanel(true, true);
                this.geneManiaResultsPanel = new GeneSelectionPanel(true, true){

                    @Override
                    protected void dragAndDropAddGenes(Set<Gene> geneSet) {
                        HashSet<Object> genesToMoveToGeneManiaPanel = new HashSet<Object>(geneManiaGeneNames);
                        genesToMoveToGeneManiaPanel.retainAll(RegionWizard.this.selectedGenesPanel.getSelectedKeys());
                        RegionWizard.this.selectedGenesPanel.copyItems(geneManiaResultsPanel, genesToMoveToGeneManiaPanel);
                        RegionWizard.this.selectedGenesPanel.moveSelectedItems(RegionWizard.this.sourceGenesPanel);
                    }

                    @Override
                    protected void dragAndDropRemoveKeys(Set<Object> keySet) {
                        Set<Object> keys = geneManiaResultsPanel.getSelectedKeys();
                        geneManiaResultsPanel.removeRows(keys);
                        RegionWizard.this.sourceGenesPanel.removeRows(keys);
                    }
                };
                this.geneManiaResultsPanel.setOddRowColor(new Color(242, 249, 245));
                RegionWizard.this.runGeneManiaButton = new JButton("Run GeneMANIA");
                RegionWizard.this.runGeneManiaButton.setEnabled(!DirectorySettings.isGeneManiaInstalled());
                ListSelectionListener selectionListener = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent lse) {
                        int numSel = RegionWizard.this.sourceGenesPanel.getNumSelected() + RegionWizard.this.selectedGenesPanel.getNumSelected();
                        if (geneManiaGeneNames != null) {
                            numSel += geneManiaResultsPanel.getNumSelected();
                        }
                        if (GenemaniaInfoRetriever.isGeneManiaDownloading()) {
                            RegionWizard.this.runGeneManiaButton.setEnabled(false);
                        } else {
                            RegionWizard.this.runGeneManiaButton.setEnabled(numSel > 0 || !DirectorySettings.isGeneManiaInstalled());
                        }
                    }
                };
                RegionWizard.this.sourceGenesPanel.getTable().getSelectionModel().addListSelectionListener(selectionListener);
                RegionWizard.this.selectedGenesPanel.getTable().getSelectionModel().addListSelectionListener(selectionListener);
                RegionWizard.this.selectedGenesPanel.getTable().getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tme) {
                        if (RegionWizard.this.selectedGenesPanel.getData().length > 0) {
                            this.fireButtonEvent(3301, "NEXT");
                        } else {
                            this.fireButtonEvent(3302, "NEXT");
                        }
                    }
                });
                RegionWizard.this.selectedGenesPanel.setPreferredSize(new Dimension(350, ((RegionWizard)RegionWizard.this).selectedGenesPanel.getPreferredSize().height));
                JPanel outerLeftSide = new JPanel();
                outerLeftSide.setLayout(new BoxLayout(outerLeftSide, 0));
                this.leftSide = new JPanel();
                this.leftSide.setLayout(new BoxLayout(this.leftSide, 1));
                this.leftSide.add(RegionWizard.this.sourceGenesPanel);
                outerLeftSide.add(this.leftSide);
                JPanel bg = new JPanel();
                bg.setLayout(new BoxLayout(bg, 1));
                JButton addButton = new JButton("Add \u2192");
                JButton removeButton = new JButton("\u2190 Remove");
                RegionWizard.this.sourceGenesPanel.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        if (me.getClickCount() == 2) {
                            RegionWizard.this.sourceGenesPanel.moveSelectedItems(RegionWizard.this.selectedGenesPanel);
                        }
                    }
                });
                RegionWizard.this.selectedGenesPanel.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        if (me.getClickCount() == 2) {
                            if (geneManiaGeneNames != null) {
                                HashSet<Object> genesToMoveToGeneManiaPanel = new HashSet<Object>(geneManiaGeneNames);
                                genesToMoveToGeneManiaPanel.retainAll(RegionWizard.this.selectedGenesPanel.getSelectedKeys());
                                RegionWizard.this.selectedGenesPanel.copyItems(geneManiaResultsPanel, genesToMoveToGeneManiaPanel);
                            }
                            RegionWizard.this.selectedGenesPanel.moveSelectedItems(RegionWizard.this.sourceGenesPanel);
                        }
                    }
                });
                this.geneManiaResultsPanel.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        if (me.getClickCount() == 2) {
                            Set<Object> keys = geneManiaResultsPanel.getSelectedKeys();
                            geneManiaResultsPanel.moveSelectedItems(RegionWizard.this.selectedGenesPanel);
                            RegionWizard.this.sourceGenesPanel.moveItems(RegionWizard.this.selectedGenesPanel, keys);
                        }
                    }
                });
                addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (geneManiaGeneNames != null) {
                            Set<Object> keys = geneManiaResultsPanel.getSelectedKeys();
                            geneManiaResultsPanel.moveSelectedItems(RegionWizard.this.selectedGenesPanel);
                            RegionWizard.this.sourceGenesPanel.moveItems(RegionWizard.this.selectedGenesPanel, keys);
                        } else {
                            RegionWizard.this.sourceGenesPanel.moveSelectedItems(RegionWizard.this.selectedGenesPanel);
                        }
                    }
                });
                removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (geneManiaGeneNames != null) {
                            HashSet<Object> genesToMoveToGeneManiaPanel = new HashSet<Object>(geneManiaGeneNames);
                            genesToMoveToGeneManiaPanel.retainAll(RegionWizard.this.selectedGenesPanel.getSelectedKeys());
                            RegionWizard.this.selectedGenesPanel.copyItems(geneManiaResultsPanel, genesToMoveToGeneManiaPanel);
                        }
                        RegionWizard.this.selectedGenesPanel.moveSelectedItems(RegionWizard.this.sourceGenesPanel);
                    }
                });
                bg.add(Box.createVerticalGlue());
                bg.add(addButton);
                bg.add(removeButton);
                bg.add(Box.createVerticalGlue());
                outerLeftSide.add(bg);
                JPanel rightSide = new JPanel();
                rightSide.setLayout(new BoxLayout(rightSide, 1));
                rightSide.add(RegionWizard.this.selectedGenesPanel);
                rightSide.add(RegionWizard.this.runGeneManiaButton);
                JSplitPane hsplitPane = new JSplitPane(1, outerLeftSide, rightSide);
                hsplitPane.setResizeWeight(1.0);
                this.addComponent(hsplitPane, true);
                if (!DirectorySettings.isGeneManiaInstalled()) {
                    RegionWizard.this.runGeneManiaButton.setText("Download GeneMANIA");
                    if (GenemaniaInfoRetriever.isGeneManiaDownloading()) {
                        RegionWizard.this.runGeneManiaButton.setEnabled(false);
                        RegionWizard.this.registerDownloadListener();
                    }
                }
                RegionWizard.this.runGeneManiaButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (!DirectorySettings.isGeneManiaInstalled()) {
                            int response = DialogUtils.askYesNo("Download GeneMANIA?", "GeneMANIA is not yet installed.  Do you want to download and install it now?");
                            try {
                                if (response == 0) {
                                    RegionWizard.this.runGeneManiaButton.setText("Run GeneMANIA");
                                    RegionWizard.this.runGeneManiaButton.setEnabled(false);
                                    RegionWizard.this.registerDownloadListener();
                                    GenemaniaInfoRetriever.getGeneManiaDownloadTask().execute();
                                }
                            }
                            catch (IOException e) {
                                DialogUtils.displayMessage("Error downloading GeneMANIA files");
                                LOG.error((Object)e);
                            }
                        } else {
                            final LinkedList<String> selectedGenes = new LinkedList<String>();
                            for (Gene g : RegionWizard.this.selectedGenesPanel.getSelectedGenes()) {
                                selectedGenes.add(g.getName());
                            }
                            for (Gene g : RegionWizard.this.sourceGenesPanel.getSelectedGenes()) {
                                selectedGenes.add(g.getName());
                            }
                            if (geneManiaGeneNames != null) {
                                for (Gene g : geneManiaResultsPanel.getSelectedGenes()) {
                                    selectedGenes.add(g.getName());
                                }
                            }
                            final JButton closeGeneManiaButton = new JButton("\u2190 Close GeneMANIA results");
                            closeGeneManiaButton.setEnabled(false);
                            final JPanel geneManiaContainingPanel = new JPanel();
                            geneManiaContainingPanel.setLayout(new BoxLayout(geneManiaContainingPanel, 1));
                            final SwingWorker geneManiaWorker = new SwingWorker(){
                                private List<Object[]> results;

                                @Override
                                public void done() {
                                    Object[][] newdata = new Object[this.results.size()][4];
                                    this.results.toArray((T[])newdata);
                                    geneManiaResultsPanel.updateData(newdata);
                                    geneManiaResultsPanel.updateView();
                                    geneManiaContainingPanel.removeAll();
                                    geneManiaContainingPanel.add(geneManiaResultsPanel);
                                    geneManiaContainingPanel.revalidate();
                                    geneManiaContainingPanel.repaint();
                                    closeGeneManiaButton.setEnabled(true);
                                }

                                public Object doInBackground() {
                                    try {
                                        GenemaniaInfoRetriever genemania = new GenemaniaInfoRetriever();
                                        genemania.setGenes(selectedGenes);
                                        List<String> geneNameList = genemania.getRelatedGeneNamesByScore();
                                        geneManiaGeneNames = new HashSet();
                                        geneManiaGeneNames.addAll(geneNameList);
                                        LOG.debug((Object)("Found " + geneNameList.size() + " related genes"));
                                        this.results = new ArrayList<Object[]>(geneNameList.size());
                                        boolean i = false;
                                        for (String gene : geneNameList) {
                                            if (this.isCancelled()) {
                                                return null;
                                            }
                                            Gene g = GeneSetFetcher.getInstance().getGeneDictionary().get(gene);
                                            if (g == null) {
                                                LOG.warn((Object)("No gene found for " + gene));
                                                continue;
                                            }
                                            if (RegionWizard.this.selectedGenesPanel.hasKey(g.getName())) continue;
                                            this.results.add(new Object[]{g.getName(), g.getChrom(), g.getStart(), g.getEnd()});
                                        }
                                    }
                                    catch (IOException e) {
                                        LOG.error((Object)e);
                                    }
                                    catch (ApplicationException e) {
                                        LOG.error((Object)e);
                                    }
                                    catch (DataStoreException e) {
                                        LOG.error((Object)e);
                                    }
                                    catch (GenemaniaInfoRetriever.NoRelatedGenesInfoException e) {
                                        LOG.error((Object)e);
                                    }
                                    return null;
                                }
                            };
                            leftSide.removeAll();
                            closeGeneManiaButton.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    try {
                                        geneManiaWorker.cancel(true);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    leftSide.removeAll();
                                    leftSide.add(RegionWizard.this.sourceGenesPanel);
                                    leftSide.validate();
                                    leftSide.repaint();
                                    geneManiaGeneNames = null;
                                }
                            });
                            JPanel closeButtonPanel = new JPanel();
                            closeButtonPanel.setLayout(new BoxLayout(closeButtonPanel, 0));
                            closeButtonPanel.add(closeGeneManiaButton);
                            closeButtonPanel.add(Box.createHorizontalGlue());
                            leftSide.add(closeButtonPanel);
                            geneManiaContainingPanel.add(new WaitPanel("Querying GeneMANIA for related genes"));
                            leftSide.add(geneManiaContainingPanel);
                            leftSide.validate();
                            leftSide.repaint();
                            geneManiaWorker.execute();
                        }
                    }
                });
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                if (RegionWizard.this.selectedGenesPanel.getNumSelected() > 0) {
                    this.fireButtonEvent(3301, "NEXT");
                } else {
                    this.fireButtonEvent(3302, "NEXT");
                }
            }
        };
    }

    private AbstractWizardPage getCreationPage() {
        return new DefaultWizardPage(PAGENAME_CREATE){
            private JProgressBar progressBar;
            private JButton startButton;
            {
                this.addText("You are now ready to create this region list.");
                this.progressBar = new JProgressBar();
                this.addComponent(this.progressBar);
                this.startButton = new JButton("Create List");
                this.startButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        startButton.setEnabled(false);
                        this.fireButtonEvent(3302, "BACK");
                        progressBar.setIndeterminate(true);
                        new MedSavantWorker<Void>("Region Lists"){

                            @Override
                            public Void doInBackground() throws Exception {
                                RegionWizard.this.createList();
                                return null;
                            }

                            @Override
                            protected void showProgress(double fraction) {
                            }

                            @Override
                            protected void showSuccess(Void result) {
                                ((CompletionWizardPage)RegionWizard.this.getPageByTitle(RegionWizard.PAGENAME_COMPLETE)).addText("List " + RegionWizard.this.listName + " has been successfully created.");
                                RegionWizard.this.setCurrentPage(RegionWizard.PAGENAME_COMPLETE);
                            }

                            @Override
                            protected void showFailure(Throwable t) {
                                RegionWizard.this.setVisible(false);
                                LOG.error((Object)"Error uploading list.", t);
                                DialogUtils.displayException("Error", "There was an error while trying to create your list. ", t);
                            }
                        }.execute();
                    }
                });
                this.addComponent(ViewUtil.alignRight(this.startButton));
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3299, "NEXT");
                this.fireButtonEvent(3302, "NEXT");
            }
        };
    }

    private AbstractWizardPage getCompletionPage() {
        return new CompletionWizardPage(PAGENAME_COMPLETE){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3301, "FINISH");
                this.fireButtonEvent(3300, "NEXT");
            }
        };
    }

    private boolean validateListName() {
        try {
            for (RegionSet r : this.controller.getRegionSets()) {
                if (!r.getName().equals(this.listName)) continue;
                DialogUtils.displayError("Error", "List name already in use.");
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error fetching region list: %s", ex);
            return false;
        }
    }

    private void createList() throws SQLException, IOException, InterruptedException, ExecutionException {
        if (!this.importing) {
            File tempFile = File.createTempFile("genes", ".bed");
            FileWriter output = new FileWriter(tempFile);
            for (Object[] rowData : this.selectedGenesPanel.getData()) {
                output.write(rowData[1] + "\t" + rowData[2] + "\t" + rowData[3] + "\t" + rowData[0] + "\n");
            }
            output.close();
            this.delim = (char)9;
            this.numHeaderLines = 0;
            this.fileFormat = new BEDFormat();
            this.path = tempFile.getAbsolutePath();
        }
        int transferID = ClientNetworkUtils.copyFileToServer(new File(this.path));
        this.controller.addRegionSet(this.listName, this.delim, this.fileFormat, this.numHeaderLines, transferID);
    }

    private void fetchGenes() {
        new GeneFetcher(this.standardGenes, "RegionWizard"){

            @Override
            public void setData(Object[][] data) {
                RegionWizard.this.sourceGenesPanel.updateData(data);
                RegionWizard.this.sourceGenesPanel.updateView();
            }

            @Override
            public void showProgress(double prog) {
            }
        }.execute();
    }

    private class GeneManiaDownloadCompleteListener
    implements PropertyChangeListener {
        private GeneManiaDownloadCompleteListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DownloadTask.DownloadState ds;
            if (evt.getPropertyName().equals("downloadState") && ((ds = (DownloadTask.DownloadState)((Object)evt.getNewValue())) == DownloadTask.DownloadState.CANCELLED || ds == DownloadTask.DownloadState.FINISHED)) {
                if (ds == DownloadTask.DownloadState.FINISHED) {
                    RegionWizard.this.runGeneManiaButton.setText("Run GeneMANIA");
                } else {
                    RegionWizard.this.runGeneManiaButton.setText("Download GeneMANIA");
                }
                if (RegionWizard.this.runGeneManiaButton != null) {
                    RegionWizard.this.runGeneManiaButton.setEnabled(RegionWizard.this.selectedGenesPanel.getNumSelected() + RegionWizard.this.sourceGenesPanel.getNumSelected() > 0);
                }
            }
        }
    }
}

