/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import com.jidesoft.list.FilterableCheckBoxList;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.UnmarshalException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

public class ClientMiscUtils
extends MiscUtils {
    private static final Log LOG = LogFactory.getLog(ClientMiscUtils.class);
    public static final String GENDER_MALE = "Male";
    public static final String GENDER_FEMALE = "Female";
    public static final String GENDER_UNKNOWN = "Undesignated";

    public static String genderToString(int gender) {
        switch (gender) {
            case 1: {
                return GENDER_MALE;
            }
            case 2: {
                return GENDER_FEMALE;
            }
        }
        return GENDER_UNKNOWN;
    }

    public static int stringToGender(String gender) {
        if (gender.equals(GENDER_MALE)) {
            return 1;
        }
        if (gender.equals(GENDER_FEMALE)) {
            return 2;
        }
        return 0;
    }

    public static int safeLongToInt(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int without changing its value.");
        }
        return (int)l;
    }

    public static double getDouble(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Long) {
            return ((Long)o).doubleValue();
        }
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        return -1.0;
    }

    public static void reportError(String message, Throwable t) {
        if (t instanceof ConnectException) {
            message = String.format(message, "server refused connection");
        } else if (t instanceof UnmarshalException) {
            message = String.format(message, "connection to server lost");
            MedSavantFrame.getInstance().forceRestart();
        } else if (t instanceof NoSuchObjectException) {
            message = String.format(message, "server has been restarted");
            MedSavantFrame.getInstance().forceRestart();
        } else {
            message = String.format(message, ClientMiscUtils.getMessage(t));
        }
        LOG.error((Object)message, t);
        if (!ClientMiscUtils.checkSQLException(t)) {
            DialogUtils.displayException("MedSavant", message, t);
        }
    }

    public static boolean checkSQLException(Throwable t) {
        if (t instanceof SQLException && (t.getMessage().contains("Unknown column") || t.getMessage().contains("doesn't exist"))) {
            DialogUtils.displayErrorMessage("<html>It appears that the database structure has been modified.<br>Please log back in for the changes to take effect.</html>", t);
            MedSavantFrame.getInstance().forceRestart();
            return true;
        }
        return false;
    }

    public static Map<Object, List<String>> modifyGenderMap(Map<Object, List<String>> original) {
        HashMap<Object, List<String>> result = new HashMap<Object, List<String>>();
        for (Object key : original.keySet()) {
            String s;
            if (key instanceof Long) {
                s = ClientMiscUtils.genderToString(ClientMiscUtils.safeLongToInt((Long)key));
            } else if (key instanceof Integer) {
                Long x = new Long(((Integer)key).longValue());
                s = ClientMiscUtils.genderToString(ClientMiscUtils.safeLongToInt(x));
            } else {
                s = GENDER_UNKNOWN;
            }
            if (result.get(s) == null) {
                result.put(s, original.get(key));
                continue;
            }
            ((List)result.get(s)).addAll((Collection)original.get(key));
        }
        return result;
    }

    public static void registerCancelButton(final JButton cancelButton) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JDialog dialog = (JDialog)SwingUtilities.getWindowAncestor(cancelButton);
        dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                cancelButton.doClick();
            }
        }, stroke, 2);
    }

    public static void setUnsavedTitle(JFrame f, String title, boolean unsaved) {
        f.getRootPane().putClientProperty("Window.documentModified", unsaved);
        if (!MAC && unsaved) {
            f.setTitle(title + " *");
        } else {
            f.setTitle(title);
        }
    }

    public static void drawCentred(Graphics2D g2, String message, Rectangle2D box) {
        FontMetrics metrics = g2.getFontMetrics();
        Rectangle2D stringBounds = g2.getFont().getStringBounds(message, g2.getFontRenderContext());
        float x = (float)(box.getX() + (box.getWidth() - stringBounds.getWidth()) / 2.0);
        float y = (float)(box.getY() + (box.getHeight() + (double)metrics.getAscent() - (double)metrics.getDescent()) / 2.0);
        g2.drawString(message, x, y);
    }

    public static String breakString(String remainingStr, String soFar, int maxLineLength) {
        if (remainingStr.length() < maxLineLength) {
            return "<html>" + soFar + remainingStr + "</html>";
        }
        int endIndex = maxLineLength > remainingStr.length() ? remainingStr.length() : maxLineLength;
        int indexOfBreak = remainingStr.substring(0, endIndex).lastIndexOf(" ");
        if (indexOfBreak == -1) {
            soFar = soFar + remainingStr.substring(0, maxLineLength) + "<br>-";
            return ClientMiscUtils.breakString(remainingStr.substring(maxLineLength), soFar, maxLineLength);
        }
        soFar = soFar + remainingStr.substring(0, indexOfBreak) + "<br>";
        return ClientMiscUtils.breakString(remainingStr.substring(indexOfBreak), soFar, maxLineLength);
    }

    public static double round(double unrounded, int precision) {
        BigDecimal bd = new BigDecimal(unrounded);
        BigDecimal rounded = bd.setScale(precision, 4);
        return rounded.doubleValue();
    }

    public static void selectOnlyTheseIndicies(FilterableCheckBoxList filterableList, int[] selectedIndices) {
        for (int k = 0; k < filterableList.getModel().getSize(); ++k) {
            filterableList.removeCheckBoxListSelectedIndex(k);
        }
        for (int j : selectedIndices) {
            if (j == -1) continue;
            filterableList.addCheckBoxListSelectedIndex(j);
        }
    }
}

