/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.ThreadController;
import org.ut.biolab.medsavant.shared.model.ProgressStatus;

public abstract class MedSavantWorker<T> {
    private static final Log LOG = LogFactory.getLog(MedSavantWorker.class);
    private static final int MAX_MEDSAVANT_WORKER_THREADS = 20;
    private String pageName;
    private SwingWorker<T, Object> swingWorker;
    private static ExecutorService threadPool = Executors.newFixedThreadPool(20);
    protected Timer progressTimer;

    public MedSavantWorker(String pageName) {
        this.pageName = pageName;
        ThreadController.getInstance().addWorker(pageName, this);
        final MedSavantWorker instance = this;
        this.swingWorker = new SwingWorker<T, Object>(){

            @Override
            public void done() {
                instance.done();
            }

            @Override
            protected T doInBackground() throws Exception {
                return instance.doInBackground();
            }
        };
    }

    public void execute() {
        threadPool.submit(this.swingWorker);
    }

    protected abstract T doInBackground() throws Exception;

    public boolean isDone() {
        return this.swingWorker.isDone();
    }

    public boolean cancel(boolean cancel) {
        return this.swingWorker.cancel(cancel);
    }

    public SwingWorker.StateValue getState() {
        return this.swingWorker.getState();
    }

    public boolean isCancelled() {
        return this.swingWorker.isCancelled();
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.swingWorker.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.swingWorker.addPropertyChangeListener(pcl);
    }

    public final int getProgress() {
        return this.swingWorker.getProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        block11: {
            if (this.progressTimer != null) {
                this.progressTimer.stop();
            }
            this.showProgress(1.0);
            try {
                if (!this.swingWorker.isCancelled()) {
                    this.showSuccess(this.swingWorker.get());
                    break block11;
                }
                try {
                    this.checkProgress();
                }
                catch (Exception ex) {
                    LOG.info((Object)"Ignoring exception thrown while cancelling.", (Throwable)ex);
                }
                throw new InterruptedException();
            }
            catch (InterruptedException x) {
                this.showFailure(x);
            }
            catch (ExecutionException x) {
                this.showFailure(x.getCause());
            }
            finally {
                ThreadController.getInstance().removeWorker(this.pageName, this);
            }
        }
    }

    protected void showProgress(double fract) {
    }

    protected abstract void showSuccess(T var1);

    protected void showFailure(Throwable t) {
        if (!(t instanceof InterruptedException)) {
            ClientMiscUtils.reportError("Exception thrown by background task: %s", t);
        }
    }

    protected ProgressStatus checkProgress() throws Exception {
        return null;
    }

    protected void startProgressTimer() {
        this.progressTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    ProgressStatus status = MedSavantWorker.this.checkProgress();
                    if (status != null) {
                        MedSavantWorker.this.showProgress(status.fractionCompleted);
                    }
                }
                catch (Exception ex) {
                    LOG.info((Object)"Ignoring exception thrown while checking for progress.", (Throwable)ex);
                }
            }
        });
        this.progressTimer.start();
    }
}

