/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.ProgressWheel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public abstract class VisibleMedSavantWorker<T>
extends MedSavantWorker<T>
implements PropertyChangeListener {
    private static final String THREAD_INTERRUPTED_LABEL = "CANCELLED";
    private static final String THREAD_EXCEPTION_LABEL = "FAILED";
    private static final Log LOG = LogFactory.getLog(VisibleMedSavantWorker.class);
    double progress = 0.0;
    String statusMessage = "";
    String title;
    boolean cancellable;
    boolean indeterminate;
    private final JLabel titleLabel;
    private final JLabel statusLabel;
    private final ProgressWheel progressBar;
    private final JButton cancelButton;
    private final JButton resultsButton;
    private final JButton closeButton;
    private JobStatus status;
    private boolean showResultsOnFinish = true;
    private JPanel view = ViewUtil.getClearPanel();

    public VisibleMedSavantWorker(String pageName, String title) {
        super(pageName);
        this.view.setOpaque(false);
        this.view.setBorder(ViewUtil.getMediumBorder());
        this.view.setLayout(new BoxLayout(this.view, 1));
        this.title = title;
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(new Font("Arial", 1, 12));
        this.statusLabel = new JLabel();
        this.progressBar = ViewUtil.getIndeterminateProgressBar();
        this.resultsButton = ViewUtil.getSoftButton("View Results");
        this.cancelButton = ViewUtil.getSoftButton("Cancel");
        this.closeButton = ViewUtil.getSoftButton("Close");
        this.resultsButton.setVisible(false);
        this.closeButton.setVisible(false);
        this.resultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VisibleMedSavantWorker.this.showResults();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VisibleMedSavantWorker.this.cancel(true);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VisibleMedSavantWorker.this.closeJob();
            }
        });
        JPanel buttonBar = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(buttonBar);
        buttonBar.add(this.resultsButton);
        buttonBar.add(this.cancelButton);
        buttonBar.add(this.closeButton);
        JPanel statusPanel = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(statusPanel);
        statusPanel.add(this.statusLabel);
        statusPanel.add(Box.createHorizontalStrut(20));
        statusPanel.add(Box.createHorizontalGlue());
        statusPanel.add(this.progressBar);
        statusPanel.setPreferredSize(new Dimension(300, 25));
        statusPanel.setMinimumSize(new Dimension(300, 25));
        this.view.add(ViewUtil.alignLeft(this.titleLabel));
        this.view.add(statusPanel);
        this.view.add(ViewUtil.alignRight(buttonBar));
        this.setStatus(JobStatus.NOT_STARTED);
    }

    public void showResultsOnFinish(boolean srof) {
        this.showResultsOnFinish = srof;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        this.statusLabel.setText(ViewUtil.ellipsize(statusMessage, 45));
        this.statusLabel.setToolTipText(statusMessage);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleLabel.setText(title);
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public void setCancellable(boolean isCancellable) {
        this.cancellable = isCancellable;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
        this.progressBar.setIndeterminate(indeterminate);
    }

    public JobStatus getStatus() {
        return this.status;
    }

    protected void setStatus(JobStatus st) {
        this.status = st;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (VisibleMedSavantWorker.this.status) {
                    case CANCELLED: {
                        VisibleMedSavantWorker.this.setStatusMessage("Cancelled");
                        VisibleMedSavantWorker.this.cancelButton.setVisible(false);
                        VisibleMedSavantWorker.this.closeButton.setVisible(true);
                        VisibleMedSavantWorker.this.progressBar.setVisible(false);
                        break;
                    }
                    case NOT_STARTED: {
                        break;
                    }
                    case RUNNING: {
                        break;
                    }
                    case FINISHED: {
                        if (VisibleMedSavantWorker.this.showResultsOnFinish) {
                            VisibleMedSavantWorker.this.resultsButton.setVisible(true);
                        }
                        VisibleMedSavantWorker.this.cancelButton.setVisible(false);
                        VisibleMedSavantWorker.this.closeButton.setVisible(true);
                        VisibleMedSavantWorker.this.progressBar.setIndeterminate(false);
                        VisibleMedSavantWorker.this.progressBar.setComplete();
                        VisibleMedSavantWorker.this.progressBar.setValue(VisibleMedSavantWorker.this.progressBar.getMaximum());
                    }
                }
            }
        });
    }

    @Override
    public final void propertyChange(PropertyChangeEvent evt) {
        if (!this.progressBar.isIndeterminate() && "progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    @Override
    protected final T doInBackground() throws Exception {
        try {
            this.setStatus(JobStatus.RUNNING);
            if (!this.isIndeterminate()) {
                this.startProgressTimer();
            }
            return this.runInBackground();
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }

    @Override
    public final boolean cancel(boolean cancel) {
        boolean b = super.cancel(cancel);
        if (cancel) {
            this.setStatus(JobStatus.CANCELLED);
            this.cancelJob();
        }
        return b;
    }

    @Override
    protected final void showSuccess(T result) {
        this.setStatus(JobStatus.FINISHED);
        this.jobDone();
    }

    protected void jobDone() {
        this.setStatusMessage("Finished.");
    }

    protected void cancelJob() {
        this.setStatusMessage("Cancelled");
    }

    @Override
    protected void showFailure(Throwable ex) {
        this.setStatus(JobStatus.CANCELLED);
        if (ex instanceof InterruptedException) {
            this.setStatusMessage(THREAD_INTERRUPTED_LABEL);
        } else {
            LOG.error((Object)THREAD_EXCEPTION_LABEL, ex);
            this.setStatusMessage(THREAD_EXCEPTION_LABEL);
        }
    }

    protected abstract T runInBackground() throws Exception;

    protected void showResults() {
    }

    protected void closeJob() {
    }

    public static enum JobStatus {
        NOT_STARTED,
        RUNNING,
        CANCELLED,
        FINISHED;

    }
}

