/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.variant;

import java.util.ArrayList;
import java.util.List;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.variant.ImportVariantsWizardWithAnnotation;
import org.ut.biolab.medsavant.client.variant.RemoveVariantsWizard;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.SimpleVariantFile;
import org.ut.biolab.medsavant.shared.model.UserLevel;

class VariantFilesDetailedListEditor
extends DetailedListEditor {
    VariantFilesDetailedListEditor() {
    }

    @Override
    public boolean doesImplementAdding() {
        return LoginController.getInstance().getUserLevel() == UserLevel.ADMIN;
    }

    @Override
    public boolean doesImplementDeleting() {
        return LoginController.getInstance().getUserLevel() == UserLevel.ADMIN;
    }

    @Override
    public void addItems() {
        try {
            if (ProjectController.getInstance().promptForUnpublished()) {
                String sessionID = LoginController.getSessionID();
                if (!MedSavantClient.SettingsManager.isProjectLockedForChanges(sessionID, ProjectController.getInstance().getCurrentProjectID())) {
                    new ImportVariantsWizardWithAnnotation().setVisible(true);
                } else {
                    DialogUtils.displayMessage("Cannot Modify Project", "This project is currently locked for changes.\nTo unlock, see the Projects page in the Administration section.");
                }
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error checking for changes: %s", ex);
        }
    }

    @Override
    public void deleteItems(List<Object[]> results) {
        block7: {
            ArrayList<SimpleVariantFile> files = new ArrayList<SimpleVariantFile>();
            for (Object[] f : results) {
                files.add((SimpleVariantFile)f[0]);
            }
            if (!files.isEmpty()) {
                try {
                    if (!ProjectController.getInstance().promptForUnpublished()) break block7;
                    try {
                        if (!MedSavantClient.SettingsManager.isProjectLockedForChanges(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID())) {
                            new RemoveVariantsWizard(files).setVisible(true);
                            break block7;
                        }
                        DialogUtils.displayMessage("Cannot Modify Project", "This project is currently locked for changes.\nTo unlock, see the Projects page in the Administration section.");
                    }
                    catch (Exception ex) {
                        ClientMiscUtils.reportError("Error getting database lock: %s", ex);
                    }
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Error checking for changes: %s", ex);
                }
            }
        }
    }
}

