/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientNetworkUtils;
import org.ut.biolab.medsavant.client.util.DownloadEvent;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.app.AppDirectory;
import org.ut.biolab.medsavant.client.view.app.FileDrop;
import org.ut.biolab.medsavant.client.view.app.builtin.task.BackgroundTaskWorker;
import org.ut.biolab.medsavant.client.view.app.builtin.task.TaskWorker;
import org.ut.biolab.medsavant.client.view.component.PlaceHolderTextField;
import org.ut.biolab.medsavant.client.view.component.RoundedPanel;
import org.ut.biolab.medsavant.client.view.dashboard.LaunchableApp;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.images.ImagePanel;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.notify.Notification;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.StandardAppContainer;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.serverapi.VariantManagerAdapter;
import org.ut.biolab.medsavant.shared.util.ExtensionsFileFilter;
import org.ut.biolab.medsavant.shared.util.IOUtils;

public class VCFUploadApp
implements LaunchableApp {
    private static final Log LOG = LogFactory.getLog(VCFUploadApp.class);
    private static VariantManagerAdapter variantManager = MedSavantClient.VariantManager;
    List<File> filesToImport = new ArrayList<File>();
    private JPanel fileListView;
    private static FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isFile() && (f.getAbsolutePath().endsWith(".vcf") || IOUtils.isArchive(f));
        }

        @Override
        public String getDescription() {
            return "VCF file(s)";
        }
    };
    private JPanel advancedOptionsPanel;
    private JButton importButton;
    private JXCollapsiblePane dragDropContainer;
    private CardLayout cardLayout;
    private JCheckBox annovarCheckbox;
    private JCheckBox phasingCheckbox;
    private PlaceHolderTextField emailPlaceholder;
    private JCheckBox includeReferenceCheckbox;
    private JPanel view;

    @Override
    public JPanel getView() {
        return this.view;
    }

    private void initView() {
        if (this.view == null) {
            JPanel settingsCard = this.getSettingsPanel();
            JPanel fixedWidth = ViewUtil.getDefaultFixedWidthPanel(settingsCard);
            this.view = new StandardAppContainer(fixedWidth, true);
            this.view.setBackground(ViewUtil.getLightGrayBackgroundColor());
            this.refreshFileList();
        }
    }

    private void initSettingsPanel() {
        this.advancedOptionsPanel = ViewUtil.getWhiteLineBorderedPanel();
        this.advancedOptionsPanel.setLayout((LayoutManager)new MigLayout("fillx"));
        this.advancedOptionsPanel.setVisible(false);
        JLabel l = new JLabel("Advanced Options");
        l.setFont(ViewUtil.getMediumTitleFont());
        this.advancedOptionsPanel.add((Component)l, "wrap");
        this.advancedOptionsPanel.add((Component)ViewUtil.getSettingsHeaderLabel("Annotation"), "wrap");
        this.annovarCheckbox = new JCheckBox("perform gene-based variant annotation");
        this.advancedOptionsPanel.add((Component)this.annovarCheckbox, "wrap");
        this.phasingCheckbox = new JCheckBox("perform phasing");
        this.advancedOptionsPanel.add((Component)this.phasingCheckbox, "wrap");
        this.annovarCheckbox.setSelected(true);
        this.annovarCheckbox.setFocusable(false);
        this.phasingCheckbox.setSelected(false);
        this.phasingCheckbox.setFocusable(false);
        this.includeReferenceCheckbox = new JCheckBox("include all VCF lines, including reference calls (highly recommended for pharmacogenetic testing)");
        this.includeReferenceCheckbox.setSelected(true);
        this.includeReferenceCheckbox.setFocusable(false);
        this.advancedOptionsPanel.add((Component)this.includeReferenceCheckbox, "wrap");
        this.advancedOptionsPanel.add((Component)ViewUtil.getSettingsHeaderLabel("Notifications"), "wrap");
        this.emailPlaceholder = new PlaceHolderTextField();
        this.emailPlaceholder.setPlaceholder("email address");
        this.advancedOptionsPanel.add((Component)ViewUtil.getSettingsHelpLabel("Email notifications are sent upon completion"), "wrap");
        this.advancedOptionsPanel.add((Component)this.emailPlaceholder, "wrap, growx 1.0");
    }

    private void addFilesToImport(File[] files) {
        for (File f : files) {
            this.addFileToImport(f);
        }
        this.refreshFileList();
    }

    private void addFileToImport(File f) {
        if (!fileFilter.accept(f)) {
            DialogUtils.displayMessage(String.format("File %s does not appear to be in the correct format", f.getName()));
            return;
        }
        if (this.filesToImport.contains(f)) {
            DialogUtils.displayMessage(String.format("File %s already listed for import", f.getName()));
            return;
        }
        this.filesToImport.add(f);
    }

    @Override
    public void viewWillUnload() {
    }

    @Override
    public void viewWillLoad() {
        this.initView();
    }

    @Override
    public void viewDidUnload() {
    }

    @Override
    public void viewDidLoad() {
    }

    @Override
    public ImageIcon getIcon() {
        return IconFactory.getInstance().getIcon(IconFactory.StandardIcon.APP_IMPORTVCF);
    }

    @Override
    public String getName() {
        return "VCF Upload";
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame();
        VCFUploadApp app = new VCFUploadApp();
        f.setPreferredSize(new Dimension(400, 400));
        f.setMinimumSize(new Dimension(400, 400));
        app.viewWillLoad();
        f.add(app.getView());
        f.pack();
        f.show();
        app.viewDidLoad();
    }

    private void refreshFileList() {
        this.fileListView.removeAll();
        MigLayout ml = new MigLayout("wrap 2");
        this.fileListView.setLayout((LayoutManager)ml);
        JLabel l = new JLabel("Files to upload");
        l.setFont(ViewUtil.getMediumTitleFont());
        this.fileListView.add((Component)l, "span 2, wrap");
        for (final File f : this.filesToImport) {
            JButton b = ViewUtil.getIconButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CLOSE));
            this.fileListView.add(b);
            this.fileListView.add(new JLabel(f.getAbsolutePath()));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VCFUploadApp.this.filesToImport.remove(f);
                    VCFUploadApp.this.refreshFileList();
                }
            });
        }
        if (this.filesToImport.isEmpty()) {
            this.fileListView.add((Component)ViewUtil.getGrayItalicizedLabel("No files selected for upload"), "wrap");
        } else {
            JButton clearAll = ViewUtil.getSoftButton("Clear All");
            clearAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VCFUploadApp.this.clearFiles();
                }
            });
            this.fileListView.add((Component)clearAll, "span 2, wrap");
        }
        this.fileListView.updateUI();
        this.importButton.setEnabled(!this.filesToImport.isEmpty());
        this.importButton.setSelected(!this.filesToImport.isEmpty());
        if (this.filesToImport.isEmpty()) {
            this.importButton.setText("Import");
        } else if (this.filesToImport.size() == 1) {
            this.importButton.setText("Import 1 file...");
        } else {
            this.importButton.setText(String.format("Import %s Files...", this.filesToImport.size()));
        }
    }

    private JPanel getSettingsPanel() {
        JPanel container = new JPanel();
        container.setBackground(ViewUtil.getLightGrayBackgroundColor());
        MigLayout layout = new MigLayout("insets 30 200 30 200, fillx, hidemode 3");
        container.setLayout((LayoutManager)layout);
        this.dragDropContainer = new JXCollapsiblePane();
        this.dragDropContainer.getContentPane().setBackground(Color.white);
        MigLayout dpMl = new MigLayout("wrap 1, center");
        this.dragDropContainer.getContentPane().setLayout((LayoutManager)dpMl);
        RoundedPanel dp = new RoundedPanel(0);
        dp.setLayout((LayoutManager)new MigLayout("wrap 1, center"));
        dp.setBackground(Color.white);
        dp.setOpaque(false);
        dp.setBorderDashed(true);
        dp.setDashThickness(2);
        ImagePanel ip = new ImagePanel(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.IMPORT_VCF).getImage(), 300, 200);
        dp.add(ip);
        dp.setFocusable(false);
        int topBorder = 0;
        int sideBorder = 50;
        dp.setBorder(BorderFactory.createEmptyBorder(topBorder, sideBorder, topBorder, sideBorder));
        JLabel l = new JLabel("Drag and drop .vcf (or .vcf.gz) files to be uploaded");
        l.setForeground(new Color(100, 100, 100));
        dp.add(l);
        this.dragDropContainer.add((Component)dp);
        l = new JLabel("or");
        this.dragDropContainer.add((Component)l, (Object)"center");
        l.setForeground(new Color(100, 100, 100));
        JButton chooseButton = new JButton("Choose...");
        chooseButton.setFocusable(false);
        this.dragDropContainer.add((Component)chooseButton, (Object)"center");
        chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] files = DialogUtils.chooseFilesForOpen("Choose Variant Files", new ExtensionsFileFilter(new String[]{"vcf", "vcf.gz", "vcf.bz2"}), null);
                VCFUploadApp.this.addFilesToImport(files);
            }
        });
        JPanel wrapper = ViewUtil.getWhiteLineBorderedPanel();
        wrapper.setLayout((LayoutManager)new MigLayout("fillx"));
        wrapper.add((Component)this.dragDropContainer, "growx 1.0");
        container.add((Component)wrapper, "wrap, width 100%");
        new FileDrop(dp, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                VCFUploadApp.this.addFilesToImport(files);
            }
        });
        this.fileListView = ViewUtil.getWhiteLineBorderedPanel();
        container.add((Component)this.fileListView, "wrap, width 100%");
        JToggleButton advancedOptionsButton = ViewUtil.getSoftToggleButton("Advanced Options");
        advancedOptionsButton.setFocusable(false);
        this.initSettingsPanel();
        advancedOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCFUploadApp.this.advancedOptionsPanel.setVisible(!VCFUploadApp.this.advancedOptionsPanel.isVisible());
            }
        });
        this.importButton = new JButton("Import");
        this.importButton.setEnabled(false);
        this.importButton.setFocusable(false);
        JPanel bContainer = ViewUtil.getClearPanel();
        bContainer.setLayout((LayoutManager)new MigLayout("fillx, insets 0"));
        bContainer.add((Component)advancedOptionsButton, "left");
        bContainer.add((Component)this.importButton, "right");
        container.add((Component)this.advancedOptionsPanel, "wrap, width 100%");
        container.add((Component)bContainer, "wrap,center");
        final VCFUploadApp instance = this;
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!ProjectController.getInstance().promptForUnpublished()) {
                        DialogUtils.displayError("Can't add new variants until changes are published.");
                        return;
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error checking for unpublished changes", (Throwable)ex);
                    DialogUtils.displayError("Can't import VCF files.  Please contact your system administrator.");
                    return;
                }
                new BackgroundTaskWorker(instance, "Upload Variants"){

                    protected Void doInBackground() throws Exception {
                        final 1 instance = this;
                        this.addLog("Upload started");
                        final Notification notification = this.getNotificationForWorker();
                        notification.setShowsProgress(true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MedSavantFrame.getInstance().showNotification(notification);
                            }
                        });
                        File[] copyOfFilesToImport = new File[VCFUploadApp.this.filesToImport.size()];
                        int counter = 0;
                        for (File f : VCFUploadApp.this.filesToImport) {
                            copyOfFilesToImport[counter++] = f;
                        }
                        VCFUploadApp.this.clearFiles();
                        final int[] transferIDs = new int[copyOfFilesToImport.length];
                        int fileIndex = 0;
                        int numFiles = copyOfFilesToImport.length;
                        for (File file : copyOfFilesToImport) {
                            LOG.info((Object)"Created input stream for file");
                            this.addLog(String.format("Uploading (%d/%d) %s...", fileIndex + 1, numFiles, file.getName()));
                            transferIDs[fileIndex++] = ClientNetworkUtils.copyFileToServer(file, new Listener<DownloadEvent>(){

                                @Override
                                public void handleEvent(DownloadEvent event) {
                                    switch (event.getType()) {
                                        case PROGRESS: {
                                            instance.setTaskProgress(event.getProgress());
                                        }
                                    }
                                }
                            }).get();
                        }
                        this.addLog("Done uploading variants");
                        this.addLog("Queuing background import job...");
                        this.addLog("Annotating with Jannovar: " + VCFUploadApp.this.annovarCheckbox.isSelected());
                        this.addLog("Phasing: " + VCFUploadApp.this.phasingCheckbox.isSelected());
                        this.addLog("Emailing notifications to: " + VCFUploadApp.this.emailPlaceholder.getText());
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (ProjectController.getInstance().promptForUnpublished()) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                AppDirectory.getTaskManager().showMessageForTask(instance, "<html>Variants have been uploaded and are now being processed.<br/>You may view progress in the Server Log in the Task Manager<br/><br/>You may log out or continue doing work.</html>");
                                                notification.close();
                                            }
                                        });
                                        variantManager.uploadVariants(LoginController.getSessionID(), transferIDs, ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), (String[][])new String[0][], false, VCFUploadApp.this.emailPlaceholder.getText(), true, VCFUploadApp.this.annovarCheckbox.isSelected(), VCFUploadApp.this.phasingCheckbox.isSelected());
                                        this.succeeded();
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    LOG.error((Object)"Error: ", (Throwable)ex);
                                    instance.addLog("Error: " + ex.getMessage());
                                    instance.setStatus(TaskWorker.TaskStatus.ERROR);
                                    AppDirectory.getTaskManager().showErrorForTask(instance, ex);
                                }
                            }

                            private void succeeded() {
                                LOG.info((Object)"Uplaod succeeded");
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        LOG.info((Object)"Upload succeeded");
                                        AppDirectory.getTaskManager().showMessageForTask(instance, "<html>Variants have completed being imported.<br/>As a result, you must login again.</html>");
                                        MedSavantFrame.getInstance().requestLogoutAndRestart();
                                    }
                                });
                            }
                        });
                        t.start();
                        this.addLog("Done");
                        this.setStatus(TaskWorker.TaskStatus.FINISHED);
                        return null;
                    }

                    protected void showSuccess(Object result) {
                    }

                    @Override
                    protected void showFailure(Exception e) {
                    }
                }.start();
            }
        });
        return container;
    }

    private void clearFiles() {
        this.filesToImport.removeAll(this.filesToImport);
        this.refreshFileList();
    }

    @Override
    public void didLogout() {
    }

    @Override
    public void didLogin() {
    }
}

