/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app.builtin;

import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommHandler;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommRegistry;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.BAMFileComm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.ThreadController;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.GenericStringChooser;
import org.ut.biolab.medsavant.client.view.component.SelectableListView;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.dashboard.LaunchableApp;
import org.ut.biolab.medsavant.client.view.genetics.GenomeContainer;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.notify.Notification;
import org.ut.biolab.medsavant.client.view.util.PeekingPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.client.view.variants.BrowserPage;
import org.ut.biolab.medsavant.client.view.variants.MedSavantDataSource;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.util.ServerRequest;
import savant.api.adapter.DataSourceAdapter;
import savant.api.data.DataFormat;
import savant.api.event.GenomeChangedEvent;
import savant.api.util.DialogUtils;
import savant.controller.FrameController;
import savant.controller.GenomeController;
import savant.controller.TrackController;
import savant.settings.PersistentSettings;
import savant.util.ColourKey;
import savant.view.swing.Savant;
import savant.view.tracks.Track;
import savant.view.tracks.TrackFactory;
import savant.view.variation.VariationController;

public class SavantApp
implements LaunchableApp,
AppCommHandler<BAMFileComm> {
    private String pageName = "Savant";
    private boolean initialized;
    private final Queue<DataSourceAdapter> queue = new LinkedList<DataSourceAdapter>();
    private boolean sequenceLoaded = false;
    private static final Log LOG = LogFactory.getLog(SavantApp.class);
    private JPanel view;
    private JPanel browserPanel;
    private GenomeContainer genomeContainer;
    private PeekingPanel genomeView;
    private PeekingPanel variationPanel;
    private Component[] settingComponents;
    private boolean variantTrackLoaded = false;
    private static SavantApp instance;
    private MedSavantDataSource msds;
    boolean isDoneMappingIdsToBAMURLs = false;
    private List<String> dnaIDs;
    private ArrayList<String> sampleIdsHavingBams;
    private HashMap<String, String> dnaIDToURLMap;

    private void initView() {
        if (!this.initialized) {
            instance = this;
            FilterController.getInstance().addListener(new Listener<FilterEvent>(){

                @Override
                public void handleEvent(FilterEvent event) {
                    SavantApp.this.updateContents();
                }
            });
            ReferenceController.getInstance().addListener(new Listener<ReferenceEvent>(){

                @Override
                public void handleEvent(ReferenceEvent event) {
                    if (event.getType() == ReferenceEvent.Type.CHANGED) {
                        SavantApp.this.updateContents();
                    }
                }
            });
            this.startMappingDNAIdsToBAMURLs();
            GenomeController.getInstance().addListener((savant.api.util.Listener)new savant.api.util.Listener<GenomeChangedEvent>(){

                public void handleEvent(GenomeChangedEvent event) {
                    if (!SavantApp.this.variantTrackLoaded) {
                        try {
                            LOG.debug((Object)"Loading gene track");
                            String referenceName = ReferenceController.getInstance().getCurrentReferenceName();
                            String urlOfTrack = SavantApp.getTrackURL(referenceName, "gene");
                            SavantApp.this.addTrackFromURLString(urlOfTrack, DataFormat.GENERIC_INTERVAL, false);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Error loading gene track", (Throwable)ex);
                        }
                        try {
                            LOG.debug((Object)"Loading MedSavant variant track");
                            SavantApp.this.msds = new MedSavantDataSource();
                            SavantApp.this.addTrackFromDataSource(SavantApp.this.msds);
                            SavantApp.this.variantTrackLoaded = true;
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Misc. error loading MedSavant variant track", (Throwable)ex);
                        }
                    }
                    LOG.info((Object)("GENOME CHANGED TO " + event.getNewGenome().getName()));
                    SavantApp.this.sequenceLoaded = true;
                    SavantApp.this.processTrackBacklog();
                }
            });
        }
        this.initialized = true;
    }

    @Override
    public void viewWillUnload() {
    }

    @Override
    public void viewWillLoad() {
        this.initView();
    }

    @Override
    public ImageIcon getIcon() {
        return IconFactory.getInstance().getIcon(IconFactory.StandardIcon.APP_SAVANT);
    }

    @Override
    public String getName() {
        return "Genome Browser";
    }

    public static SavantApp getInstance() {
        return instance;
    }

    public SavantApp() {
        AppCommRegistry.getInstance().registerHandler((AppCommHandler)this, BAMFileComm.class);
    }

    public Component[] getSubSectionMenuComponents() {
        if (this.settingComponents == null) {
            while (this.genomeView == null && this.variationPanel == null) {
                try {
                    LOG.debug((Object)"Waiting for panels...");
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BrowserPage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.settingComponents = new Component[2];
            this.settingComponents[0] = PeekingPanel.getToggleButtonForPanel(this.genomeView, "Genome");
            this.settingComponents[1] = PeekingPanel.getToggleButtonForPanel(this.variationPanel, "Variation");
        }
        return this.settingComponents;
    }

    private void setupToolbarButtons(Savant savantInstance) {
        JPanel pluginToolbar = savantInstance.getPluginToolbar();
        pluginToolbar.setLayout((LayoutManager)new MigLayout("insets 0"));
        try {
            String buttonStyle = "segmentedCapsule";
            JButton dnaButton = ViewUtil.getTexturedButton("Open Patient BAMs");
            dnaButton.setToolTipText("Open BAM File(s)");
            dnaButton.putClientProperty("JButton.buttonType", buttonStyle);
            dnaButton.putClientProperty("JButton.segmentPosition", "only");
            dnaButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (SavantApp.this.isDoneMappingIdsToBAMURLs) {
                        GenericStringChooser bamFileChooser = new GenericStringChooser(SavantApp.this.sampleIdsHavingBams, "Open BAM File(s)");
                        bamFileChooser.setLocationRelativeTo(SavantApp.this.view);
                        bamFileChooser.addListener(new Listener<SelectableListView.SelectionEvent>(){

                            @Override
                            public void handleEvent(SelectableListView.SelectionEvent event) {
                                List selections = event.getSelections();
                                for (Object o : selections) {
                                    String url = (String)SavantApp.this.dnaIDToURLMap.get(o.toString());
                                    SavantApp.this.addTrackFromURLString(url, DataFormat.ALIGNMENT, false);
                                }
                            }
                        });
                        bamFileChooser.setVisible(true);
                    } else {
                        DialogUtils.displayMessage((String)"Still collecting alignment file URLs, try again soon.");
                    }
                }
            });
            ViewUtil.makeMini(dnaButton);
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR ", (Throwable)e);
        }
    }

    @Override
    public JPanel getView() {
        try {
            if (this.view == null) {
                this.view = new JPanel();
                this.view.setLayout(new BorderLayout());
                this.view.add(new WaitPanel("Starting Genome Browser"));
                Chromosome[] chroms = MedSavantClient.ReferenceManager.getChromosomes(LoginController.getSessionID(), ReferenceController.getInstance().getCurrentReferenceID());
                this.genomeContainer = new GenomeContainer(this.pageName, chroms);
                this.genomeView = new PeekingPanel("Genome", "South", this.genomeContainer, false, 225);
                final JPanel variationPlaceHolder = new JPanel();
                variationPlaceHolder.setLayout(new BorderLayout());
                variationPlaceHolder.add((Component)new WaitPanel("Initializing variant views..."), "Center");
                this.variationPanel = new PeekingPanel("Variations", "West", variationPlaceHolder, false, 325);
                this.variationPanel.setToggleBarVisible(false);
                Runnable prepareBrowserThread = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            final JPanel tmpView = new JPanel();
                            tmpView.setLayout(new BorderLayout());
                            SavantApp.this.genomeView.setToggleBarVisible(false);
                            tmpView.add((Component)((Object)SavantApp.this.genomeView), "North");
                            SavantApp.this.browserPanel = new JPanel();
                            SavantApp.this.browserPanel.setLayout(new BorderLayout());
                            Savant savantInstance = Savant.getInstance((boolean)false, (boolean)false);
                            SavantApp.this.setupToolbarButtons(savantInstance);
                            PersistentSettings.getInstance().setColor(ColourKey.GRAPH_PANE_BACKGROUND_BOTTOM, Color.white);
                            PersistentSettings.getInstance().setColor(ColourKey.GRAPH_PANE_BACKGROUND_TOP, Color.white);
                            PersistentSettings.getInstance().setColor(ColourKey.AXIS_GRID, new Color(240, 240, 240));
                            savantInstance.setStartPageVisible(false);
                            savantInstance.setTrackBackground(new Color(210, 210, 210));
                            savantInstance.setBookmarksVisibile(false);
                            savantInstance.setVariantsVisibile(false);
                            variationPlaceHolder.removeAll();
                            variationPlaceHolder.add((Component)VariationController.getInstance().getModule(), "Center");
                            GenomeController.getInstance().setGenome(null);
                            String referenceName = ReferenceController.getInstance().getCurrentReferenceName();
                            final String urlOfTrack = SavantApp.getTrackURL(referenceName, "sequence");
                            SavantApp.this.browserPanel.add((Component)savantInstance.getBrowserPanel(), "Center");
                            tmpView.add((Component)SavantApp.this.browserPanel, "Center");
                            tmpView.add((Component)((Object)SavantApp.this.variationPanel), "East");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SavantApp.this.view.removeAll();
                                    SavantApp.this.view.add((Component)tmpView, "Center");
                                    SavantApp.this.view.updateUI();
                                }
                            });
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    SavantApp.this.addTrackFromURLString(urlOfTrack, DataFormat.SEQUENCE, false);
                                }
                            });
                            t.start();
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Got exception: " + ex));
                        }
                    }
                };
                new Thread(prepareBrowserThread).start();
            } else if (this.genomeContainer != null) {
                this.genomeContainer.updateIfRequired();
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error generating genome view: %s", ex);
        }
        return this.view;
    }

    public void addTrackFromURLString(String urlString, DataFormat format) {
        this.addTrackFromURLString(urlString, format, true);
    }

    private void processTrackBacklog() {
        while (!this.queue.isEmpty()) {
            this.addTrackFromDataSource(this.queue.poll());
        }
    }

    public void addTrackFromDataSource(DataSourceAdapter dsa) {
        try {
            if (!this.sequenceLoaded) {
                this.queue.add(dsa);
                return;
            }
            LOG.info((Object)("ADDING TRACK " + dsa.getName()));
            Track t = TrackFactory.createTrack((DataSourceAdapter)dsa);
            FrameController c = FrameController.getInstance();
            c.createFrame(new Track[]{t});
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    public void addTrackFromURLString(String urlString, final DataFormat format, boolean showNotification) {
        LOG.info((Object)("Adding track from " + urlString));
        final Notification n = new Notification();
        n.setName("Importing Track...");
        n.setDescription(urlString);
        n.setIcon(this.getIcon());
        n.setIsIndeterminateProgress(true);
        n.setHideDoesClose(true);
        ActionListener openApp = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MedSavantFrame.getInstance().getDashboard().launchApp(SavantApp.this);
            }
        };
        n.setAction("Open", openApp);
        if (showNotification && MedSavantFrame.getInstance().getDashboard().getCurrentApp() != this) {
            MedSavantFrame.getInstance().showNotification(n);
        }
        try {
            final URL url = new URL(urlString);
            if (!TrackController.getInstance().containsTrack(urlString)) {
                if (this.view == null) {
                    this.getView();
                }
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LOG.info((Object)"ACQUIRING URL LOCK");
                            FrameController.getInstance().addTrackFromURI(url.toURI(), format, null);
                            LOG.info((Object)"RELEASING URL LOCK");
                            n.setIsIndeterminateProgress(false);
                            n.setProgress(1.0);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex);
                        }
                    }
                });
                t.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    private static String getTrackURL(String referenceName, String trackName) throws Exception {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("reference", referenceName);
        requestMap.put("trackname", trackName);
        JSONObject o = ServerRequest.requestFromServer("browser/track", requestMap);
        String urlOfTrack = (String)o.get((Object)"url");
        return urlOfTrack;
    }

    @Override
    public void viewDidLoad() {
        this.genomeContainer.updateIfRequired();
        if (this.msds != null && this.variantTrackLoaded) {
            this.msds.refresh();
        }
    }

    @Override
    public void viewDidUnload() {
    }

    public void updateContents() {
        ThreadController.getInstance().cancelWorkers(this.pageName);
        if (this.genomeContainer == null) {
            return;
        }
        this.genomeContainer.setUpdateRequired(true);
        if (this.initialized) {
            this.genomeContainer.updateIfRequired();
        }
    }

    private void startMappingDNAIdsToBAMURLs() {
        this.dnaIDs = Arrays.asList(new String[0]);
        this.sampleIdsHavingBams = new ArrayList();
        this.dnaIDToURLMap = new HashMap();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SavantApp.this.dnaIDs = MedSavantClient.DBUtils.getDistinctValuesForColumn(LoginController.getSessionID(), ProjectController.getInstance().getCurrentVariantTableName(), BasicVariantColumns.DNA_ID.getColumnName(), false);
                    for (String s : SavantApp.this.dnaIDs) {
                        String url = MedSavantClient.PatientManager.getReadAlignmentPathForDNAID(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), s);
                        if (url == null || url.isEmpty()) continue;
                        SavantApp.this.sampleIdsHavingBams.add(s);
                        String[] splitUrls = url.split(",");
                        SavantApp.this.dnaIDToURLMap.put(s, splitUrls[0]);
                    }
                    SavantApp.this.isDoneMappingIdsToBAMURLs = true;
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            }
        });
    }

    @Override
    public void didLogout() {
    }

    @Override
    public void didLogin() {
    }

    public void handleCommEvent(BAMFileComm value) {
        System.out.println("Launching genome browser and openning BAM file " + value.getEventData());
        try {
            this.addTrackFromURLString(((URL)value.getEventData()).toString(), DataFormat.ALIGNMENT, false);
            MedSavantFrame.getInstance().getDashboard().launchApp(this);
        }
        catch (NullPointerException e) {
            DialogUtils.displayError((String)"Error loading BAM file at URL: null");
        }
        catch (Exception e) {
            DialogUtils.displayError((String)("Error loading BAM file at URL: " + ((URL)value.getEventData()).getPath()));
        }
    }

    public String getHandlerName() {
        return "Savant Genome Browser";
    }

    public ImageIcon getHandlerIcon() {
        return this.getIcon();
    }
}

