/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class CollapsiblePanel
extends JPanel {
    private final JPanel titlePanel;
    private final JPanel titleButtonsPanel;
    private final JPanel contentPanel;
    private final boolean isCollapsable;
    private final JLabel expandButton;
    private final JLabel collapseButton;
    private final MouseListener toggler = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent me) {
            CollapsiblePanel.this.setContentPaneVisible(!CollapsiblePanel.this.contentPanel.isVisible());
        }

        @Override
        public void mousePressed(MouseEvent me) {
        }

        @Override
        public void mouseReleased(MouseEvent me) {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }
    };
    private final JLabel descriptionLabel;
    private final JLabel titleLabel;

    public CollapsiblePanel(String title) {
        this(title, true);
    }

    public CollapsiblePanel(String title, boolean isCollapsable) {
        ViewUtil.applyVerticalBoxLayout(this);
        ViewUtil.clear(this);
        this.titlePanel = ViewUtil.getSecondaryBannerPanel();
        ViewUtil.applyHorizontalBoxLayout(this.titlePanel);
        this.titlePanel.setBorder(BorderFactory.createCompoundBorder(ViewUtil.getTinyLineBorder(), ViewUtil.getMediumBorder()));
        this.isCollapsable = isCollapsable;
        if (isCollapsable) {
            this.expandButton = ViewUtil.createIconButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.EXPAND));
            this.collapseButton = ViewUtil.createIconButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.COLLAPSE));
            this.titlePanel.add(this.expandButton);
            this.titlePanel.add(this.collapseButton);
            this.expandButton.addMouseListener(this.toggler);
            this.collapseButton.addMouseListener(this.toggler);
        } else {
            this.expandButton = null;
            this.collapseButton = null;
        }
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(ViewUtil.getMediumTitleFont());
        this.titlePanel.add(this.titleLabel);
        this.descriptionLabel = new JLabel("");
        this.descriptionLabel.setFont(ViewUtil.getMediumTitleFont());
        this.titleButtonsPanel = (JPanel)ViewUtil.clear(new JPanel());
        ViewUtil.applyHorizontalBoxLayout(this.titleButtonsPanel);
        this.titlePanel.add(this.titleLabel);
        this.titlePanel.add(ViewUtil.getMediumSeparator());
        this.titlePanel.add(this.descriptionLabel);
        this.titlePanel.add(Box.createHorizontalGlue());
        this.titlePanel.add(this.titleButtonsPanel);
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(ViewUtil.getMediumBorder());
        ViewUtil.applyVerticalBoxLayout(this.contentPanel);
        this.contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.lightGray), ViewUtil.getMediumBorder()));
        this.contentPanel.setBackground(Color.white);
        this.setContentPaneVisible(true);
        this.add(this.titlePanel);
        this.add(this.contentPanel);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public JPanel getContentPane() {
        return this.contentPanel;
    }

    public void addTitleComponent(Component c) {
        this.titleButtonsPanel.add(c);
    }

    public final void setContentPaneVisible(boolean b) {
        if (this.isCollapsable) {
            this.contentPanel.setVisible(b);
            this.expandButton.setVisible(!b);
            this.collapseButton.setVisible(b);
        }
    }

    public final void setDescription(String s) {
        if (s.isEmpty()) {
            this.descriptionLabel.setText("");
        } else {
            this.descriptionLabel.setText("(" + s + ")");
        }
    }
}

