/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.icons.JideIconsFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import savant.view.icon.SavantIconFactory;

public class DocumentViewer
extends JFrame {
    DocumentPane pane;
    List<DocumentComponent> list;
    private int maxLineCount;
    JTextField textNumLines;
    static DocumentViewer instance;
    double factor = 0.5;
    private Map<String, Document> fileNameToDocumentMap = new HashMap<String, Document>();

    public static DocumentViewer getInstance() {
        if (instance == null) {
            instance = new DocumentViewer();
        }
        return instance;
    }

    public DocumentViewer() {
        this("Document Viewer", 500);
    }

    public DocumentViewer(int maxLineCount) {
        this("Document Viewer", maxLineCount);
    }

    public DocumentViewer(String title, int maxLineCount) {
        this.setTitle(title);
        this.maxLineCount = maxLineCount;
        this.init();
    }

    public void init() {
        this.setMinimumSize(new Dimension(700, 500));
        this.setPreferredSize(new Dimension(700, 500));
        this.setMaximumSize(new Dimension(700, 500));
        this.pane = new DocumentPane();
        this.list = new ArrayList<DocumentComponent>();
        this.setLayout(new BorderLayout());
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.add(new JLabel("Show at most this many lines: "));
        this.textNumLines = new JTextField(this.maxLineCount + "");
        this.textNumLines.setMaximumSize(new Dimension(100, 20));
        this.textNumLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int newNum = Integer.parseInt(DocumentViewer.this.textNumLines.getText().trim());
                    DocumentViewer.this.setMaximumNumberOfLines(newNum);
                }
                catch (Exception ex) {
                    DocumentViewer.this.textNumLines.requestFocus();
                }
            }
        });
        this.textNumLines.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    int newNum = Integer.parseInt(DocumentViewer.this.textNumLines.getText().trim());
                    DocumentViewer.this.setMaximumNumberOfLines(newNum);
                }
                catch (Exception ex) {
                    DocumentViewer.this.textNumLines.requestFocus();
                }
            }
        });
        bar.add(this.textNumLines);
        JButton upButt = new JButton();
        upButt.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.UP));
        upButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentViewer.this.decreaseMaximumNumberOfLines();
            }
        });
        bar.add(upButt);
        JButton downButt = new JButton();
        downButt.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.DOWN));
        downButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentViewer.this.increaseMaximumNumberOfLines();
            }
        });
        bar.add(downButt);
        this.add((Component)bar, "North");
        this.add((Component)this.pane, "Center");
    }

    public void increaseMaximumNumberOfLines() {
        this.setMaximumNumberOfLines((int)(1.0 + (double)this.maxLineCount * (1.0 + this.factor)));
    }

    public void decreaseMaximumNumberOfLines() {
        this.setMaximumNumberOfLines((int)(1.0 + (double)this.maxLineCount * (1.0 - this.factor)));
    }

    public void setMaximumNumberOfLines(int newnum) {
        this.textNumLines.setText(newnum + "");
        this.maxLineCount = newnum;
        for (String key : this.fileNameToDocumentMap.keySet()) {
            DocumentViewer.fillDocument(this.fileNameToDocumentMap.get(key), key, this.maxLineCount);
        }
    }

    public void addDocument(String path) {
        if (!new File(path).exists()) {
            JOptionPane.showMessageDialog(this, "Error opening file: \"" + path + "\"");
            return;
        }
        JTextArea editor = this.createTextArea(path);
        ((JComponent)editor).setFont(new Font("Monospaced", 0, 14));
        DocumentComponent txtDocument = new DocumentComponent((JComponent)new JScrollPane(editor), path, path, (Icon)JideIconsFactory.getImageIcon((String)"jide/file_text.png"));
        txtDocument.setDefaultFocusComponent((Component)editor);
        this.list.add(0, txtDocument);
        this.pane.setOpenedDocuments(this.list);
        this.pane.getLayoutPersistence().setProfileKey("documents");
        this.pane.getLayoutPersistence().loadLayoutData();
        this.pack();
        this.setVisible(true);
    }

    public JTextArea createTextArea(String fileName) {
        JTextArea area = new JTextArea();
        PlainDocument doc = new PlainDocument();
        DocumentViewer.fillDocument(doc, fileName, this.maxLineCount);
        area.setEditable(false);
        area.setDocument(doc);
        this.fileNameToDocumentMap.put(fileName, doc);
        return area;
    }

    public static void fillDocument(Document doc, String filename, int numLines) {
        try {
            doc.remove(0, doc.getLength());
            BufferedReader br = new BufferedReader(new FileReader(filename));
            String line = "";
            for (int i = 0; (numLines == -1 || i < numLines) && (line = br.readLine()) != null; ++i) {
                doc.insertString(doc.getLength(), line + "\n", null);
            }
            if (br.ready()) {
                doc.insertString(doc.getLength(), "[ Stopped at " + numLines + " lines ]", null);
            }
            br.close();
        }
        catch (Exception ex) {
            try {
                doc.insertString(0, "Error reading file", null);
            }
            catch (BadLocationException ex1) {
                // empty catch block
            }
        }
    }
}

