/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.view.component.StackableJPanel;
import org.ut.biolab.medsavant.client.view.component.StackableJPanelFactory;

public class StackableJPanelContainer
extends JPanel {
    private final Stack<JPanel> panels;
    private final JLayeredPane layeredPane;
    public static int counter;

    public StackableJPanelContainer() {
        this.setOpaque(false);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.layeredPane, "Center");
        this.layeredPane.setPreferredSize(new Dimension(300, 300));
        this.panels = new Stack();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                StackableJPanelContainer.this.resetBounds();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                StackableJPanelContainer.this.resetBounds();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void resetBounds() {
        for (JPanel p : this.panels) {
            this.setBounds(p);
        }
    }

    @Override
    public Component add(Component c) {
        throw new UnsupportedOperationException("Cannot add to StackableJPanelContainer, use push instead");
    }

    public void push(JPanel p) {
        this.push(StackableJPanelFactory.convertComponentToStackablePanel(p));
    }

    public void push(StackableJPanel p) {
        p.setParentContainer(this);
        this.layeredPane.add((Component)p, new Integer(counter++));
        this.panels.push(p);
        this.setBounds(p);
        this.updateUI();
    }

    public void pop() {
        this.remove(this.panels.peek());
    }

    public void remove(StackableJPanel p) {
        this.layeredPane.remove(p);
        this.panels.remove(p);
        this.updateUI();
    }

    public static void main(String[] argv) {
        StackableJPanelContainer pstack = new StackableJPanelContainer();
        StackableJPanel p = new StackableJPanel();
        p.setBackground(Color.red);
        p.add(new JButton("I'm on the first layer"));
        pstack.push(p);
        p = new StackableJPanel();
        p.setOpaque(false);
        p.setLayout((LayoutManager)new MigLayout("fillx, filly, center"));
        p.add(new JButton("I'm on the second layer"));
        pstack.push(p);
        JFrame f = new JFrame();
        f.setContentPane(pstack);
        f.pack();
        f.show();
        System.out.println("Frame shown");
    }

    private void setBounds(JPanel p) {
        p.setBounds(0, 0, this.getWidth(), this.getHeight());
        p.updateUI();
    }
}

