/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dialog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.ut.biolab.medsavant.shared.util.VersionSettings;
import org.ut.biolab.medsavant.shared.util.WebResources;

public class BugReport {
    public static boolean reportBug(String tool, String version, String name, String email, String institute, String problem, Throwable t) throws UnsupportedEncodingException {
        try {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new NameValuePair("tool", tool));
            params.add(new NameValuePair("name", name));
            params.add(new NameValuePair("email", email));
            params.add(new NameValuePair("institution", institute));
            params.add(new NameValuePair("problem", problem));
            params.add(new NameValuePair("exception", BugReport.getStackTrace(t)));
            params.add(new NameValuePair("clientinfo", BugReport.kvp("program-version", version) + ", " + BugReport.kvp("java-version", BugReport.getJDKVersion()) + ", " + BugReport.kvp("os", BugReport.getOS()) + ", " + BugReport.kvp("time", new Date().toLocaleString())));
            BugReport.postRequest(WebResources.BUGREPORT_URL, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        t.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    private static String kvp(String k, String v) {
        return k + "=" + v;
    }

    private static String getJDKVersion() {
        return BugReport.getProperty("java.version");
    }

    private static String getOS() {
        return BugReport.getProperty("os.name") + " " + BugReport.getProperty("os.arch") + " " + BugReport.getProperty("os.version");
    }

    private static String getProperty(String propertyName) {
        try {
            String value = System.getProperty(propertyName);
            if (value == null) {
                return "unknown";
            }
            return value;
        }
        catch (SecurityException e) {
            return "unknown";
        }
    }

    private static void postRequest(URL url, List<NameValuePair> params) throws IOException {
        String inputLine;
        HttpClient hc = new HttpClient();
        NameValuePair[] data = new NameValuePair[params.size()];
        PostMethod post = new PostMethod(url.toString());
        post.setRequestBody(params.toArray(data));
        hc.executeMethod((HttpMethod)post);
        BufferedReader in = new BufferedReader(new InputStreamReader(post.getResponseBodyAsStream()));
        while ((inputLine = in.readLine()) != null) {
            System.out.println(inputLine);
        }
        in.close();
        post.releaseConnection();
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        BugReport.reportBug("MedSavant", VersionSettings.getVersionString(), "Marc Fiume", "mfiume@cs.toronto.edu", "UofT", "Testing bug reporting", new Exception("msg"));
        System.out.println("Bug reported");
    }

    static boolean reportFeedback(String tool, String version, String name, String email, String feedbackStr) {
        try {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new NameValuePair("tool", tool));
            params.add(new NameValuePair("name", name));
            params.add(new NameValuePair("email", email));
            params.add(new NameValuePair("feedback", feedbackStr));
            params.add(new NameValuePair("clientinfo", BugReport.kvp("program-version", version) + ", " + BugReport.kvp("java-version", BugReport.getJDKVersion()) + ", " + BugReport.kvp("os", BugReport.getOS()) + ", " + BugReport.kvp("time", new Date().toLocaleString())));
            BugReport.postRequest(WebResources.FEEDBACK_FORM_URL, params);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

