/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dialog;

import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import org.ut.biolab.medsavant.client.util.FormController;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.util.FixedLengthTextFilter;
import org.ut.biolab.medsavant.client.view.util.SpringUtilities;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.format.CustomField;

public class FormEditorDialog
extends JDialog {
    private static final int XPADDING = 5;
    private static final int YPADDING = 5;
    private static final int MAX_TEXTFIELD_CHARS = 100;
    private static final int MAX_TEXTFIELD_DISPLAYCHARS = 20;
    private static final int MAX_TEXTAREA_ROWS = 3;
    private static final int MAX_NUM_RADIOBUTTONS = 3;
    private static final String RADIOBUTTON_MISSING_LABEL = "N/A";
    private int numCols;
    private FormController controller;
    private CustomField[] fields;
    private String[] fieldValues;

    public FormEditorDialog(FormController controller) {
        this(controller, 1);
    }

    public FormEditorDialog(FormController controller, int numCols) {
        super(MedSavantFrame.getInstance());
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.fields = controller.getFields();
        this.fieldValues = new String[this.fields.length];
        this.controller = controller;
        this.numCols = numCols;
        this.initForm();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(MedSavantFrame.getInstance());
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    protected String getTip(CustomField f) {
        String s = f.getAlias() + " | " + f.getColumnType().toString().toLowerCase();
        switch (f.getColumnType()) {
            case DATE: {
                s = s + "(yyyy-mm-dd)";
                break;
            }
            case BOOLEAN: {
                s = s + "(true/false)";
            }
        }
        return s;
    }

    private void initForm() {
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new SpringLayout());
        int xpos = 5;
        int ypos = 5;
        int numFieldsVisible = this.fields.length;
        final ArrayList<ActionListener> listeners = new ArrayList<ActionListener>(this.fields.length);
        for (int fi = 0; fi < this.fields.length; ++fi) {
            final int fieldIndex = fi;
            CustomField field = this.fields[fieldIndex];
            if (this.controller.isAutoInc(field)) {
                --numFieldsVisible;
                continue;
            }
            JLabel jl = new JLabel(field.getAlias());
            jl.setToolTipText(this.getTip(field));
            outerPanel.add(jl);
            JPanel innerPanel = new JPanel(new FlowLayout(0));
            if (this.controller.allowedValues(field) != null) {
                final ButtonGroup bg = new ButtonGroup();
                JPanel rbPanel = new JPanel(new FlowLayout(0));
                String[][] allowedValues = this.controller.allowedValues(field);
                if (allowedValues.length <= 3) {
                    for (String[] allowedValue : allowedValues) {
                        JRadioButton jr;
                        if (allowedValue == null) {
                            jr = new JRadioButton(RADIOBUTTON_MISSING_LABEL, false);
                            jr.setActionCommand(RADIOBUTTON_MISSING_LABEL);
                        } else {
                            jr = new JRadioButton(allowedValue[1], false);
                            jr.setActionCommand(allowedValue[0]);
                        }
                        if (bg.getButtonCount() == 0) {
                            jr.setSelected(true);
                        }
                        bg.add(jr);
                        rbPanel.add(jr);
                    }
                    innerPanel.add(rbPanel);
                    listeners.add(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Enumeration<AbstractButton> rbs = bg.getElements();
                            while (rbs.hasMoreElements()) {
                                JRadioButton rb = (JRadioButton)rbs.nextElement();
                                if (!rb.isSelected()) continue;
                                ((FormEditorDialog)FormEditorDialog.this).fieldValues[fieldIndex] = rb.getActionCommand();
                            }
                        }
                    });
                } else {
                    final JComboBox jc = new JComboBox((E[])allowedValues);
                    innerPanel.add(jc);
                    listeners.add(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ((FormEditorDialog)FormEditorDialog.this).fieldValues[fieldIndex] = (String)jc.getSelectedItem();
                        }
                    });
                }
            } else if (field.getColumnType() == ColumnType.VARCHAR || field.getColumnType() == ColumnType.TEXT || field.getColumnType() == ColumnType.INTEGER || field.getColumnType() == ColumnType.DECIMAL || field.getColumnType() == ColumnType.FLOAT || field.getColumnType() == ColumnType.DATE || field.getColumnType() == ColumnType.BLOB) {
                JTextComponent jc;
                int colLength = field.getColumnLength();
                if (colLength > 100) {
                    int numRows = (int)Math.ceil(colLength / 20);
                    numRows = Math.min(numRows, 3);
                    JTextArea ja = new JTextArea(numRows, 20);
                    ((AbstractDocument)ja.getDocument()).setDocumentFilter(new FixedLengthTextFilter(colLength));
                    ja.setFocusTraversalKeys(0, null);
                    ja.setFocusTraversalKeys(1, null);
                    JScrollPane jsp = new JScrollPane(ja);
                    jsp.setBorder(new EtchedBorder(1));
                    innerPanel.add(jsp);
                    jc = ja;
                } else {
                    int textfieldWidth = Math.min(colLength, 20);
                    JTextField jf = new JTextField(textfieldWidth);
                    ((AbstractDocument)jf.getDocument()).setDocumentFilter(new FixedLengthTextFilter(colLength));
                    jf.setBorder(new EtchedBorder(1));
                    innerPanel.add(jf);
                    jc = jf;
                }
                listeners.add(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((FormEditorDialog)FormEditorDialog.this).fieldValues[fieldIndex] = jc.getText();
                    }
                });
            }
            outerPanel.add(innerPanel);
        }
        SpringUtilities.makeCompactGrid(outerPanel, (int)Math.ceil((double)numFieldsVisible / (double)this.numCols), this.numCols * 2, xpos, ypos, 5, 5);
        outerPanel.setOpaque(true);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton OKButton = new JButton("OK");
        final FormEditorDialog that = this;
        OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ActionListener al : listeners) {
                    al.actionPerformed(new ActionEvent(this, 1001, "FormSubmit"));
                }
                String errors = "";
                LinkedList<String> visibleFieldValues = new LinkedList<String>();
                LinkedList<CustomField> visibleFields = new LinkedList<CustomField>();
                String[] err = new String[1];
                for (int i = 0; i < FormEditorDialog.this.fields.length; ++i) {
                    if (FormEditorDialog.this.controller.isAutoInc(FormEditorDialog.this.fields[i])) continue;
                    visibleFieldValues.add(FormEditorDialog.this.fieldValues[i]);
                    visibleFields.add(FormEditorDialog.this.fields[i]);
                    if (FormEditorDialog.this.controller.isValid(FormEditorDialog.this.fields[i], FormEditorDialog.this.fieldValues[i], err)) continue;
                    errors = errors + err[0] + "\n";
                }
                if (!errors.isEmpty()) {
                    JOptionPane.showMessageDialog(that, errors, "Invalid Input", 0);
                } else {
                    FormEditorDialog.this.controller.submitForm(visibleFields, visibleFieldValues);
                    FormEditorDialog.this.close();
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormEditorDialog.this.close();
            }
        });
        buttonPanel.add(OKButton);
        buttonPanel.add(cancelButton);
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new BoxLayout(borderPanel, 1));
        borderPanel.add(outerPanel);
        borderPanel.add(buttonPanel);
        this.setContentPane(borderPanel);
        this.pack();
    }
}

