/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FontFactory {
    private static Log LOG = LogFactory.getLog(FontFactory.class);
    private static final Font titleFontPrimary = FontFactory.initFont(new String[]{"HelveticaNeue-Medium", "Arial", "Lucida Sans Regular", "Times New Roman"}, 20.0f);
    private static final Font titleFont = titleFontPrimary != null ? titleFontPrimary : FontFactory.loadFont("/font/OpenSans-Regular.ttf").deriveFont(20.0f);
    private static final Font sectionHeaderFont = titleFont.deriveFont(24.0f);
    private static final Map<TextAttribute, Object> fontAttributeMap = new Hashtable<TextAttribute, Object>();
    private static final Font serifFontPrimary = FontFactory.loadFont("/font/Oswald-Light.otf").deriveFont(13.0f);
    private static final Font serifFont = serifFontPrimary != null ? serifFontPrimary : FontFactory.initFont(new String[]{"Times New Roman"}, 13.0f);
    private static final Font generalFontPrimary;
    private static final Font generalFontSecondary;
    private static final Font generalFont;

    private static Font initFont(String[] fontsToTry, Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        Font f = FontFactory.initFont(fontsToTry);
        return f.deriveFont(attributes);
    }

    private static Font initFont(String[] fontsToTry, float size) {
        Font f = FontFactory.initFont(fontsToTry);
        return f.deriveFont(size);
    }

    private static Font initFont(String[] fontsToTry) {
        Font f = null;
        for (int i = 0; f == null && i < fontsToTry.length; ++i) {
            f = FontFactory.getFont(fontsToTry[i]);
        }
        if (f == null) {
            f = UIManager.getDefaults().getFont("TitledBorder.font");
        }
        return f;
    }

    public static Font getMenuTitleFont() {
        return titleFont;
    }

    public static Font getSectionHeaderFont() {
        return sectionHeaderFont;
    }

    public static Font getGeneralFont() {
        return generalFont;
    }

    public static Font getSerifFont() {
        return serifFont;
    }

    private static Font loadFont(String resourcePath) {
        try {
            InputStream is = FontFactory.class.getResourceAsStream(resourcePath);
            Font font = Font.createFont(0, is).deriveFont(12.0f);
            System.out.println("Loaded font " + font.getFamily());
            return font;
        }
        catch (FontFormatException ex) {
            LOG.info((Object)"Error loading font");
            return null;
        }
        catch (IOException ex) {
            LOG.info((Object)"Error loading font");
            return null;
        }
    }

    private static Font getFont(String fontName) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font i : e.getAllFonts()) {
            String name = i.getFontName();
            if (!name.equals(fontName)) continue;
            return i.deriveFont(13.0f);
        }
        return null;
    }

    static {
        fontAttributeMap.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        generalFontPrimary = FontFactory.initFont(new String[]{"HelveticaNeue-Light", "Arial", "Lucida Sans Regular", "Times New Roman"}, fontAttributeMap);
        generalFontSecondary = FontFactory.loadFont("/font/OpenSans-Regular.ttf").deriveFont(13.0f);
        generalFont = generalFontPrimary != null ? generalFontPrimary : (generalFontSecondary != null ? generalFontSecondary : new JLabel().getFont());
    }
}

