/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.view.genetics.ChromosomeDiagramPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.model.Range;

public class ChromosomePanel
extends JPanel {
    private final Chromosome chr;
    private final ChromosomeDiagramPanel cdp;

    public ChromosomePanel(Chromosome c) {
        this.setOpaque(false);
        this.chr = c;
        this.setLayout(new BoxLayout(this, 1));
        JLabel shortLabel = new JLabel(this.chr.getShortname());
        ViewUtil.makeSmall(shortLabel);
        shortLabel.setForeground(Color.gray);
        this.add(shortLabel);
        this.add(ViewUtil.getSmallVerticalSeparator());
        this.cdp = new ChromosomeDiagramPanel(c);
        this.add(this.cdp);
        this.setPreferredSize(new Dimension(20, 999));
        this.setMaximumSize(new Dimension(20, 999));
    }

    void setScaleWithRespectToLength(long len) {
        this.cdp.setScaleWithRespectToLength(len);
    }

    public void updateFrequencyCounts(Map<Range, Integer> binCounts, int max) {
        this.cdp.updateFrequencyCounts(binCounts, max);
    }

    public String getChrName() {
        return this.chr.getName();
    }

    public String getShortChrName() {
        return this.chr.getShortname();
    }
}

