/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.ThreadController;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.genetics.charts.ChartView;

public class GeneticsChartPage
extends AppSubSection {
    private JPanel view;
    private ChartView chartView;
    private boolean isLoaded = false;

    public GeneticsChartPage(MultiSectionApp parent) {
        super(parent, "Charts");
        FilterController.getInstance().addListener(new Listener<FilterEvent>(){

            @Override
            public void handleEvent(FilterEvent event) {
                ThreadController.getInstance().cancelWorkers(GeneticsChartPage.this.pageName);
                GeneticsChartPage.this.tryUpdate();
            }
        });
        ReferenceController.getInstance().addListener(new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                if (event.getType() == ReferenceEvent.Type.CHANGED) {
                    GeneticsChartPage.this.tryUpdate();
                }
            }
        });
    }

    @Override
    public JPanel getView() {
        if (this.view == null) {
            try {
                this.view = new JPanel();
                this.view.setLayout(new BorderLayout());
                this.chartView = new ChartView(this.pageName);
                this.view.add((Component)this.chartView, "Center");
            }
            catch (Exception ex) {
                ClientMiscUtils.reportError("Error creating chart view: %s", ex);
            }
        }
        this.chartView.updateIfRequired();
        return this.view;
    }

    @Override
    public Component[] getSubSectionMenuComponents() {
        return null;
    }

    @Override
    public void viewWillLoad() {
        this.isLoaded = true;
    }

    @Override
    public void viewDidUnload() {
        this.isLoaded = false;
        super.viewDidUnload();
    }

    private void tryUpdate() {
        if (this.chartView != null) {
            this.chartView.setUpdateRequired(true);
            if (this.isLoaded) {
                this.chartView.updateIfRequired();
            }
        }
    }
}

