/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ut.biolab.medsavant.client.filter.SearchBar;
import org.ut.biolab.medsavant.client.query.QueryViewController;
import org.ut.biolab.medsavant.client.query.SearchConditionGroupItem;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.value.encode.NumericConditionEncoder;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.model.RegionSet;
import org.ut.biolab.medsavant.shared.model.SimpleVariantFile;

public class QueryUtils {
    public static SearchConditionGroupItem getRegionGroup(GenomicRegion gr, String alt, boolean setupViews) {
        QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
        SearchConditionGroupItem geneGroup = new SearchConditionGroupItem(SearchConditionGroupItem.QueryRelation.OR, null, null);
        String name = gr.getName();
        if (name == null) {
            geneGroup.setDescription("Region " + gr.getStart());
        } else {
            geneGroup.setDescription("Region " + name);
        }
        SearchConditionItem chromItem = new SearchConditionItem(BasicVariantColumns.CHROM.getAlias(), SearchConditionGroupItem.QueryRelation.AND, geneGroup);
        chromItem.setDescription(gr.getChrom());
        chromItem.setSearchConditionEncoding(StringConditionEncoder.encodeConditions(Arrays.asList(gr.getChrom())));
        SearchConditionItem startPosItem = new SearchConditionItem(BasicVariantColumns.START_POSITION.getAlias(), SearchConditionGroupItem.QueryRelation.AND, geneGroup);
        startPosItem.setDescription(Long.toString(gr.getStart()) + " - " + Long.toString(gr.getEnd()));
        startPosItem.setSearchConditionEncoding(NumericConditionEncoder.encodeConditions(gr.getStart(), gr.getEnd(), false));
        SearchConditionItem endPosItem = new SearchConditionItem(BasicVariantColumns.END_POSITION.getAlias(), SearchConditionGroupItem.QueryRelation.AND, geneGroup);
        endPosItem.setDescription(Long.toString(gr.getStart()) + " - " + Long.toString(gr.getEnd()));
        endPosItem.setSearchConditionEncoding(NumericConditionEncoder.encodeConditions(gr.getStart(), gr.getEnd(), false));
        if (setupViews) {
            qvc.generateItemViewAndAddToGroup(chromItem, geneGroup);
            qvc.generateItemViewAndAddToGroup(startPosItem, geneGroup);
            qvc.generateItemViewAndAddToGroup(endPosItem, geneGroup);
        } else {
            geneGroup.addItem(chromItem);
            geneGroup.addItem(startPosItem);
            geneGroup.addItem(endPosItem);
        }
        if (alt != null) {
            SearchConditionItem altItem = new SearchConditionItem(BasicVariantColumns.ALT.getAlias(), SearchConditionGroupItem.QueryRelation.AND, geneGroup);
            altItem.setDescription(alt);
            altItem.setSearchConditionEncoding(StringConditionEncoder.encodeConditions(Arrays.asList(alt)));
            if (setupViews) {
                qvc.generateItemViewAndAddToGroup(altItem, geneGroup);
            } else {
                geneGroup.addItem(altItem);
            }
        }
        return geneGroup;
    }

    public static void addQueryOnRegionWithAlt(GenomicRegion region, String alt) {
        QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
        ArrayList<SearchConditionItem> sciList = new ArrayList<SearchConditionItem>(1);
        sciList.add(QueryUtils.getRegionGroup(region, alt, true));
        SearchConditionGroupItem scg = qvc.replaceFirstLevelGroup("Genomic Region(s)", sciList, SearchConditionGroupItem.QueryRelation.AND, false);
        qvc.refreshView();
    }

    public static void addQueryOnRegions(List<GenomicRegion> regions, List<RegionSet> regionSets) {
        QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
        ArrayList<SearchConditionItem> sciList = new ArrayList<SearchConditionItem>(regions.size());
        for (GenomicRegion gr : regions) {
            SearchConditionGroupItem geneGroup = QueryUtils.getRegionGroup(gr, null, true);
            sciList.add(geneGroup);
        }
        SearchConditionGroupItem scg = qvc.replaceFirstLevelGroup("Genomic Region(s)", sciList, SearchConditionGroupItem.QueryRelation.AND, false);
        if (regionSets != null) {
            ArrayList<String> regionSetNames = new ArrayList<String>(regionSets.size());
            for (RegionSet rs : regionSets) {
                regionSetNames.add(rs.getName());
            }
            SearchConditionItem regionItem = new SearchConditionItem("Region Set", SearchConditionGroupItem.QueryRelation.AND, scg);
            regionItem.setDescription(StringConditionEncoder.getDescription(regionSetNames));
            regionItem.setSearchConditionEncoding(StringConditionEncoder.encodeConditions(regionSetNames));
            qvc.generateItemViewAndAddToGroup(regionItem, scg);
        }
        qvc.refreshView();
    }

    public static void addMultiStringQuery(String alias, List<String> selections) {
        QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
        String desc = StringConditionEncoder.getDescription(selections);
        qvc.replaceFirstLevelItem(alias, StringConditionEncoder.encodeConditions(selections), desc);
        qvc.refreshView();
    }

    public static void addNumericQuery(String alias, double low, double high, boolean includeNull) {
        QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
        String encodedConditions = NumericConditionEncoder.encodeConditions(low, high, includeNull);
        String desc = NumericConditionEncoder.getDescription(new double[]{low, high});
        qvc.replaceFirstLevelItem(alias, encodedConditions, desc);
        qvc.refreshView();
    }

    public static void addQueryOnPatients(int[] patientIds) {
        ArrayList<String> patientIdStrings = new ArrayList<String>(patientIds.length);
        for (int patientId : patientIds) {
            patientIdStrings.add(Integer.toString(patientId));
        }
        QueryUtils.addMultiStringQuery(BasicPatientColumns.PATIENT_ID.getAlias(), patientIdStrings);
    }

    public static void addQueryOnVariantFiles(SimpleVariantFile[] files) {
        QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
        ArrayList<SearchConditionItem> sciList = new ArrayList<SearchConditionItem>(files.length);
        for (SimpleVariantFile file : files) {
            int uploadId = file.getUploadId();
            int fileId = file.getFileId();
            SearchConditionGroupItem fileGroup = new SearchConditionGroupItem(SearchConditionGroupItem.QueryRelation.OR, null, null);
            String filename = new File(file.getPath()).getName();
            fileGroup.setDescription(filename);
            SearchConditionItem uploadItem = new SearchConditionItem(BasicVariantColumns.UPLOAD_ID.getAlias(), SearchConditionGroupItem.QueryRelation.AND, fileGroup);
            uploadItem.setDescription("Upload ID " + uploadId);
            uploadItem.setSearchConditionEncoding(StringConditionEncoder.encodeConditions(Arrays.asList(Integer.toString(uploadId))));
            SearchConditionItem fileItem = new SearchConditionItem(BasicVariantColumns.FILE_ID.getAlias(), SearchConditionGroupItem.QueryRelation.AND, fileGroup);
            fileItem.setDescription("File ID " + fileId);
            fileItem.setSearchConditionEncoding(StringConditionEncoder.encodeConditions(Arrays.asList(Integer.toString(fileId))));
            qvc.generateItemViewAndAddToGroup(uploadItem, fileGroup);
            qvc.generateItemViewAndAddToGroup(fileItem, fileGroup);
            sciList.add(fileGroup);
        }
        qvc.replaceFirstLevelGroup("Variant Files", sciList, SearchConditionGroupItem.QueryRelation.AND, false);
    }

    public static void addQueryOnHospitals(String[] hospitalIds, String cohort) {
        QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
        SearchConditionGroupItem p = qvc.getQueryRootGroup();
        ArrayList<SearchConditionItem> sciList = new ArrayList<SearchConditionItem>(2);
        SearchConditionItem hosItem = new SearchConditionItem(BasicPatientColumns.HOSPITAL_ID.getAlias(), SearchConditionGroupItem.QueryRelation.AND, p);
        hosItem.setDescription(StringConditionEncoder.getDescription(Arrays.asList(hospitalIds)));
        hosItem.setSearchConditionEncoding(StringConditionEncoder.encodeConditions(Arrays.asList(hospitalIds)));
        sciList.add(hosItem);
        if (cohort != null) {
            SearchConditionItem cohortItem = new SearchConditionItem("Cohort", SearchConditionGroupItem.QueryRelation.AND, p);
            cohortItem.setDescription(StringConditionEncoder.getDescription(Arrays.asList(cohort)));
            cohortItem.setSearchConditionEncoding(StringConditionEncoder.encodeConditions(Arrays.asList(cohort)));
            sciList.add(cohortItem);
        }
        qvc.replaceFirstLevelGroup("Cohort Member(s)", sciList, SearchConditionGroupItem.QueryRelation.AND, true);
    }

    public static void addQueryOnHospitals(String[] hospitalIds) {
        QueryUtils.addQueryOnHospitals(hospitalIds, null);
    }
}

