/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.inspector;

import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.pane.CollapsiblePanes;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyVetoException;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.view.genetics.inspector.Inspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public abstract class CollapsibleInspector
extends JPanel
implements Inspector {
    private static final Log LOG = LogFactory.getLog(CollapsibleInspector.class);
    private final JPanel container = ViewUtil.getClearPanel();
    private final CollapsiblePanes panesContainer;
    private final JPanel messageContainer;
    static final String MESSAGEPANEL = "msg";
    static final String PANESPANEL = "panes";

    public CollapsibleInspector() {
        this.container.setLayout(new CardLayout());
        this.messageContainer = ViewUtil.getClearPanel();
        this.messageContainer.setBorder(ViewUtil.getBigBorder());
        this.messageContainer.setLayout(new BorderLayout());
        this.panesContainer = new CollapsiblePanes();
        this.panesContainer.addExpansion();
        this.setLayout(new BorderLayout());
        this.add((Component)this.container, "Center");
        this.container.add((Component)this.panesContainer, PANESPANEL);
        this.container.add((Component)this.messageContainer, MESSAGEPANEL);
        this.switchToMessage();
    }

    public final void switchToMessage() {
        CardLayout cl = (CardLayout)this.container.getLayout();
        cl.show(this.container, MESSAGEPANEL);
    }

    public void setMessage(String msg, String helpTitle, String helpMessage) {
        JPanel messagePanel = ViewUtil.getClearPanel();
        messagePanel.setBorder(ViewUtil.getHugeBorder());
        ViewUtil.applyVerticalBoxLayout(messagePanel);
        JLabel h2 = new JLabel(msg);
        messagePanel.add(Box.createVerticalGlue());
        messagePanel.add(ViewUtil.centerHorizontally(h2));
        messagePanel.add(Box.createVerticalStrut(3));
        messagePanel.add(ViewUtil.centerHorizontally(ViewUtil.getHelpButton(helpTitle, helpMessage)));
        messagePanel.add(Box.createVerticalGlue());
        this.setMessage(messagePanel);
    }

    public void setMessage(JPanel msg) {
        this.messageContainer.removeAll();
        this.messageContainer.add((Component)msg, "Center");
    }

    public final void switchToPanes() {
        CardLayout cl = (CardLayout)this.container.getLayout();
        cl.show(this.container, PANESPANEL);
    }

    @Override
    public abstract String getName();

    @Override
    public JPanel getContent() {
        return this;
    }

    protected void addSubInspector(SubInspector ipan) {
        this.addSubInspector(ipan, false);
    }

    protected void addComponent(Component c) {
        this.panesContainer.remove(this.panesContainer.getComponentCount() - 1);
        this.panesContainer.add(c);
        this.panesContainer.addExpansion();
    }

    protected void addSubInspector(SubInspector ipan, boolean collapsed) {
        this.panesContainer.remove(this.panesContainer.getComponentCount() - 1);
        CollapsiblePane p = new CollapsiblePane(ipan.getName());
        ipan.setPaneParent(p);
        try {
            p.setCollapsed(collapsed);
        }
        catch (PropertyVetoException ex) {
            // empty catch block
        }
        p.setStyle(2);
        p.setLayout((LayoutManager)new BorderLayout());
        p.setFocusPainted(false);
        LOG.debug((Object)"Adding subinspector...");
        p.add((Component)ipan.getInfoPanel(), (Object)"Center");
        this.panesContainer.add((Component)p);
        this.panesContainer.addExpansion();
    }
}

