/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class ClinvarSubInspector
extends SubInspector {
    private static final String URL_CHARSET = "UTF-8";
    private final String CLINVAR_RSID_TEXT = "Clinvar, rsID";
    private final String CLINVAR_INFO_TEXT = "Clinvar, info";
    private final String baseDBSNPUrl = "http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?searchType=adhoc_search&rs=";
    private final String baseClinvarUrl = "http://www.ncbi.nlm.nih.gov/clinvar/";
    private final String baseOMIMUrl = "http://www.omim.org/entry/";
    private final int KEY_VALUE_PAIR_PANEL_ADDITIONAL_COLUMN_NUMBER = 4;
    private final String KEY_CLINVAR_RSID = "dbSNP ID";
    private final String KEY_CLINVAR_SIG = "Clinical Significance";
    private final String KEY_CLINVAR_SRC = "OMIM Allelic Variant ID";
    private final String KEY_CLINVAR_DSDB = "OMIM Disease ID";
    private final String KEY_CLINVAR_DBN = "Disease Name";
    private final String KEY_CLINVAR_ACC = "Clinvar Accession";
    private Object[] currentLine;
    private int CLINVAR_RSID_INDEX;
    private int CLINVAR_INFO_INDEX;
    private KeyValuePairPanel p;
    private String rsID;
    private String clnSig;
    private String omimID;
    private String omimAllelicVariantID;
    private String disease;
    private String accession;
    private Map variantClinicalSignificance = new HashMap();

    public ClinvarSubInspector() {
        this.initializeSignificance();
    }

    @Override
    public String getName() {
        return "Clinvar Information";
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.p == null) {
            this.p = new KeyValuePairPanel(4);
            this.p.addKey("dbSNP ID");
            this.p.addKey("Clinical Significance");
            this.p.addKey("Disease Name");
            this.p.addKey("OMIM Allelic Variant ID");
            this.p.addKey("OMIM Disease ID");
            this.p.addKey("Clinvar Accession");
        }
        return this.p;
    }

    private void initializeSignificance() {
        this.variantClinicalSignificance.put("0", "unknown");
        this.variantClinicalSignificance.put("1", "untested");
        this.variantClinicalSignificance.put("2", "non-pathogenic");
        this.variantClinicalSignificance.put("3", "probable-non-pathogenic");
        this.variantClinicalSignificance.put("4", "probable-pathogenic");
        this.variantClinicalSignificance.put("5", "pathogenic");
        this.variantClinicalSignificance.put("6", "drug-response");
        this.variantClinicalSignificance.put("7", "histocompatibility");
        this.variantClinicalSignificance.put("255", "other");
    }

    public void setVariantLine(Object[] line, List<String> header) {
        this.currentLine = line;
        this.CLINVAR_RSID_INDEX = header.indexOf("Clinvar, rsID");
        this.CLINVAR_INFO_INDEX = header.indexOf("Clinvar, info");
        this.rsID = this.CLINVAR_RSID_INDEX != -1 && this.currentLine[this.CLINVAR_RSID_INDEX] != null ? (String)this.currentLine[this.CLINVAR_RSID_INDEX] : "";
        if (this.CLINVAR_INFO_INDEX != -1 && this.currentLine[this.CLINVAR_INFO_INDEX] != null) {
            this.parseClinvarInfo((String)this.currentLine[this.CLINVAR_INFO_INDEX]);
        } else {
            this.resetClinvarFields();
        }
        this.p.setValue("dbSNP ID", this.rsID);
        int buttonNumber = 0;
        this.p.setAdditionalColumn("dbSNP ID", buttonNumber++, KeyValuePairPanel.getCopyButton("dbSNP ID", this.p));
        this.p.setAdditionalColumn("dbSNP ID", buttonNumber++, this.getKeyValuePairPanelButton("dbSNP ID", "http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?searchType=adhoc_search&rs=", this.p.getValue("dbSNP ID"), true));
        String clnSigTranslation = "";
        if (this.variantClinicalSignificance.containsKey(this.clnSig)) {
            clnSigTranslation = (String)this.variantClinicalSignificance.get(this.clnSig);
        }
        this.p.setValue("Clinical Significance", clnSigTranslation);
        this.p.setValue("Disease Name", this.disease);
        this.p.setValue("Clinvar Accession", this.accession);
        Matcher m = Pattern.compile("([^\\.]+)\\.").matcher(this.accession);
        String accessionRoot = "";
        if (m.find()) {
            accessionRoot = m.group(1);
        }
        buttonNumber = 0;
        this.p.setAdditionalColumn("Clinvar Accession", buttonNumber++, KeyValuePairPanel.getCopyButton("Clinvar Accession", this.p));
        this.p.setAdditionalColumn("Clinvar Accession", buttonNumber++, this.getKeyValuePairPanelButton("Clinvar Accession", "http://www.ncbi.nlm.nih.gov/clinvar/", accessionRoot, true));
        this.p.setValue("OMIM Allelic Variant ID", this.omimAllelicVariantID);
        String omimAllelicVariantID_url = this.omimAllelicVariantID.replaceAll("\\.", "#");
        buttonNumber = 0;
        this.p.setAdditionalColumn("OMIM Allelic Variant ID", buttonNumber++, KeyValuePairPanel.getCopyButton("OMIM Allelic Variant ID", this.p));
        this.p.setAdditionalColumn("OMIM Allelic Variant ID", buttonNumber++, this.getKeyValuePairPanelButton("OMIM Allelic Variant ID", "http://www.omim.org/entry/", omimAllelicVariantID_url, false));
        this.p.setValue("OMIM Disease ID", this.omimID);
        buttonNumber = 0;
        this.p.setAdditionalColumn("OMIM Disease ID", buttonNumber++, KeyValuePairPanel.getCopyButton("OMIM Disease ID", this.p));
        this.p.setAdditionalColumn("OMIM Disease ID", buttonNumber++, this.getKeyValuePairPanelButton("OMIM Disease ID", "http://www.omim.org/entry/", this.omimID, true));
    }

    private void parseClinvarInfo(String clinvarInfoText) {
        Matcher omimIDMatcher;
        String s;
        List<String> l;
        int index;
        Matcher omimMatcher;
        Matcher omimAllelicVariantIDMatcher;
        String s2;
        List<String> l2;
        int index2;
        Matcher omimAllelicMatcher;
        Pattern diseasePattern;
        Matcher diseaseMatcher;
        this.resetClinvarFields();
        Pattern clnSigPattern = Pattern.compile(";?CLNSIG=([^;]+);?", 2);
        Matcher clnSigMatcher = clnSigPattern.matcher(clinvarInfoText);
        if (clnSigMatcher.find()) {
            this.clnSig = clnSigMatcher.group(1);
        }
        if ((diseaseMatcher = (diseasePattern = Pattern.compile(";?CLNDBN=([^;]+);?", 2)).matcher(clinvarInfoText)).find()) {
            this.disease = diseaseMatcher.group(1);
        }
        this.disease = this.disease.replaceAll("_", " ");
        this.disease = this.disease.replaceAll("\\|", "; ");
        this.disease = this.disease.replaceAll("\\x2c", ", ");
        Pattern accessionPattern = Pattern.compile(";?CLNACC=([^;]+);?", 2);
        Matcher accessionMatcher = accessionPattern.matcher(clinvarInfoText);
        if (accessionMatcher.find()) {
            String s3 = accessionMatcher.group(1);
            List<String> l3 = Arrays.asList(s3.split("\\|"));
            this.accession = l3.get(0);
        }
        if ((omimAllelicMatcher = Pattern.compile(";?CLNSRC=([^;]+);?", 2).matcher(clinvarInfoText)).find() && (index2 = (l2 = Arrays.asList((s2 = omimAllelicMatcher.group(1)).split(":"))).indexOf("OMIM_Allelic_Variant")) != -1 && (omimAllelicVariantIDMatcher = Pattern.compile(";?CLNSRCID=([^;]+);?", 2).matcher(clinvarInfoText)).find()) {
            String s22 = omimAllelicVariantIDMatcher.group(1);
            List<String> l22 = Arrays.asList(s22.split(":"));
            this.omimAllelicVariantID = l22.get(index2);
        }
        if ((omimMatcher = Pattern.compile(";?CLNDSDB=([^;]+);?", 2).matcher(clinvarInfoText)).find() && (index = (l = Arrays.asList((s = omimMatcher.group(1)).split(":"))).indexOf("OMIM")) != -1 && (omimIDMatcher = Pattern.compile(";?CLNDSDBID=([^;]+);?", 2).matcher(clinvarInfoText)).find()) {
            String s23 = omimIDMatcher.group(1);
            List<String> l23 = Arrays.asList(s23.split(":"));
            this.omimID = l23.get(index);
        }
    }

    private void resetClinvarFields() {
        this.clnSig = "";
        this.omimID = "";
        this.omimAllelicVariantID = "";
        this.disease = "";
        this.accession = "";
    }

    private Component getKeyValuePairPanelButton(String key, final String baseUrl, final String appendToUrl, final boolean doEncode) {
        JButton ncbiButton = ViewUtil.getTexturedButton("", IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LINKOUT));
        ncbiButton.setToolTipText("Lookup " + key + " on the web");
        ncbiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    URL url = doEncode ? new URL(baseUrl + URLEncoder.encode(appendToUrl, ClinvarSubInspector.URL_CHARSET)) : new URL(baseUrl + appendToUrl);
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Problem launching website: %s", ex);
                }
            }
        });
        return ncbiButton;
    }

    private Component getDBSNPButton(final String key) {
        JButton ncbiButton = ViewUtil.getTexturedButton("", IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LINKOUT));
        ncbiButton.setToolTipText("Lookup " + key + " at NCBI");
        ncbiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    URL url = new URL("http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?searchType=adhoc_search&rs=" + URLEncoder.encode(ClinvarSubInspector.this.p.getValue(key), ClinvarSubInspector.URL_CHARSET));
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Problem launching NCBI website: %s", ex);
                }
            }
        });
        return ncbiButton;
    }

    public String getRsID() {
        return this.rsID;
    }

    public String getClnSig() {
        String clnSigTranslation = "";
        if (this.variantClinicalSignificance.containsKey(this.clnSig)) {
            clnSigTranslation = (String)this.variantClinicalSignificance.get(this.clnSig);
        }
        return clnSigTranslation;
    }

    public String getOmimID() {
        return this.omimID;
    }

    public String getOmimAllelicVariantID() {
        return this.omimAllelicVariantID;
    }

    public String getDisease() {
        return this.disease;
    }

    public String getClinvarAccession() {
        return this.accession;
    }
}

