/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.genemania.type.CombiningMethod;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.GenemaniaInfoRetriever;

public class GeneManiaSettingsDialog
extends JDialog {
    private GenemaniaInfoRetriever genemania;
    private boolean rankByVarFreq;
    private JFrame frame;
    private static final int DEFAULT_RELATED_GENES_LIMIT = 50;
    private final CombiningMethod[] GENEMANIA_COMBINING_METHODS = new CombiningMethod[]{CombiningMethod.AVERAGE, CombiningMethod.BP, CombiningMethod.MF, CombiningMethod.CC, CombiningMethod.AUTOMATIC};
    private boolean updateQueryNeeded;
    private JButton okButton;

    public GeneManiaSettingsDialog(GenemaniaInfoRetriever g) {
        this.genemania = g;
        this.initialize();
    }

    private void initialize() {
        JPanel panel = new JPanel();
        JLabel limitTo = new JLabel();
        JLabel relatedGenes = new JLabel();
        JSeparator jSeparator1 = new JSeparator();
        JLabel rankBy = new JLabel();
        JSeparator jSeparator2 = new JSeparator();
        JLabel networks = new JLabel();
        JSeparator jSeparator3 = new JSeparator();
        JLabel networkWeighting = new JLabel();
        JPanel equal = new JPanel();
        JPanel geneOntology = new JPanel();
        JPanel queryDependent = new JPanel();
        final JTextField relatedGenesLimit = new JTextField();
        relatedGenesLimit.setText(Integer.toString(50));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        final ButtonGroup buttonGroup2 = new ButtonGroup();
        JRadioButton varFreq = new JRadioButton();
        JRadioButton genemaniaScore = new JRadioButton();
        final JCheckBox coexp = new JCheckBox();
        final JCheckBox spd = new JCheckBox();
        final JCheckBox gi = new JCheckBox();
        final JCheckBox coloc = new JCheckBox();
        final JCheckBox pathCheck = new JCheckBox();
        final JCheckBox predict = new JCheckBox();
        final JCheckBox pi = new JCheckBox();
        final JCheckBox other = new JCheckBox();
        JRadioButton automatic = new JRadioButton();
        JRadioButton bp = new JRadioButton();
        JRadioButton mf = new JRadioButton();
        JRadioButton average = new JRadioButton();
        JRadioButton cc = new JRadioButton();
        this.okButton = new JButton();
        this.updateQueryNeeded = false;
        limitTo.setText("Limit to");
        genemaniaScore.setSelected(true);
        this.rankByVarFreq = false;
        coexp.setSelected(true);
        coloc.setSelected(true);
        spd.setSelected(true);
        gi.setSelected(true);
        pi.setSelected(true);
        pathCheck.setSelected(true);
        other.setSelected(true);
        predict.setSelected(true);
        average.setSelected(true);
        this.okButton.setEnabled(false);
        relatedGenesLimit.setColumns(5);
        relatedGenesLimit.setPreferredSize(new Dimension(30, relatedGenesLimit.getPreferredSize().height));
        relatedGenesLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneManiaSettingsDialog.this.okButton.setEnabled(true);
                GeneManiaSettingsDialog.this.genemania.setGeneLimit(Integer.parseInt(relatedGenesLimit.getText()));
            }
        });
        relatedGenes.setText("related genes.");
        rankBy.setText("Rank by");
        ActionListener scoringActionPerformed = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneManiaSettingsDialog.this.okButton.setEnabled(true);
                if (evt.getActionCommand().equals("genemaniaScore")) {
                    GeneManiaSettingsDialog.this.rankByVarFreq = false;
                } else {
                    GeneManiaSettingsDialog.this.rankByVarFreq = true;
                }
            }
        };
        buttonGroup1.add(varFreq);
        varFreq.setText("Variation Frequency");
        varFreq.setActionCommand("varFreq");
        varFreq.addActionListener(scoringActionPerformed);
        buttonGroup1.add(genemaniaScore);
        genemaniaScore.setText("GeneMANIA Score");
        genemaniaScore.setActionCommand("genemaniaScore");
        genemaniaScore.addActionListener(scoringActionPerformed);
        networks.setText("Networks");
        ActionListener networksActionPerformed = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneManiaSettingsDialog.this.okButton.setEnabled(true);
                HashSet<String> networksSelected = new HashSet<String>();
                JCheckBox[] networkButtons = new JCheckBox[]{coexp, spd, gi, coloc, pathCheck, predict, pi, other};
                for (int i = 0; i < networkButtons.length; ++i) {
                    if (!networkButtons[i].isSelected()) continue;
                    networksSelected.add(networkButtons[i].getActionCommand());
                }
                GeneManiaSettingsDialog.this.genemania.setNetworks(networksSelected);
            }
        };
        coexp.setText("Co-expression");
        coexp.addActionListener(networksActionPerformed);
        spd.setText("Shared Protein Domains");
        spd.addActionListener(networksActionPerformed);
        gi.setText("Genetic interactions");
        gi.addActionListener(networksActionPerformed);
        coloc.setText("Co-localization");
        coloc.addActionListener(networksActionPerformed);
        pathCheck.setText("Pathway interactions");
        pathCheck.addActionListener(networksActionPerformed);
        predict.setText("Predicted");
        predict.addActionListener(networksActionPerformed);
        pi.setText("Physical interactions");
        pi.addActionListener(networksActionPerformed);
        other.setText("Other");
        other.addActionListener(networksActionPerformed);
        networkWeighting.setText("Network weighting");
        equal.setBorder(BorderFactory.createTitledBorder("Equal weighting"));
        ActionListener combiningMethodActionPerformed = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneManiaSettingsDialog.this.okButton.setEnabled(true);
                int indexOfCombiningMethod = 0;
                Enumeration<AbstractButton> buttonEnum = buttonGroup2.getElements();
                while (buttonEnum.hasMoreElements() && !buttonEnum.nextElement().isSelected()) {
                    ++indexOfCombiningMethod;
                }
                GeneManiaSettingsDialog.this.genemania.setCombiningMethod(GeneManiaSettingsDialog.this.GENEMANIA_COMBINING_METHODS[indexOfCombiningMethod]);
            }
        };
        buttonGroup2.add(average);
        average.setText("Equal by network");
        average.setActionCommand("average");
        average.addActionListener(combiningMethodActionPerformed);
        GroupLayout equalLayout = new GroupLayout(equal);
        equal.setLayout(equalLayout);
        equalLayout.setHorizontalGroup(equalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(equalLayout.createSequentialGroup().addContainerGap().addComponent(average).addContainerGap(-1, Short.MAX_VALUE)));
        equalLayout.setVerticalGroup(equalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(equalLayout.createSequentialGroup().addComponent(average).addGap(0, 2, Short.MAX_VALUE)));
        geneOntology.setBorder(BorderFactory.createTitledBorder("Gene Ontology (GO)- based weighting"));
        buttonGroup2.add(bp);
        bp.setText("Biological process based");
        bp.setActionCommand("bp");
        bp.addActionListener(combiningMethodActionPerformed);
        buttonGroup2.add(mf);
        mf.setText("Molecular function based");
        mf.setActionCommand("mf");
        mf.addActionListener(combiningMethodActionPerformed);
        buttonGroup2.add(cc);
        cc.setText("Cellular component based");
        cc.setActionCommand("cc");
        cc.addActionListener(combiningMethodActionPerformed);
        GroupLayout geneOntologyLayout = new GroupLayout(geneOntology);
        geneOntology.setLayout(geneOntologyLayout);
        geneOntologyLayout.setHorizontalGroup(geneOntologyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(geneOntologyLayout.createSequentialGroup().addContainerGap().addComponent(bp).addGap(32, 32, 32).addComponent(mf).addGap(18, 18, 18).addComponent(cc).addContainerGap(129, Short.MAX_VALUE)));
        geneOntologyLayout.setVerticalGroup(geneOntologyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(geneOntologyLayout.createSequentialGroup().addGroup(geneOntologyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(bp).addComponent(mf).addComponent(cc)).addContainerGap(-1, Short.MAX_VALUE)));
        queryDependent.setBorder(BorderFactory.createTitledBorder("Query-dependent weighting"));
        buttonGroup2.add(automatic);
        automatic.setText("Automatically selected weighting method");
        automatic.setActionCommand("automatic");
        automatic.addActionListener(combiningMethodActionPerformed);
        GroupLayout queryDependentLayout = new GroupLayout(queryDependent);
        queryDependent.setLayout(queryDependentLayout);
        queryDependentLayout.setHorizontalGroup(queryDependentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(queryDependentLayout.createSequentialGroup().addContainerGap().addComponent(automatic).addContainerGap(-1, Short.MAX_VALUE)));
        queryDependentLayout.setVerticalGroup(queryDependentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(queryDependentLayout.createSequentialGroup().addComponent(automatic).addContainerGap(8, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GeneManiaSettingsDialog.this.updateQueryNeeded = true;
                GeneManiaSettingsDialog.this.setVisible(false);
            }
        });
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(gi).addComponent(coexp)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(pathCheck).addComponent(coloc)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(spd).addComponent(pi)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(other).addComponent(predict))).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(networkWeighting).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(equal, -1, -1, Short.MAX_VALUE).addComponent(geneOntology, -1, -1, Short.MAX_VALUE).addComponent(queryDependent, -1, -1, Short.MAX_VALUE)).addComponent(jSeparator3, -2, 597, -2).addComponent(networks).addComponent(jSeparator2, -2, 597, -2).addGroup(layout.createSequentialGroup().addComponent(rankBy).addGap(44, 44, 44).addComponent(varFreq).addGap(18, 18, 18).addComponent(genemaniaScore)).addComponent(jSeparator1, -2, 597, -2).addGroup(layout.createSequentialGroup().addComponent(limitTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(relatedGenesLimit, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(relatedGenes)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.okButton, -2, 84, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(limitTo).addComponent(relatedGenesLimit, -2, -1, -2).addComponent(relatedGenes)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(rankBy).addComponent(varFreq).addComponent(genemaniaScore)).addGap(26, 26, 26).addComponent(jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(networks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(coexp).addComponent(coloc).addComponent(spd).addComponent(predict)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(gi).addComponent(pathCheck).addComponent(pi).addComponent(other)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jSeparator3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(networkWeighting).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(equal, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(geneOntology, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(queryDependent, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addContainerGap()));
        this.add(panel);
    }

    public void showSettings() {
        this.okButton.setEnabled(false);
        this.setSize(960, 600);
        this.pack();
        this.setTitle("GeneMANIA Settings");
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.setVisible(true);
    }

    public boolean getRankByVarFreq() {
        return this.rankByVarFreq;
    }

    public boolean getUpdateQueryNeeded() {
        return this.updateQueryNeeded;
    }
}

