/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.app.AppDirectory;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.EntrezButton;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import savant.controller.LocationController;
import savant.util.Range;

public class GeneSubInspector
extends SubInspector
implements Listener<Gene> {
    private static String KEY_NAME = "Name";
    private static String KEY_POSITION = "Position";
    private static String KEY_LENGTH = "Length";
    private KeyValuePairPanel panel;
    private Gene selectedGene;
    static String charset = "UTF-8";

    @Override
    public String getName() {
        return "Gene Details";
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.panel == null) {
            this.panel = new KeyValuePairPanel(2);
            this.panel.addKey(KEY_NAME);
            this.panel.addKey(KEY_POSITION);
            this.panel.addKey(KEY_LENGTH);
            JButton genomeBrowserButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.BROWSER));
            genomeBrowserButton.setToolTipText("View region in genome browser");
            genomeBrowserButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LocationController.getInstance().setLocation(GeneSubInspector.this.selectedGene.getChrom(), new Range(GeneSubInspector.this.selectedGene.getCodingStart() - 20, GeneSubInspector.this.selectedGene.getCodingEnd() + 21));
                    AppDirectory.launchApp(AppDirectory.BuiltInApp.GENOME_BROWSER);
                }
            });
            this.panel.setAdditionalColumn(KEY_POSITION, 0, KeyValuePairPanel.getCopyButton(KEY_POSITION, this.panel));
            this.panel.setAdditionalColumn(KEY_POSITION, 1, genomeBrowserButton);
        }
        return this.panel;
    }

    public boolean showHeader() {
        return false;
    }

    @Override
    public void handleEvent(Gene g) {
        if (this.panel == null) {
            return;
        }
        if (g == null) {
            return;
        }
        this.selectedGene = g;
        this.panel.setValue(KEY_NAME, g.getName());
        EntrezButton filterButton2 = new EntrezButton(g.getName());
        this.panel.setAdditionalColumn(KEY_NAME, 1, filterButton2);
        this.panel.setValue(KEY_POSITION, g.getChrom() + ":" + ViewUtil.numToString(g.getStart()) + "-" + ViewUtil.numToString(g.getEnd()));
        this.panel.setValue(KEY_LENGTH, MiscUtils.numToStringWithOrder(g.getEnd() - g.getStart()) + "bp");
        try {
            String s = ClientMiscUtils.breakString(g.getDescription(), "", 45);
            this.panel.getComponent(KEY_NAME).setToolTipText(s);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.panel.getComponent(KEY_NAME).setToolTipText("");
        }
        this.panel.ellipsifyValues(300);
    }
}

