/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.util.IOUtils;
import org.genemania.domain.Gene;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.dto.EnrichmentEngineRequestDto;
import org.genemania.dto.EnrichmentEngineResponseDto;
import org.genemania.dto.InteractionDto;
import org.genemania.dto.NetworkDto;
import org.genemania.dto.RelatedGenesEngineRequestDto;
import org.genemania.dto.RelatedGenesEngineResponseDto;
import org.genemania.engine.Mania2;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.cache.MemObjectCache;
import org.genemania.engine.cache.SynchronizedObjectCache;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.cytoscape.NullCytoscapeUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.IDataSetFactory;
import org.genemania.plugin.data.lucene.LuceneDataSetFactory;
import org.genemania.plugin.model.SearchResult;
import org.genemania.type.CombiningMethod;
import org.genemania.type.ScoringMethod;
import org.genemania.util.NullProgressReporter;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.DownloadTask;
import org.ut.biolab.medsavant.shared.util.WebResources;
import org.xml.sax.SAXException;

public class GenemaniaInfoRetriever {
    private List<String> genes;
    private static final int DEFAULT_GENE_LIMIT = 50;
    private static final CombiningMethod DEFAULT_COMBINING_METHOD = CombiningMethod.AVERAGE;
    private static final String[] DEFAULT_NETWORKS = new String[]{"Genetic interactions", "Shared protein domains", "Other", "Pathway", "Physical interactions", "Co-localization", "Predicted", "Co-expression"};
    private int geneLimit;
    private CombiningMethod combiningMethod;
    private Map<InteractionNetworkGroup, Collection<InteractionNetwork>> networks;
    private DataSetManager dataSetManager;
    private static DataSet data;
    private static Organism human;
    private Mania2 mania;
    private DataCache cache;
    private NetworkUtils networkUtils;
    private static final int MIN_CATEGORIES = 10;
    private static final double Q_VALUE_THRESHOLD = 0.1;
    private SearchResult options;
    private static Map<Long, Integer> sequenceNumbers;
    private RelatedGenesEngineResponseDto response;
    private static final Log LOG;
    private static GeneManiaDownloadTask geneManiaDownloadTask;

    public static void extractGM(String pathToGMData) {
        String directoryPath = DirectorySettings.getCacheDirectory().getAbsolutePath();
        try {
            File data = new File(pathToGMData);
            ZipFile zipData = new ZipFile(data.getAbsolutePath());
            Enumeration<? extends ZipEntry> entries = zipData.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    new File(directoryPath + File.separator + entry.getName()).mkdirs();
                    continue;
                }
                IOUtils.copy((InputStream)zipData.getInputStream(entry), (OutputStream)new FileOutputStream(directoryPath + File.separator + entry.getName()));
            }
            zipData.close();
            FileWriter fstream = new FileWriter(DirectorySettings.getGeneManiaDirectory() + File.separator + "gmdataOK.txt");
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("This file indicates that the GeneMANIA data has finished downloading.");
            out.close();
            if (!data.delete()) {
                LOG.error((Object)("Couldn't delete GeneMANIA .zip: " + data.getAbsolutePath()));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(GenemaniaInfoRetriever.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static synchronized boolean isGeneManiaDownloading() {
        boolean b = geneManiaDownloadTask != null && !geneManiaDownloadTask.isDone() && !geneManiaDownloadTask.isCancelled();
        return b;
    }

    public static synchronized DownloadTask getGeneManiaDownloadTask() throws IOException {
        if (geneManiaDownloadTask == null || geneManiaDownloadTask.isCancelled()) {
            String dstPath = DirectorySettings.getCacheDirectory().getAbsolutePath();
            geneManiaDownloadTask = new GeneManiaDownloadTask(WebResources.GENEMANIA_DATA_URL.toString(), dstPath, "Downloading GeneMANIA...");
        }
        return geneManiaDownloadTask;
    }

    public GenemaniaInfoRetriever() throws IOException {
        if (!DirectorySettings.isGeneManiaInstalled()) {
            throw new IOException("GeneMANIA data not found, please download it first.");
        }
        this.initialize();
    }

    public void setGenes(List<String> geneNames) {
        try {
            this.genes = GenemaniaInfoRetriever.getValidGenes(geneNames);
        }
        catch (Exception ex) {
            Logger.getLogger(GenemaniaInfoRetriever.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public List<String> getGenes() {
        return this.genes;
    }

    public void setGeneLimit(int geneLimit) {
        this.geneLimit = geneLimit;
    }

    public void setCombiningMethod(CombiningMethod cm) {
        this.combiningMethod = cm;
    }

    public List<String> getRelatedGeneNamesByScore() throws ApplicationException, DataStoreException, NoRelatedGenesInfoException {
        ArrayList<String> geneNames = new ArrayList<String>();
        Iterator<Gene> itr = this.getRelatedGenesByScore().iterator();
        while (itr.hasNext()) {
            geneNames.add(itr.next().getSymbol());
        }
        return geneNames;
    }

    public List<Gene> getRelatedGenesByScore() throws ApplicationException, DataStoreException, NoRelatedGenesInfoException {
        this.options = this.runGeneManiaAlgorithm();
        final Map scores = this.options.getScores();
        ArrayList<Gene> relatedGenes = new ArrayList<Gene>(scores.keySet());
        Collections.sort(relatedGenes, new Comparator<Gene>(){

            @Override
            public int compare(Gene gene1, Gene gene2) {
                return -Double.compare((Double)scores.get(gene1), (Double)scores.get(gene2));
            }
        });
        return relatedGenes;
    }

    public NetworkUtils getNetworkUtils() {
        return this.networkUtils;
    }

    private Map<Long, Double> filterGeneScores(Map<Long, Double> scores, SearchResult options) {
        Map queryGenes = options.getQueryGenes();
        double maxScore = 0.0;
        for (Map.Entry<Long, Double> entry : scores.entrySet()) {
            if (queryGenes.containsKey(entry.getKey())) continue;
            maxScore = Math.max(maxScore, entry.getValue());
        }
        HashMap<Long, Double> filtered = new HashMap<Long, Double>();
        for (Map.Entry<Long, Double> entry : scores.entrySet()) {
            long nodeId = entry.getKey();
            double score = entry.getValue();
            filtered.put(entry.getKey(), queryGenes.containsKey(nodeId) ? maxScore : score);
        }
        return filtered;
    }

    private double[] computeEdgeWeightExtrema(RelatedGenesEngineResponseDto response) {
        double[] extrema = new double[]{1.0, 0.0};
        for (NetworkDto network : response.getNetworks()) {
            for (InteractionDto interaction : network.getInteractions()) {
                double weight = interaction.getWeight() * network.getWeight();
                if (extrema[0] > weight) {
                    extrema[0] = weight;
                }
                if (!(extrema[1] < weight)) continue;
                extrema[1] = weight;
            }
        }
        return extrema;
    }

    private SearchResult runGeneManiaAlgorithm() throws ApplicationException, DataStoreException, NoRelatedGenesInfoException {
        RelatedGenesEngineRequestDto request = this.createRequest();
        this.response = this.runQuery(request);
        EnrichmentEngineRequestDto enrichmentRequest = this.createEnrichmentRequest(this.response);
        EnrichmentEngineResponseDto enrichmentResponse = this.computeEnrichment(enrichmentRequest);
        SearchResult options = this.networkUtils.createSearchOptions(human, request, this.response, enrichmentResponse, data, this.genes);
        return options;
    }

    private EnrichmentEngineRequestDto createEnrichmentRequest(RelatedGenesEngineResponseDto response) {
        if (human.getOntology() == null) {
            return null;
        }
        EnrichmentEngineRequestDto request = new EnrichmentEngineRequestDto();
        request.setProgressReporter(NullProgressReporter.instance());
        request.setMinCategories(10);
        request.setqValueThreshold(0.1);
        request.setOrganismId(human.getId());
        request.setOntologyId(human.getOntology().getId());
        HashSet<Long> nodes = new HashSet<Long>();
        for (NetworkDto network : response.getNetworks()) {
            for (InteractionDto interaction : network.getInteractions()) {
                nodes.add(interaction.getNodeVO1().getId());
                nodes.add(interaction.getNodeVO2().getId());
            }
        }
        request.setNodes(nodes);
        return request;
    }

    private EnrichmentEngineResponseDto computeEnrichment(EnrichmentEngineRequestDto request) throws ApplicationException, NoRelatedGenesInfoException {
        if (request == null) {
            return null;
        }
        if (request.getNodes().size() == 0) {
            throw new NoRelatedGenesInfoException();
        }
        return this.mania.computeEnrichment(request);
    }

    private RelatedGenesEngineRequestDto createRequest() throws ApplicationException {
        RelatedGenesEngineRequestDto request = new RelatedGenesEngineRequestDto();
        request.setNamespace("user");
        request.setOrganismId(human.getId());
        request.setInteractionNetworks(this.collapseNetworks(this.networks));
        HashSet<Long> nodes = new HashSet<Long>();
        for (String geneName : this.genes) {
            nodes.add(data.getCompletionProvider(human).getNodeId(geneName));
        }
        request.setPositiveNodes(nodes);
        request.setLimitResults(this.geneLimit);
        request.setCombiningMethod(this.combiningMethod);
        request.setScoringMethod(ScoringMethod.DISCRIMINANT);
        return request;
    }

    private RelatedGenesEngineResponseDto runQuery(RelatedGenesEngineRequestDto request) throws DataStoreException {
        try {
            request.setProgressReporter(NullProgressReporter.instance());
            RelatedGenesEngineResponseDto result = this.mania.findRelated(request);
            request.setCombiningMethod(result.getCombiningMethodApplied());
            this.networkUtils.normalizeNetworkWeights(result);
            return result;
        }
        catch (ApplicationException e) {
            org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(this.getClass());
            logger.error((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    private Collection<Collection<Long>> collapseNetworks(Map<InteractionNetworkGroup, Collection<InteractionNetwork>> networks) {
        ArrayList<Collection<Long>> result = new ArrayList<Collection<Long>>();
        for (Map.Entry<InteractionNetworkGroup, Collection<InteractionNetwork>> entry : networks.entrySet()) {
            HashSet<Long> groupMembers = new HashSet<Long>();
            for (InteractionNetwork network : entry.getValue()) {
                groupMembers.add(network.getId());
            }
            if (groupMembers.isEmpty()) continue;
            result.add(groupMembers);
        }
        return result;
    }

    private void initialize() {
        try {
            this.dataSetManager = new DataSetManager();
            this.dataSetManager.addDataSetFactory((IDataSetFactory)new LuceneDataSetFactory(this.dataSetManager, null, new FileUtils(), (CytoscapeUtils)new NullCytoscapeUtils(), null), Collections.emptyMap());
            data = this.dataSetManager.open(DirectorySettings.getGeneManiaDirectory());
            human = this.getHumanOrganism(data);
            this.networkUtils = new NetworkUtils();
            this.cache = new DataCache((IObjectCache)new SynchronizedObjectCache((IObjectCache)new MemObjectCache(data.getObjectCache(NullProgressReporter.instance(), false))));
            this.mania = new Mania2(this.cache);
            this.setGeneLimit(50);
            this.setCombiningMethod(DEFAULT_COMBINING_METHOD);
            this.setNetworks(new HashSet<String>(Arrays.asList(DEFAULT_NETWORKS)));
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public void setNetworks(Set<String> n) {
        HashMap<InteractionNetworkGroup, Collection<InteractionNetwork>> groupMembers = new HashMap<InteractionNetworkGroup, Collection<InteractionNetwork>>();
        Collection groups = human.getInteractionNetworkGroups();
        Set<String> notHandled = n;
        for (InteractionNetworkGroup group : groups) {
            if (!n.contains(group.getName())) continue;
            notHandled.remove(group.getName());
            ArrayList<InteractionNetwork> networkMembers = new ArrayList<InteractionNetwork>();
            Collection networks = group.getInteractionNetworks();
            for (InteractionNetwork network : networks) {
                networkMembers.add(network);
            }
            if (networkMembers.size() <= 0) continue;
            groupMembers.put(group, networkMembers);
        }
        this.networks = groupMembers;
    }

    public Map<InteractionNetworkGroup, Collection<InteractionNetwork>> getNetworks() {
        return this.networks;
    }

    public int getGeneLimit() {
        return this.geneLimit;
    }

    public CombiningMethod getCombiningMethod() {
        return this.combiningMethod;
    }

    public static List<String> getValidGenes(List<String> genes) throws SAXException, DataStoreException, ApplicationException {
        ArrayList<String> validGenes = new ArrayList<String>();
        for (String geneName : genes) {
            if (!GenemaniaInfoRetriever.validGene(geneName)) continue;
            validGenes.add(geneName);
        }
        return validGenes;
    }

    private static boolean validGene(String geneName) throws SAXException, DataStoreException, ApplicationException {
        Gene gene = data.getCompletionProvider(human).getGene(geneName);
        return gene != null;
    }

    private Organism getHumanOrganism(DataSet data) throws DataStoreException {
        String human = "H. Sapiens";
        human = human.toLowerCase();
        List organisms = data.getMediatorProvider().getOrganismMediator().getAllOrganisms();
        for (Organism organism : organisms) {
            String organismName = organism.getName();
            String organismAlias = organism.getAlias();
            if (!organismName.toLowerCase().equals(human) && !organismAlias.toLowerCase().equals(human)) continue;
            return organism;
        }
        return null;
    }

    static {
        LOG = LogFactory.getLog(GenemaniaInfoRetriever.class);
        sequenceNumbers = new HashMap<Long, Integer>();
    }

    private static class GeneManiaDownloadTask
    extends DownloadTask {
        public GeneManiaDownloadTask(String url, String dstPath, String msg) throws IOException {
            super(url, dstPath, msg);
        }

        @Override
        protected Void runInBackground() {
            super.runInBackground();
            if (this.isCancelled()) {
                return null;
            }
            this.setStatusMessage("Extracting GeneMANIA files...");
            GenemaniaInfoRetriever.extractGM(this.getDestPath());
            return null;
        }

        @Override
        public void jobDone() {
            super.jobDone();
            MedSavantFrame.getInstance().showNotficationMessage("GeneMANIA has finished downloading, and is ready to use.");
        }
    }

    public static class NoRelatedGenesInfoException
    extends Exception {
        public NoRelatedGenesInfoException() {
            super("No network information found for this gene(s) in GeneMANIA");
        }
    }
}

