/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.filter.SearchBar;
import org.ut.biolab.medsavant.client.query.QueryViewController;
import org.ut.biolab.medsavant.client.view.component.SplitScreenPanel;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.OtherIndividualsSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.VariantFrequencyAggregatePane;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.Cohort;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class OtherIndividualsGeneSubInspector
extends OtherIndividualsSubInspector
implements Listener<Object> {
    private static final Log LOG = LogFactory.getLog(OtherIndividualsGeneSubInspector.class);
    private static final int MIDDLE_LEVEL_INDENT = 10;
    private static final int MAX_GENENAME_LENGTH_TODISPLAY = 15;
    private static final String[] COLUMN_NAMES_IN_AGGREGATE_TABLE = new String[]{"Position", "Ref.", "Alt.", BasicVariantColumns.ZYGOSITY.getAlias()};
    private Gene currentGene;

    @Override
    protected JPanel getIndividualSummaryPanel(String dnaID) {
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        Set<VariantRecord> variantRecords = this.getVariantRecords(dnaID);
        TreeMap<Long, HashSet<VariantRecord>> positionVariantMap = new TreeMap<Long, HashSet<VariantRecord>>();
        for (VariantRecord variantRecord : variantRecords) {
            HashSet<VariantRecord> variantsAtPosition = (HashSet<VariantRecord>)positionVariantMap.get(variantRecord.getStartPosition());
            if (variantsAtPosition == null) {
                variantsAtPosition = new HashSet<VariantRecord>();
            }
            variantsAtPosition.add(variantRecord);
            positionVariantMap.put(variantRecord.getStartPosition(), variantsAtPosition);
        }
        for (Map.Entry entry : positionVariantMap.entrySet()) {
            Long pos = (Long)entry.getKey();
            Set variantsAtPosition = (Set)entry.getValue();
            for (final VariantRecord variantRecord : variantsAtPosition) {
                final JPanel rowContainer = new JPanel();
                rowContainer.setLayout(new BoxLayout(rowContainer, 1));
                final JPanel row = new JPanel();
                row.setLayout(new BoxLayout(row, 0));
                row.setBorder(new EmptyBorder(0, 10, 0, 0));
                final JLabel showDetailsButton = ViewUtil.createIconButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.EXPAND));
                String posStr = NumberFormat.getNumberInstance().format(pos);
                JLabel rowTitle = new JLabel(" " + variantRecord.getZygosity().name() + " " + (Object)((Object)variantRecord.getType()) + " @ " + posStr);
                row.add(showDetailsButton);
                row.add(rowTitle);
                row.add(Box.createHorizontalGlue());
                rowContainer.add(row);
                outerPanel.add(rowContainer);
                showDetailsButton.addMouseListener(new MouseAdapter(){
                    private boolean expanded = true;

                    @Override
                    public void mousePressed(MouseEvent me) {
                        if (this.expanded) {
                            showDetailsButton.setIcon(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.COLLAPSE));
                            int last_level_indent = 10 + IconFactory.getInstance().getIcon(IconFactory.StandardIcon.EXPAND).getIconWidth() + rowContainer.getFontMetrics(rowContainer.getFont()).charWidth(' ');
                            JPanel p = new JPanel();
                            p.setLayout(new BoxLayout(p, 1));
                            p.setBorder(new EmptyBorder(0, last_level_indent, 0, 0));
                            JPanel textPanel = new JPanel();
                            textPanel.setLayout(new BoxLayout(textPanel, 0));
                            textPanel.add(new JLabel("Ref: " + variantRecord.getRef()));
                            textPanel.add(Box.createHorizontalGlue());
                            p.add(textPanel);
                            textPanel = new JPanel();
                            textPanel.setLayout(new BoxLayout(textPanel, 0));
                            textPanel.add(new JLabel("Alt: " + variantRecord.getAlt()));
                            textPanel.add(Box.createHorizontalGlue());
                            p.add(textPanel);
                            rowContainer.add(p);
                        } else {
                            showDetailsButton.setIcon(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.EXPAND));
                            rowContainer.removeAll();
                            rowContainer.add(row);
                        }
                        rowContainer.revalidate();
                        rowContainer.repaint();
                        this.expanded = !this.expanded;
                    }
                });
            }
        }
        return outerPanel;
    }

    @Override
    public boolean setObject(Object obj) {
        if (obj instanceof Gene) {
            if (this.currentGene == (Gene)obj) {
                return false;
            }
            this.currentGene = (Gene)obj;
            return true;
        }
        return false;
    }

    @Override
    protected synchronized List<Object[]> getQueryResults() {
        QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
        GenomicRegion gr = new GenomicRegion("", this.currentGene.getChrom(), this.currentGene.getStart(), this.currentGene.getEnd());
        List<Object[]> results = qvc.restrictToRegion(gr, null, 1000);
        return results;
    }

    @Override
    public String getName() {
        return "Individuals with a variant in this gene";
    }

    public OtherIndividualsGeneSubInspector(SplitScreenPanel splitScreenPanel) {
        super(splitScreenPanel);
        VariantFrequencyAggregatePane ap = new VariantFrequencyAggregatePane(COLUMN_NAMES_IN_AGGREGATE_TABLE){

            @Override
            public Object[] getRow(Cohort cohort, String familyId, VariantRecord variantRecord) {
                return new Object[]{variantRecord.getStartPosition(), variantRecord.getRef(), variantRecord.getAlt(), variantRecord.getZygosity()};
            }

            @Override
            public String getTitle(String currentFirstColumn) {
                String geneName = "this gene";
                if (OtherIndividualsGeneSubInspector.this.currentGene != null) {
                    geneName = "gene " + OtherIndividualsGeneSubInspector.this.currentGene.getName();
                }
                if (geneName.length() > 15) {
                    geneName = "this gene";
                }
                if (currentFirstColumn.equals(BasicPatientColumns.FAMILY_ID.getAlias())) {
                    return "Variants within " + geneName + " by Family";
                }
                return "Variants within " + geneName + " by Cohort";
            }

            @Override
            public void selectVariant(VariantRecord variantRecord) {
                OtherIndividualsGeneSubInspector.this.selectVariant(variantRecord);
            }
        };
        this.init(ap);
    }
}

