/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.Searcher;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class SearchSubInspector
extends SubInspector
implements Listener<VariantRecord> {
    private static final Log LOG = LogFactory.getLog(SearchSubInspector.class);
    private final String name;
    private ButtonGroup bg;
    private JRadioButton pmButton;
    private JRadioButton googleButton;
    private JRadioButton scholarButton;
    private JTextField field;

    public SearchSubInspector() {
        this.name = "Search";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean showHeader() {
        return false;
    }

    @Override
    public JPanel getInfoPanel() {
        this.bg = new ButtonGroup();
        JPanel buttonPanel = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(buttonPanel);
        this.googleButton = this.makeWhite("Google");
        this.googleButton.setSelected(true);
        this.googleButton.setOpaque(false);
        buttonPanel.add(this.googleButton);
        this.scholarButton = this.makeWhite("Scholar");
        this.scholarButton.setOpaque(false);
        buttonPanel.add(this.scholarButton);
        this.pmButton = this.makeWhite("PubMed");
        this.pmButton.setOpaque(false);
        buttonPanel.add(this.pmButton);
        this.field = new JTextField();
        this.field.setPreferredSize(new Dimension(200, 22));
        this.field.setMaximumSize(new Dimension(200, 22));
        JPanel searchContainer = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(searchContainer);
        JButton searchButton = new JButton("Search");
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchSubInspector.this.performSearchAction();
            }
        });
        searchContainer.add(this.field);
        searchContainer.add(searchButton);
        JPanel p = new JPanel();
        p.setBorder(ViewUtil.getMediumBorder());
        ViewUtil.applyVerticalBoxLayout(p);
        p.add(buttonPanel);
        p.add(ViewUtil.centerHorizontally(searchContainer));
        return p;
    }

    private JRadioButton makeWhite(String string) {
        JRadioButton b = new JRadioButton(string);
        this.bg.add(b);
        return b;
    }

    private void performSearchAction() {
        try {
            if (this.googleButton.isSelected()) {
                Searcher.searchGoogle(this.field.getText());
            } else if (this.scholarButton.isSelected()) {
                Searcher.searchGoogleScholar(this.field.getText());
            } else if (this.pmButton.isSelected()) {
                Searcher.searchPubmed(this.field.getText());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error searching.", (Throwable)ex);
            DialogUtils.displayErrorMessage("Problem searching", ex);
        }
    }

    @Override
    public void handleEvent(VariantRecord r) {
        if (r.getDbSNPID() == null || r.getDbSNPID().equals("")) {
            this.field.setText(r.getChrom() + " " + r.getStartPosition() + "-" + r.getEndPosition());
        } else {
            this.field.setText(r.getDbSNPID());
        }
    }
}

