/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.login;

import java.io.Serializable;
import java.util.UUID;
import org.ut.biolab.medsavant.client.util.CryptoUtils;

public final class MedSavantServerInfo
implements Serializable,
Comparable<MedSavantServerInfo> {
    private String uniqueID;
    private String host;
    private int port;
    private String database;
    private String nickname;
    private String username;
    private String encodedPassword;
    private boolean rememberPassword;
    private boolean isEditable = true;

    public MedSavantServerInfo() {
        this("", 0, "", "Unnamed Server");
    }

    public MedSavantServerInfo(String host, int port, String database, String nickname) {
        this(host, port, database, nickname, null);
    }

    private MedSavantServerInfo(String host, int port, String database, String nickname, String uniqueID) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.nickname = nickname;
        this.username = "";
        this.encodedPassword = "";
        this.rememberPassword = false;
        this.uniqueID = uniqueID == null ? UUID.randomUUID().toString() : uniqueID;
    }

    public MedSavantServerInfo(MedSavantServerInfo server) {
        this(server.host, server.port, server.database, server.nickname, server.uniqueID);
        this.setEditable(server.isEditable);
        this.setUsername(server.username);
        this.setPassword(CryptoUtils.decrypt(server.encodedPassword));
        this.setRememberPassword(server.rememberPassword);
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    private void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
        System.out.println("SETTING UUID " + this.getUniqueID() + " NICKNAME TO " + this.getNickname());
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.encodedPassword = CryptoUtils.encrypt(password);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return CryptoUtils.decrypt(this.encodedPassword);
    }

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.rememberPassword = rememberPassword;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public String toString() {
        return this.getNickname();
    }

    @Override
    public int compareTo(MedSavantServerInfo o) {
        return this.getUniqueID().compareTo(o.getUniqueID());
    }
}

